/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataMapListener;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.GeneratorsPanel;
import org.apache.cayenne.modeler.editor.GeneratorsTab;
import org.apache.cayenne.project.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneratorsTabController<T>
implements DataMapListener {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GeneratorsTabController.class);
    private final ProjectController projectController;
    private final ConcurrentMap<DataMap, GeneratorsPanel> generatorsPanels = new ConcurrentHashMap<DataMap, GeneratorsPanel>();
    private final Set<DataMap> selectedDataMaps = new HashSet<DataMap>();
    private final Class<T> type;
    private final boolean selectAllByDefault;
    protected GeneratorsTab view;

    public GeneratorsTabController(ProjectController projectController, Class<T> type, boolean selectAllByDefault) {
        this.type = type;
        this.selectAllByDefault = selectAllByDefault;
        this.projectController = projectController;
        this.projectController.addDataMapListener(this);
    }

    private boolean isSelectAllChecked() {
        return this.view.getGenerationPanel().getSelectAll().isSelected();
    }

    public abstract void runGenerators(Set<DataMap> var1);

    void createPanels() {
        Collection<DataMap> dataMaps = this.getDataMaps();
        this.refreshSelectedMaps(dataMaps);
        this.generatorsPanels.clear();
        for (DataMap dataMap2 : dataMaps) {
            GeneratorsPanel generatorPanel = new GeneratorsPanel(dataMap2, "icon-datamap.png", this.type);
            this.initListenersForPanel(generatorPanel);
            this.generatorsPanels.put(dataMap2, generatorPanel);
        }
        this.selectedDataMaps.forEach(dataMap -> {
            if (this.generatorsPanels.get(dataMap) != null) {
                GeneratorsPanel currPanel = (GeneratorsPanel)this.generatorsPanels.get(dataMap);
                currPanel.getCheckConfig().setSelected(true);
            }
        });
        if (this.selectedDataMaps.isEmpty() && this.selectAllByDefault) {
            GeneratorsTab.TopGeneratorPanel topGeneratorPanel = this.view.getGenerationPanel();
            topGeneratorPanel.getSelectAll().setSelected(true);
            topGeneratorPanel.getGenerateAll().setEnabled(true);
            for (Map.Entry entry : this.generatorsPanels.entrySet()) {
                ((GeneratorsPanel)entry.getValue()).getCheckConfig().setSelected(true);
            }
        }
    }

    private void initListenersForPanel(GeneratorsPanel panel) {
        panel.getCheckConfig().addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.selectedDataMaps.add(panel.getDataMap());
                if (this.selectedDataMaps.size() == this.generatorsPanels.size()) {
                    this.view.getGenerationPanel().getSelectAll().setSelected(true);
                }
            } else if (e.getStateChange() == 2) {
                this.selectedDataMaps.remove(panel.getDataMap());
                this.view.getGenerationPanel().getSelectAll().setSelected(false);
            }
            this.setGenerateButtonDisabled();
        });
        panel.getToConfigButton().addActionListener(action -> this.showConfig(panel.getDataMap()));
        this.view.getGenerationPanel().getSelectAll().addActionListener(e -> {
            boolean isSelected = this.view.getGenerationPanel().getSelectAll().isSelected();
            if (isSelected) {
                this.getGeneratorsPanels().forEach((key, value) -> {
                    if (value.getCheckConfig().isEnabled()) {
                        value.getCheckConfig().setSelected(true);
                    }
                });
            } else {
                this.getGeneratorsPanels().forEach((key, value) -> {
                    if (value.getCheckConfig().isEnabled()) {
                        value.getCheckConfig().setSelected(false);
                    }
                });
            }
            this.setGenerateButtonDisabled();
        });
    }

    public abstract void showConfig(DataMap var1);

    private void setGenerateButtonDisabled() {
        if (this.selectedDataMaps.isEmpty()) {
            this.view.getGenerationPanel().getGenerateAll().setEnabled(false);
        } else {
            this.view.getGenerationPanel().getGenerateAll().setEnabled(true);
        }
    }

    private Collection<DataMap> getDataMaps() {
        Project project = this.projectController.getProject();
        return ((DataChannelDescriptor)project.getRootNode()).getDataMaps();
    }

    public GeneratorsTab getView() {
        return this.view;
    }

    public ProjectController getProjectController() {
        return this.projectController;
    }

    ConcurrentMap<DataMap, GeneratorsPanel> getGeneratorsPanels() {
        return this.generatorsPanels;
    }

    Set<DataMap> getSelectedDataMaps() {
        return this.selectedDataMaps;
    }

    private void refreshSelectedMaps(Collection<DataMap> dataMaps) {
        this.selectedDataMaps.removeIf(dataMap -> !dataMaps.contains(dataMap));
    }

    @Override
    public void dataMapAdded(DataMapEvent e) {
        GeneratorsPanel generatorPanel = new GeneratorsPanel(e.getDataMap(), "icon-datamap.png", this.type);
        this.initListenersForPanel(generatorPanel);
        this.generatorsPanels.put(e.getDataMap(), generatorPanel);
        if (this.isSelectAllChecked()) {
            generatorPanel.getCheckConfig().setSelected(true);
            this.selectedDataMaps.add(e.getDataMap());
        }
    }

    @Override
    public void dataMapRemoved(DataMapEvent e) {
        this.selectedDataMaps.remove(e.getDataMap());
        this.generatorsPanels.remove(e.getDataMap());
    }

    @Override
    public void dataMapChanged(DataMapEvent e) {
    }
}

