/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.RemoveAttributeAction;
import org.apache.cayenne.modeler.action.RemoveCallbackMethodAction;
import org.apache.cayenne.modeler.action.RemoveRelationshipAction;
import org.apache.cayenne.modeler.editor.AbstractCallbackMethodsTab;
import org.apache.cayenne.modeler.editor.ExistingSelectionProcessor;
import org.apache.cayenne.modeler.editor.ObjEntityAttributePanel;
import org.apache.cayenne.modeler.editor.ObjEntityAttributeRelationshipTab;
import org.apache.cayenne.modeler.editor.ObjEntityCallbackMethodsTab;
import org.apache.cayenne.modeler.editor.ObjEntityRelationshipPanel;
import org.apache.cayenne.modeler.editor.ObjEntityTab;
import org.apache.cayenne.modeler.event.AttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjAttributeDisplayListener;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ObjRelationshipDisplayListener;
import org.apache.cayenne.modeler.event.RelationshipDisplayEvent;

public class ObjEntityTabbedView
extends JTabbedPane
implements ObjEntityDisplayListener,
ObjRelationshipDisplayListener,
ObjAttributeDisplayListener {
    protected ProjectController projectController;
    protected Component entityPanel;
    protected ObjEntityAttributeRelationshipTab attributeRelationshipTab;
    protected AbstractCallbackMethodsTab callbacksPanel;

    public ObjEntityTabbedView(ProjectController projectController) {
        this.projectController = projectController;
        this.initView();
        this.initController();
    }

    private void initView() {
        this.setTabPlacement(1);
        this.entityPanel = new JScrollPane(new ObjEntityTab(this.projectController));
        this.addTab("Entity", this.entityPanel);
        this.attributeRelationshipTab = new ObjEntityAttributeRelationshipTab(this.projectController);
        this.addTab("Properties", this.attributeRelationshipTab);
        this.callbacksPanel = new ObjEntityCallbackMethodsTab(this.projectController);
        this.addTab("Callbacks", this.callbacksPanel);
    }

    private void initController() {
        this.projectController.addObjEntityDisplayListener(this);
        this.projectController.addObjAttributeDisplayListener(this);
        this.projectController.addObjRelationshipDisplayListener(this);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ObjEntityTabbedView.this.resetRemoveButtons();
                ObjEntityTabbedView.this.projectController.setEntityTabSelection(ObjEntityTabbedView.this.getSelectedIndex());
                Component selected = ObjEntityTabbedView.this.getSelectedComponent();
                while (selected instanceof JScrollPane) {
                    selected = ((JScrollPane)selected).getViewport().getView();
                }
                if (selected instanceof ExistingSelectionProcessor) {
                    ((ExistingSelectionProcessor)((Object)selected)).processExistingSelection(e);
                }
            }
        });
    }

    private void resetRemoveButtons() {
        ActionManager actionManager = Application.getInstance().getActionManager();
        actionManager.getAction(RemoveAttributeAction.class).setEnabled(false);
        actionManager.getAction(RemoveRelationshipAction.class).setEnabled(false);
        actionManager.getAction(RemoveCallbackMethodAction.class).setEnabled(false);
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        Entity<?, ?, ?> entity = e.getEntity();
        if (e.isMainTabFocus() && entity instanceof ObjEntity && this.getSelectedComponent() != this.entityPanel) {
            this.setSelectedComponent(this.entityPanel);
            this.entityPanel.setVisible(true);
        }
        this.resetRemoveButtons();
        this.setVisible(e.getEntity() != null);
        if (this.getRootPane() != null && this.projectController.getEntityTabSelection() < this.getTabCount()) {
            this.setSelectedIndex(this.projectController.getEntityTabSelection());
        }
    }

    @Override
    public void currentObjRelationshipChanged(RelationshipDisplayEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        Relationship<?, ?, ?>[] rels = e.getRelationships();
        Object[] objRels = new ObjRelationship[rels.length];
        System.arraycopy(rels, 0, objRels, 0, rels.length);
        if (this.getSelectedComponent() != this.attributeRelationshipTab.getSplitPane().getComponent(1) && objRels.length > 0) {
            this.setSelectedComponent(this.attributeRelationshipTab);
            this.attributeRelationshipTab.getSplitPane().getComponent(1).setVisible(true);
        }
        ((ObjEntityRelationshipPanel)this.attributeRelationshipTab.getSplitPane().getComponent(1)).selectRelationships((ObjRelationship[])objRels);
        this.attributeRelationshipTab.updateActions(objRels);
    }

    @Override
    public void currentObjAttributeChanged(AttributeDisplayEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        Attribute<?, ?, ?>[] attrs = e.getAttributes();
        Object[] objAttrs = new ObjAttribute[attrs.length];
        System.arraycopy(attrs, 0, objAttrs, 0, attrs.length);
        if (this.getSelectedComponent() != this.attributeRelationshipTab.getSplitPane().getComponent(0) && objAttrs.length > 0) {
            this.setSelectedComponent(this.attributeRelationshipTab);
            this.attributeRelationshipTab.getSplitPane().getComponent(0).setVisible(true);
        }
        ((ObjEntityAttributePanel)this.attributeRelationshipTab.getSplitPane().getComponent(0)).selectAttributes((ObjAttribute[])objAttrs);
        this.attributeRelationshipTab.updateActions(objAttrs);
    }

    public ObjEntityAttributeRelationshipTab getAttributeRelationshipTab() {
        return this.attributeRelationshipTab;
    }
}

