/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.firebird;

import java.util.ArrayList;
import org.apache.cayenne.access.sqlbuilder.ExpressionNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.QuotingAppendable;
import org.apache.cayenne.access.sqlbuilder.SQLBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.InNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.LimitOffsetNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;
import org.apache.cayenne.access.sqlbuilder.sqltree.OpExpressionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.TextNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ValueNode;
import org.apache.cayenne.access.translator.select.BaseSQLTreeProcessor;
import org.apache.cayenne.dba.firebird.sqltree.FirebirdLimitNode;
import org.apache.cayenne.dba.firebird.sqltree.FirebirdSubstringFunctionNode;
import org.apache.cayenne.util.ArrayUtil;

public class FirebirdSQLTreeProcessor
extends BaseSQLTreeProcessor {
    private static final int FIREBIRD_IN_BATCH_SIZE = 1500;

    @Override
    protected void onValueNode(Node parent, ValueNode child, int index) {
        FirebirdSQLTreeProcessor.replaceChild(parent, index, new ValueNode(child.getValue(), child.isArray(), child.getAttribute()){

            @Override
            protected void appendStringValue(QuotingAppendable buffer, CharSequence value) {
                buffer.append("CAST(");
                super.appendStringValue(buffer, value);
                buffer.append(" AS VARCHAR(").append(value.length()).append("))");
            }
        });
    }

    @Override
    protected void onLimitOffsetNode(Node parent, LimitOffsetNode child, int index) {
        if (child.getLimit() == 0 && child.getOffset() == 0) {
            return;
        }
        int from = child.getOffset() + 1;
        int to = child.getLimit() == 0 ? Integer.MAX_VALUE : from + child.getLimit();
        FirebirdSQLTreeProcessor.replaceChild(parent, index, new FirebirdLimitNode(from, to));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onInNode(Node parent, InNode child, int index) {
        void var9_20;
        int n;
        int n2;
        Object[] slice2;
        Node arg = child.getChild(0);
        Node childNode = child.getChild(1);
        if (childNode.getType() != NodeType.VALUE) {
            return;
        }
        ValueNode valueNode = (ValueNode)childNode;
        Object value = valueNode.getValue();
        if (!value.getClass().isArray()) {
            return;
        }
        ArrayList<InNode> newChildren = new ArrayList<InNode>();
        if (value instanceof Object[]) {
            for (Object[] slice2 : ArrayUtil.sliceArray((Object[])value, 1500)) {
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof int[]) {
            int[][] nArray = ArrayUtil.sliceArray((int[])value, 1500);
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = nArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof long[]) {
            long[][] lArray = ArrayUtil.sliceArray((long[])value, 1500);
            n2 = lArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = lArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof float[]) {
            float[][] fArray = ArrayUtil.sliceArray((float[])value, 1500);
            n2 = fArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = fArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof double[]) {
            double[][] dArray = ArrayUtil.sliceArray((double[])value, 1500);
            n2 = dArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = dArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof short[]) {
            short[][] sArray = ArrayUtil.sliceArray((short[])value, 1500);
            n2 = sArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = sArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof char[]) {
            char[][] cArray = ArrayUtil.sliceArray((char[])value, 1500);
            n2 = cArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = cArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof boolean[]) {
            boolean[][] blArray = ArrayUtil.sliceArray((boolean[])value, 1500);
            n2 = blArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = blArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        } else if (value instanceof byte[]) {
            byte[][] byArray = ArrayUtil.sliceArray((byte[])value, 1500);
            n2 = byArray.length;
            for (n = 0; n < n2; ++n) {
                slice2 = byArray[n];
                newChildren.add(this.newSliceNode(child, arg, valueNode, slice2));
            }
        }
        ExpressionNodeBuilder expressionNodeBuilder = SQLBuilder.exp(SQLBuilder.node((Node)newChildren.get(0)));
        for (int i = 1; i < newChildren.size(); ++i) {
            ExpressionNodeBuilder expressionNodeBuilder2 = var9_20.or(SQLBuilder.node((Node)newChildren.get(i)));
        }
        parent.replaceChild(index, var9_20.build());
    }

    private InNode newSliceNode(InNode child, Node arg, ValueNode valueNode, Object slice) {
        InNode nextNode = new InNode(child.isNot());
        nextNode.addChild((Node)arg.deepCopy());
        nextNode.addChild(new ValueNode(slice, valueNode.isArray(), valueNode.getAttribute()));
        return nextNode;
    }

    @Override
    protected void onFunctionNode(Node parent, FunctionNode child, int index) {
        switch (child.getFunctionName()) {
            case "LENGTH": {
                FirebirdSQLTreeProcessor.replaceChild(parent, index, new FunctionNode("CHAR_LENGTH", child.getAlias()));
                break;
            }
            case "LOCATE": {
                FirebirdSQLTreeProcessor.replaceChild(parent, index, new FunctionNode("POSITION", child.getAlias()));
                break;
            }
            case "CONCAT": {
                FirebirdSQLTreeProcessor.replaceChild(parent, index, new OpExpressionNode("||"));
                break;
            }
            case "SUBSTRING": {
                FirebirdSQLTreeProcessor.replaceChild(parent, index, new FirebirdSubstringFunctionNode(child.getAlias()));
                break;
            }
            case "YEAR": 
            case "MONTH": 
            case "DAY": 
            case "DAY_OF_MONTH": 
            case "DAY_OF_WEEK": 
            case "DAY_OF_YEAR": 
            case "WEEK": 
            case "HOUR": 
            case "MINUTE": 
            case "SECOND": {
                FunctionNode functionReplacement = new FunctionNode("EXTRACT", child.getAlias(), true){

                    @Override
                    public void appendChildrenSeparator(QuotingAppendable buffer, int childIdx) {
                        buffer.append(' ');
                    }
                };
                String partName = child.getFunctionName();
                if ("DAY_OF_MONTH".equals(partName)) {
                    partName = "DAY";
                } else if ("DAY_OF_WEEK".equals(partName)) {
                    partName = "WEEKDAY";
                } else if ("DAY_OF_YEAR".equals(partName)) {
                    partName = "YEARDAY";
                }
                functionReplacement.addChild(new TextNode(partName + " FROM "));
                FirebirdSQLTreeProcessor.replaceChild(parent, index, functionReplacement);
            }
        }
    }
}

