/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.MultipleObjectsAction;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.reflect.PropertyUtils;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.value.GeoJson;
import org.apache.cayenne.value.Json;
import org.apache.cayenne.value.Wkt;

public final class ModelerUtil {
    public static String getObjectName(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CayenneMapEntry) {
            return ((CayenneMapEntry)object).getName();
        }
        if (object instanceof String) {
            return (String)object;
        }
        try {
            return (String)PropertyUtils.getProperty(object, "name");
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static ImageIcon buildIcon(String path) {
        ClassLoader cl = ModelerUtil.class.getClassLoader();
        URL url = cl.getResource("org/apache/cayenne/modeler/images/" + path);
        return new ImageIcon(url);
    }

    public static Collection<String> getDbAttributeNames(DbEntity entity) {
        Set<String> keys = entity.getAttributeMap().keySet();
        ArrayList<String> list = new ArrayList<String>(keys.size() + 1);
        list.add("");
        list.addAll(keys);
        return list;
    }

    public static String[] getRegisteredTypeNames() {
        Object[] nonPrimitivesNames = new String[]{String.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Date.class.getName(), java.util.Date.class.getName(), Double.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), Time.class.getName(), Timestamp.class.getName(), GregorianCalendar.class.getName(), Calendar.class.getName(), UUID.class.getName(), Serializable.class.getName(), Json.class.getName(), Wkt.class.getName(), GeoJson.class.getName(), "java.lang.Character[]", "java.lang.Byte[]", "java.time.LocalDate", "java.time.LocalTime", "java.time.LocalDateTime", "java.time.Duration", "java.time.Period"};
        Arrays.sort(nonPrimitivesNames);
        String[] primitivesNames = new String[]{"boolean", "byte", "byte[]", "char", "char[]", "double", "float", "int", "long", "short"};
        String[] finalList = new String[primitivesNames.length + nonPrimitivesNames.length + 1];
        finalList[0] = "";
        System.arraycopy(primitivesNames, 0, finalList, 1, primitivesNames.length);
        System.arraycopy(nonPrimitivesNames, 0, finalList, primitivesNames.length + 1, nonPrimitivesNames.length);
        return finalList;
    }

    public static DataNodeDescriptor getNodeLinkedToMap(DataChannelDescriptor domain, DataMap map) {
        Collection<DataNodeDescriptor> nodes = domain.getNodeDescriptors();
        for (DataNodeDescriptor node : nodes) {
            if (!node.getDataMapNames().contains(map.getName())) continue;
            return node;
        }
        return null;
    }

    public static void updateActions(int numSelected, Class<? extends Action> ... actions) {
        ActionManager actionManager = Application.getInstance().getActionManager();
        for (Class<? extends Action> actionType : actions) {
            Action action = actionManager.getAction(actionType);
            if (!(action instanceof MultipleObjectsAction)) continue;
            MultipleObjectsAction multiObjectAction = (MultipleObjectsAction)action;
            multiObjectAction.setEnabled(numSelected > 0);
            ((CayenneAction)((Object)multiObjectAction)).setName(multiObjectAction.getActionName(numSelected > 1));
        }
    }

    public static String getProperty(String key) {
        ResourceBundle properties = ResourceBundle.getBundle("org.apache.cayenne.modeler.cayennemodeler-strings");
        return properties == null ? "" : properties.getString(key);
    }

    public static void centerWindow(Window parent, Window child) {
        Dimension parentSize = parent.getSize();
        Dimension childSize = child.getSize();
        Point parentLocation = new Point(0, 0);
        if (parent.isShowing()) {
            parentLocation = parent.getLocationOnScreen();
        }
        int x = parentLocation.x + parentSize.width / 2 - childSize.width / 2;
        int y = parentLocation.y + parentSize.height / 2 - childSize.height / 2;
        child.setLocation(x, y);
    }

    public static String initOutputFolder() {
        if (System.getProperty("cayenne.cgen.destdir") != null) {
            return System.getProperty("cayenne.cgen.destdir");
        }
        FSPath lastPath = Application.getInstance().getFrameController().getLastDirectory();
        String path = ModelerUtil.checkDefaultMavenResourceDir(lastPath, "test");
        if (path != null || (path = ModelerUtil.checkDefaultMavenResourceDir(lastPath, "main")) != null) {
            return path;
        }
        File lastDir = lastPath.getExistingDirectory(false);
        return lastDir != null ? lastDir.getAbsolutePath() : ".";
    }

    private static String checkDefaultMavenResourceDir(FSPath lastPath, String dirType) {
        String path = lastPath.getPath();
        String resourcePath = ModelerUtil.buildFilePath("src", dirType, "resources");
        int idx = path.indexOf(resourcePath);
        if (idx < 0) {
            return null;
        }
        return path.substring(0, idx) + ModelerUtil.buildFilePath("src", dirType, "java");
    }

    private static String buildFilePath(String ... pathElements) {
        if (pathElements.length == 0) {
            return "";
        }
        StringBuilder path = new StringBuilder(pathElements[0]);
        for (int i = 1; i < pathElements.length; ++i) {
            path.append(File.separator).append(pathElements[i]);
        }
        return path.toString();
    }
}

