/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.value.json;

import org.apache.cayenne.value.json.AbstractJsonConsumer;
import org.apache.cayenne.value.json.JsonTokenizer;

class JsonFormatter
extends AbstractJsonConsumer<String> {
    private final StringBuilder builder = new StringBuilder();

    JsonFormatter(String json) {
        super(json);
    }

    @Override
    protected void onArrayStart() {
        this.builder.append('[');
    }

    @Override
    protected void onArrayEnd() {
        if (this.builder.charAt(this.builder.length() - 1) == ' ') {
            this.builder.delete(this.builder.length() - 2, this.builder.length());
        }
        this.builder.append(']');
    }

    @Override
    protected void onObjectStart() {
        this.builder.append('{');
    }

    @Override
    protected void onObjectEnd() {
        if (this.builder.charAt(this.builder.length() - 1) == ' ') {
            this.builder.delete(this.builder.length() - 2, this.builder.length());
        }
        this.builder.append('}');
    }

    @Override
    protected void onArrayValue(JsonTokenizer.JsonToken token) {
        this.appendToken(token);
        this.builder.append(", ");
    }

    @Override
    protected void onObjectKey(JsonTokenizer.JsonToken token) {
        this.appendToken(token);
        this.builder.append(": ");
    }

    @Override
    protected void onObjectValue(JsonTokenizer.JsonToken token) {
        this.appendToken(token);
        this.builder.append(", ");
    }

    @Override
    protected void onValue(JsonTokenizer.JsonToken token) {
        this.appendToken(token);
    }

    @Override
    protected String output() {
        return this.builder.toString();
    }

    private void appendToken(JsonTokenizer.JsonToken token) {
        if (token.type == JsonTokenizer.TokenType.STRING) {
            this.builder.append('\"');
        }
        this.builder.append(token.getData(), token.from, token.to - token.from);
        if (token.type == JsonTokenizer.TokenType.STRING) {
            this.builder.append('\"');
        }
    }
}

