/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorController;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.validation.ValidationException;

public class GeneratorControllerPanel
extends JPanel {
    protected TextAdapter outputFolder;
    protected JButton selectOutputFolder;
    protected ProjectController projectController;

    public GeneratorControllerPanel(final ProjectController projectController, final CodeGeneratorController codeGeneratorControllerBase) {
        this.projectController = projectController;
        this.outputFolder = new TextAdapter(new JTextField()){

            @Override
            protected void updateModel(String text) throws ValidationException {
                CgenConfiguration cgenByDataMap = GeneratorControllerPanel.this.getCgenByDataMap();
                if (cgenByDataMap != null) {
                    cgenByDataMap.setRelPath(text);
                    if (!codeGeneratorControllerBase.isInitFromModel()) {
                        projectController.setDirty(true);
                    }
                }
            }
        };
        this.selectOutputFolder = new JButton("..");
    }

    public TextAdapter getOutputFolder() {
        return this.outputFolder;
    }

    public JButton getSelectOutputFolder() {
        return this.selectOutputFolder;
    }

    public CgenConfiguration getCgenByDataMap() {
        DataMap dataMap = this.projectController.getCurrentDataMap();
        return this.projectController.getApplication().getMetaData().get(dataMap, CgenConfiguration.class);
    }
}

