/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.table.TableColumnModel;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.editor.cgen.ClassGenerationValidator;
import org.apache.cayenne.modeler.editor.cgen.ClassesTabPanel;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorController;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ImageRendererColumn;
import org.apache.cayenne.swing.ObjectBinding;
import org.apache.cayenne.swing.TableBindingBuilder;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;

public class ClassesTabController
extends CayenneController {
    private static final Icon ERROR_ICON = ModelerUtil.buildIcon("icon-error.png");
    protected ClassesTabPanel view = new ClassesTabPanel();
    protected ObjectBinding tableBinding;
    private ValidationResult lastValidationResult;
    private BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);

    public ClassesTabController(CodeGeneratorController parent) {
        super(parent);
    }

    public void startup() {
        this.initBindings();
        this.classSelectedAction();
    }

    protected CodeGeneratorController getParentController() {
        return (CodeGeneratorController)this.getParent();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        this.builder.bindToAction(this.getParentController().getView().getCheckAll(), "checkAllAction()");
        TableBindingBuilder tableBuilder = new TableBindingBuilder(this.builder);
        tableBuilder.addColumn("", "parent.setCurrentClass(#item), selected", Boolean.class, true, Boolean.TRUE);
        tableBuilder.addColumn("Class", "getItemName(#item)", JLabel.class, false, "XXXXXXXXXXXXXXXXXXXXXXXXXX");
        tableBuilder.addColumn("", "getProblem(#item)", String.class, false, "XX");
        this.tableBinding = tableBuilder.bindToTable(this.view.getTable(), "parent.classes");
        TableColumnModel columnModel = this.view.getTable().getColumnModel();
        columnModel.getColumn(1).setCellRenderer(new ImageRendererColumn());
        columnModel.getColumn(2).setCellRenderer(new ImageRendererColumn());
    }

    public boolean isSelected() {
        return this.getParentController().isSelected();
    }

    public void setSelected(boolean selected) {
        this.getParentController().setSelected(selected);
        this.classSelectedAction();
    }

    public void classSelectedAction() {
        int selectedCount = this.getParentController().getSelectedEntitiesSize() + this.getParentController().getSelectedEmbeddablesSize() + (this.getParentController().isDataMapSelected() ? 1 : 0);
        int totalClasses = this.getParentController().getClasses().size();
        this.getParentController().enableGenerateButton(selectedCount != 0);
        this.getParentController().getView().getCheckAll().setSelected(selectedCount >= totalClasses);
        this.getParentController().updateSelectedEntities();
    }

    public void checkAllAction() {
        if (this.getParentController().updateSelection(this.getParentController().getView().getCheckAll().isSelected() ? o -> true : o -> false)) {
            this.tableBinding.updateView();
            this.getParentController().updateSelectedEntities();
            if (this.getParentController().getView().getCheckAll().isSelected()) {
                this.getParentController().enableGenerateButton(true);
            } else {
                this.getParentController().enableGenerateButton(false);
            }
        }
    }

    public void validate(List<Object> classes) {
        ClassGenerationValidator validator = new ClassGenerationValidator();
        this.lastValidationResult = validator.getValidationResult(classes);
    }

    public JLabel getProblem(Object obj) {
        List<ValidationFailure> failures;
        String name = null;
        if (obj instanceof ObjEntity) {
            name = ((ObjEntity)obj).getName();
        } else if (obj instanceof Embeddable) {
            name = ((Embeddable)obj).getClassName();
        }
        ValidationFailure validationFailure = null;
        if (this.lastValidationResult != null && !(failures = this.lastValidationResult.getFailures(name)).isEmpty()) {
            validationFailure = failures.get(0);
        }
        JLabel labelIcon = new JLabel();
        labelIcon.setVisible(true);
        if (validationFailure != null) {
            labelIcon.setIcon(ERROR_ICON);
            labelIcon.setToolTipText(validationFailure.getDescription());
        }
        return labelIcon;
    }

    public JLabel getItemName(Object obj) {
        Icon icon;
        String className;
        if (obj instanceof Embeddable) {
            className = ((Embeddable)obj).getClassName();
            icon = CellRenderers.iconForObject(new Embeddable());
        } else if (obj instanceof ObjEntity) {
            className = ((ObjEntity)obj).getName();
            icon = CellRenderers.iconForObject(new ObjEntity());
        } else {
            className = ((DataMap)obj).getName();
            icon = CellRenderers.iconForObject(new DataMap());
        }
        JLabel labelIcon = new JLabel();
        labelIcon.setIcon(icon);
        labelIcon.setVisible(true);
        labelIcon.setText(className);
        return labelIcon;
    }
}

