/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DbAdapterDetector;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.configuration.server.PkGeneratorFactoryProvider;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.log.JdbcEventLogger;

public class DefaultDbAdapterFactory
implements DbAdapterFactory {
    @Inject
    protected Injector injector;
    @Inject
    protected JdbcEventLogger jdbcEventLogger;
    @Inject
    protected AdhocObjectFactory objectFactory;
    @Inject
    protected PkGeneratorFactoryProvider pkGeneratorProvider;
    protected List<DbAdapterDetector> detectors;

    public DefaultDbAdapterFactory(@Inject(value="cayenne.server.adapter_detectors") List<DbAdapterDetector> detectors) {
        if (detectors == null) {
            throw new NullPointerException("Null detectors list");
        }
        this.detectors = detectors;
    }

    @Override
    public DbAdapter createAdapter(DataNodeDescriptor nodeDescriptor, DataSource dataSource) {
        String adapterType = null;
        if (nodeDescriptor != null) {
            adapterType = nodeDescriptor.getAdapterType();
        }
        if (adapterType != null && adapterType.equals(AutoAdapter.class.getName())) {
            adapterType = null;
        }
        if (adapterType != null) {
            DbAdapter dbAdapter = this.objectFactory.newInstance(DbAdapter.class, adapterType);
            return this.setupPkGenerator(dbAdapter);
        }
        return new AutoAdapter(() -> this.detectAdapter(dataSource), this.jdbcEventLogger);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DbAdapter detectAdapter(DataSource dataSource) {
        if (this.detectors.isEmpty()) {
            return this.defaultAdapter();
        }
        try (Connection c = dataSource.getConnection();){
            DbAdapter dbAdapter = this.detectAdapter(c.getMetaData());
            return dbAdapter;
        }
        catch (SQLException e) {
            throw new CayenneRuntimeException("Error detecting database type: " + e.getLocalizedMessage(), (Throwable)e, new Object[0]);
        }
    }

    protected DbAdapter detectAdapter(DatabaseMetaData metaData) throws SQLException {
        for (int i = this.detectors.size() - 1; i >= 0; --i) {
            DbAdapterDetector detector = this.detectors.get(i);
            DbAdapter adapter = detector.createAdapter(metaData);
            if (adapter == null) continue;
            this.jdbcEventLogger.log("Detected and installed adapter: " + adapter.getClass().getName());
            this.injector.injectMembers(adapter);
            return this.setupPkGenerator(adapter);
        }
        return this.defaultAdapter();
    }

    protected DbAdapter defaultAdapter() {
        this.jdbcEventLogger.log("Failed to detect database type, using generic adapter");
        return this.objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName());
    }

    protected DbAdapter setupPkGenerator(DbAdapter dbAdapter) {
        PkGenerator pkGenerator = (PkGenerator)this.pkGeneratorProvider.get(Objects.requireNonNull(dbAdapter));
        if (pkGenerator != null) {
            pkGenerator.setAdapter(dbAdapter);
            dbAdapter.setPkGenerator(pkGenerator);
        }
        return dbAdapter;
    }
}

