/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.model;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.tools.model.IncludeTable;
import org.apache.cayenne.tools.model.PatternParam;
import org.gradle.util.ConfigureUtil;

public class FilterContainer {
    private String name;
    private Collection<IncludeTable> includeTables = new LinkedList<IncludeTable>();
    private Collection<PatternParam> excludeTables = new LinkedList<PatternParam>();
    private Collection<PatternParam> includeColumns = new LinkedList<PatternParam>();
    private Collection<PatternParam> excludeColumns = new LinkedList<PatternParam>();
    private Collection<PatternParam> includeProcedures = new LinkedList<PatternParam>();
    private Collection<PatternParam> excludeProcedures = new LinkedList<PatternParam>();
    private Collection<PatternParam> excludeRelationships = new LinkedList<PatternParam>();

    FilterContainer() {
    }

    FilterContainer(String name) {
        this.name = name;
    }

    public void name(String name) {
        this.name = name;
    }

    public void includeTable(String pattern) {
        this.includeTables.add(new IncludeTable(pattern));
    }

    public void includeTable(Closure<?> closure) {
        this.includeTables.add((IncludeTable)ConfigureUtil.configure(closure, (Object)new IncludeTable()));
    }

    public void includeTable(String pattern, Closure<?> closure) {
        this.includeTables.add((IncludeTable)ConfigureUtil.configure(closure, (Object)new IncludeTable(pattern)));
    }

    public void includeTables(String ... patterns) {
        for (String pattern : patterns) {
            this.includeTable(pattern);
        }
    }

    public void excludeTable(String pattern) {
        FilterContainer.addToCollection(this.excludeTables, pattern);
    }

    public void excludeTables(String ... patterns) {
        for (String pattern : patterns) {
            this.excludeTable(pattern);
        }
    }

    public void includeColumn(String pattern) {
        FilterContainer.addToCollection(this.includeColumns, pattern);
    }

    public void includeColumns(String ... patterns) {
        for (String pattern : patterns) {
            this.includeColumn(pattern);
        }
    }

    public void excludeColumn(String pattern) {
        FilterContainer.addToCollection(this.excludeColumns, pattern);
    }

    public void excludeColumns(String ... patterns) {
        for (String pattern : patterns) {
            this.excludeColumn(pattern);
        }
    }

    public void excludeRelationship(String pattern) {
        FilterContainer.addToCollection(this.excludeRelationships, pattern);
    }

    public void excludeRelationships(String ... patterns) {
        for (String pattern : patterns) {
            this.excludeRelationship(pattern);
        }
    }

    public void includeProcedure(String pattern) {
        FilterContainer.addToCollection(this.includeProcedures, pattern);
    }

    public void includeProcedures(String ... patterns) {
        for (String pattern : patterns) {
            this.includeProcedure(pattern);
        }
    }

    public void excludeProcedure(String pattern) {
        FilterContainer.addToCollection(this.excludeProcedures, pattern);
    }

    public void excludeProcedures(String ... patterns) {
        for (String pattern : patterns) {
            this.excludeProcedure(pattern);
        }
    }

    private static void addToCollection(Collection<PatternParam> collection, String name) {
        collection.add(new PatternParam(name));
    }

    <C extends org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer> C fillContainer(C container) {
        container.setName(this.name);
        for (IncludeTable includeTable : this.includeTables) {
            container.addIncludeTable(includeTable.toIncludeTable());
        }
        for (PatternParam patternParam : this.excludeTables) {
            container.addExcludeTable(patternParam.toExcludeTable());
        }
        for (PatternParam patternParam : this.includeColumns) {
            container.addIncludeColumn(patternParam.toIncludeColumn());
        }
        for (PatternParam patternParam : this.excludeColumns) {
            container.addExcludeColumn(patternParam.toExcludeColumn());
        }
        for (PatternParam patternParam : this.includeProcedures) {
            container.addIncludeProcedure(patternParam.toIncludeProcedure());
        }
        for (PatternParam patternParam : this.excludeProcedures) {
            container.addExcludeProcedure(patternParam.toExcludeProcedure());
        }
        for (PatternParam patternParam : this.excludeRelationships) {
            container.addExcludeRelationship(patternParam.toExcludeRelationship());
        }
        return container;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

