/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.di.ClassLoaderManager;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;

public class GradlePluginClassLoaderManager
implements ClassLoaderManager {
    private Project project;
    private List<URL> urls = new ArrayList<URL>();

    public GradlePluginClassLoaderManager(Project project) {
        this.project = project;
    }

    public ClassLoader getClassLoader(String resourceName) {
        return this.buildClassLoader();
    }

    private void addUrlFromDependency(Dependency dependency, Configuration configuration) {
        if (dependency == null) {
            return;
        }
        configuration.files(new Dependency[]{dependency}).forEach(this::addUrlFromFile);
    }

    private void addUrlFromFile(File file) {
        try {
            this.urls.add(file.toURI().toURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ClassLoader buildClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        ConfigurationContainer configurations = this.project.getConfigurations();
        if (configurations == null || configurations.isEmpty()) {
            return classLoader;
        }
        Configuration configuration = configurations.getByName("compile");
        DependencySet dependencies = configuration.getDependencies();
        if (dependencies == null || dependencies.isEmpty()) {
            return classLoader;
        }
        dependencies.forEach(dependency -> this.addUrlFromDependency((Dependency)dependency, configuration));
        return new URLClassLoader(this.urls.toArray(new URL[0]), this.getClass().getClassLoader());
    }
}

