/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.IOException;
import java.net.URL;
import org.apache.cayenne.tools.CgenTask;
import org.apache.cayenne.tools.DbGenerateTask;
import org.apache.cayenne.tools.DbImportTask;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class GradleCayenneExtension {
    public static final String GROUP = "org.apache.cayenne";
    private static final String VERSION_FILE = "/cayenne.version";
    private String version;
    private final DependencyHandler dependencies;
    private final Class<CgenTask> cgen = CgenTask.class;
    private final Class<DbImportTask> cdbimport = DbImportTask.class;
    private final Class<DbGenerateTask> cdbgen = DbGenerateTask.class;
    private String defaultDataMap;

    public GradleCayenneExtension(Project project) {
        this.dependencies = project.getDependencies();
        try {
            this.readVersion(project);
        }
        catch (IOException ex) {
            throw new GradleException("Cayenne version not found", (Throwable)ex);
        }
    }

    private void readVersion(Project project) throws IOException {
        URL versionFileUrl = this.getClass().getResource(VERSION_FILE);
        this.version = versionFileUrl == null ? project.getVersion().toString() : ResourceGroovyMethods.getText((URL)versionFileUrl).trim();
    }

    public Dependency dependency(String name) {
        return this.dependencies.create((Object)("org.apache.cayenne:cayenne-" + name + ":" + this.version));
    }

    public String getDefaultDataMap() {
        return this.defaultDataMap;
    }

    public void setDefaultDataMap(String defaultDataMap) {
        this.defaultDataMap = defaultDataMap;
    }

    public Class<CgenTask> getCgen() {
        return this.cgen;
    }

    public Class<DbImportTask> getCdbimport() {
        return this.cdbimport;
    }

    public Class<DbGenerateTask> getCdbgen() {
        return this.cdbgen;
    }

    public String getVersion() {
        return this.version;
    }
}

