/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.gen.Artifact;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.cayenne.validation.ValidationException;

public class CgenConfiguration
implements Serializable,
XMLSerializable {
    private Collection<Artifact> artifacts;
    private Set<String> entityArtifacts;
    private Collection<String> excludeEntityArtifacts;
    private Set<String> embeddableArtifacts;
    private Collection<String> excludeEmbeddableArtifacts;
    private String superPkg;
    private DataMap dataMap;
    private ArtifactsGenerationMode artifactsGenerationMode;
    private boolean makePairs = true;
    private Path rootPath;
    private Path relPath;
    private boolean overwrite;
    private boolean usePkgPath = true;
    private String template;
    private String superTemplate;
    private String embeddableTemplate;
    private String embeddableSuperTemplate;
    private String queryTemplate;
    private String querySuperTemplate;
    private long timestamp = 0L;
    private String outputPattern = "*.java";
    private String encoding;
    private boolean createPropertyNames;
    private boolean force;
    private boolean createPKProperties;
    private boolean client;
    private String externalToolConfig;

    public CgenConfiguration(boolean client) {
        this.setArtifactsGenerationMode("entity");
        this.artifacts = new ArrayList<Artifact>();
        this.entityArtifacts = new HashSet<String>();
        this.excludeEntityArtifacts = new ArrayList<String>();
        this.embeddableArtifacts = new HashSet<String>();
        this.excludeEmbeddableArtifacts = new ArrayList<String>();
        this.artifactsGenerationMode = ArtifactsGenerationMode.ENTITY;
        this.client = client;
        if (!client) {
            this.template = "templates/v4_1/subclass.vm";
            this.superTemplate = "templates/v4_1/superclass.vm";
            this.queryTemplate = "templates/v4_1/datamap-subclass.vm";
            this.querySuperTemplate = "templates/v4_1/datamap-superclass.vm";
        } else {
            this.template = "templates/v4_1/client-subclass.vm";
            this.superTemplate = "templates/v4_1/client-superclass.vm";
            this.queryTemplate = "templates/v4_1/client-datamap-subclass.vm";
            this.querySuperTemplate = "templates/v4_1/client-datamap-superclass.vm";
        }
        this.embeddableTemplate = "templates/v4_1/embeddable-subclass.vm";
        this.embeddableSuperTemplate = "templates/v4_1/embeddable-superclass.vm";
    }

    public void resetCollections() {
        this.embeddableArtifacts.clear();
        this.entityArtifacts.clear();
    }

    public String getSuperPkg() {
        return this.superPkg;
    }

    public void setSuperPkg(String superPkg) {
        this.superPkg = superPkg;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public void setArtifactsGenerationMode(String mode) {
        this.artifactsGenerationMode = ArtifactsGenerationMode.ENTITY.getLabel().equalsIgnoreCase(mode) ? ArtifactsGenerationMode.ENTITY : ArtifactsGenerationMode.ALL;
    }

    public String getArtifactsGenerationMode() {
        return this.artifactsGenerationMode.getLabel();
    }

    public boolean isMakePairs() {
        return this.makePairs;
    }

    public void setMakePairs(boolean makePairs) {
        this.makePairs = makePairs;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(Path rootPath) {
        this.rootPath = rootPath;
    }

    public void setRelPath(Path relPath) {
        this.relPath = relPath;
    }

    public void setRelPath(String pathStr) {
        Path path = Paths.get(pathStr, new String[0]);
        if (this.rootPath != null) {
            if (!this.rootPath.isAbsolute()) {
                throw new ValidationException("Root path : \"" + this.rootPath.toString() + '\"' + "should be absolute", new Object[0]);
            }
            if (path.isAbsolute() && this.rootPath.getRoot().equals(path.getRoot())) {
                this.relPath = this.rootPath.relativize(path);
                return;
            }
        }
        this.relPath = path;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isUsePkgPath() {
        return this.usePkgPath;
    }

    public void setUsePkgPath(boolean usePkgPath) {
        this.usePkgPath = usePkgPath;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getSuperTemplate() {
        return this.superTemplate;
    }

    public void setSuperTemplate(String superTemplate) {
        this.superTemplate = superTemplate;
    }

    public String getEmbeddableTemplate() {
        return this.embeddableTemplate;
    }

    public void setEmbeddableTemplate(String embeddableTemplate) {
        this.embeddableTemplate = embeddableTemplate;
    }

    public String getEmbeddableSuperTemplate() {
        return this.embeddableSuperTemplate;
    }

    public void setEmbeddableSuperTemplate(String embeddableSuperTemplate) {
        this.embeddableSuperTemplate = embeddableSuperTemplate;
    }

    public String getQueryTemplate() {
        return this.queryTemplate;
    }

    public void setQueryTemplate(String queryTemplate) {
        this.queryTemplate = queryTemplate;
    }

    public String getQuerySuperTemplate() {
        return this.querySuperTemplate;
    }

    public void setQuerySuperTemplate(String querySuperTemplate) {
        this.querySuperTemplate = querySuperTemplate;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isCreatePropertyNames() {
        return this.createPropertyNames;
    }

    public void setCreatePropertyNames(boolean createPropertyNames) {
        this.createPropertyNames = createPropertyNames;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isCreatePKProperties() {
        return this.createPKProperties;
    }

    public void setCreatePKProperties(boolean createPKProperties) {
        this.createPKProperties = createPKProperties;
    }

    public Path getRelPath() {
        return this.relPath;
    }

    public String buildRelPath() {
        if (this.relPath == null || this.relPath.toString().isEmpty()) {
            return ".";
        }
        return this.relPath.toString();
    }

    Collection<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public Set<String> getEntities() {
        return this.entityArtifacts;
    }

    public Set<String> getEmbeddables() {
        return this.embeddableArtifacts;
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public String getExternalToolConfig() {
        return this.externalToolConfig;
    }

    public void setExternalToolConfig(String config) {
        this.externalToolConfig = config;
    }

    void addArtifact(Artifact artifact) {
        this.artifacts.add(artifact);
    }

    public Path buildPath() {
        return this.rootPath != null ? (this.relPath != null ? this.rootPath.resolve(this.relPath).toAbsolutePath().normalize() : this.rootPath) : this.relPath;
    }

    public void loadEntity(ObjEntity entity) {
        if (!entity.isGeneric()) {
            this.entityArtifacts.add(entity.getName());
        }
    }

    public void loadEmbeddable(String name) {
        this.embeddableArtifacts.add(name);
    }

    public void loadEntities(String entities) {
        this.excludeEntityArtifacts.addAll(Arrays.asList(entities.split(",")));
    }

    private String getExcludeEntites() {
        Collection excludeEntities = this.dataMap.getObjEntities().stream().map(Entity::getName).filter(name -> !this.entityArtifacts.contains(name)).collect(Collectors.toList());
        return String.join((CharSequence)",", excludeEntities);
    }

    public void loadEmbeddables(String embeddables) {
        this.excludeEmbeddableArtifacts.addAll(Arrays.asList(embeddables.split(",")));
    }

    private String getExcludeEmbeddables() {
        Collection excludeEmbeddable = this.dataMap.getEmbeddables().stream().map(Embeddable::getClassName).filter(className -> !this.embeddableArtifacts.contains(className)).collect(Collectors.toList());
        return String.join((CharSequence)",", excludeEmbeddable);
    }

    public void resolveExcludeEntities() {
        this.entityArtifacts = this.dataMap.getObjEntities().stream().map(Entity::getName).filter(name -> !this.excludeEntityArtifacts.contains(name)).collect(Collectors.toSet());
    }

    public void resolveExcludeEmbeddables() {
        this.embeddableArtifacts = this.dataMap.getEmbeddables().stream().map(Embeddable::getClassName).filter(className -> !this.excludeEmbeddableArtifacts.contains(className)).collect(Collectors.toSet());
    }

    public Collection<String> getExcludeEntityArtifacts() {
        return this.excludeEntityArtifacts;
    }

    public Collection<String> getExcludeEmbeddableArtifacts() {
        return this.excludeEmbeddableArtifacts;
    }

    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("cgen").attribute("xmlns", "http://cayenne.apache.org/schema/10/cgen").simpleTag("excludeEntities", this.getExcludeEntites()).simpleTag("excludeEmbeddables", this.getExcludeEmbeddables()).simpleTag("destDir", this.buildRelPath()).simpleTag("mode", this.artifactsGenerationMode.getLabel()).simpleTag("template", this.template).simpleTag("superTemplate", this.superTemplate).simpleTag("template", this.template).simpleTag("superTemplate", this.superTemplate).simpleTag("embeddableTemplate", this.embeddableTemplate).simpleTag("embeddableSuperTemplate", this.embeddableSuperTemplate).simpleTag("queryTemplate", this.queryTemplate).simpleTag("querySuperTemplate", this.querySuperTemplate).simpleTag("outputPattern", this.outputPattern).simpleTag("makePairs", Boolean.toString(this.makePairs)).simpleTag("usePkgPath", Boolean.toString(this.usePkgPath)).simpleTag("overwrite", Boolean.toString(this.overwrite)).simpleTag("createPropertyNames", Boolean.toString(this.createPropertyNames)).simpleTag("superPkg", this.superPkg).simpleTag("createPKProperties", Boolean.toString(this.createPKProperties)).simpleTag("client", Boolean.toString(this.client)).simpleTag("externalToolConfig", this.externalToolConfig).end();
    }

    public boolean isDefault() {
        return !(!this.isMakePairs() || !this.usePkgPath || this.overwrite || this.createPKProperties || this.createPropertyNames || !"*.java".equals(this.outputPattern) || !this.template.equals("templates/v4_1/subclass.vm") && !this.template.equals("templates/v4_1/client-subclass.vm") || !this.superTemplate.equals("templates/v4_1/superclass.vm") && !this.superTemplate.equals("templates/v4_1/client-superclass.vm") || this.superPkg != null && !this.superPkg.isEmpty() || this.externalToolConfig != null && !this.externalToolConfig.isEmpty());
    }
}

