/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataMapListener;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClassGenerationActionFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EmbeddableListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;
import org.apache.cayenne.modeler.editor.DbImportController;
import org.apache.cayenne.modeler.editor.cgen.ClassesTabController;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorPane;
import org.apache.cayenne.modeler.editor.cgen.GeneratorController;
import org.apache.cayenne.modeler.editor.cgen.GeneratorTabController;
import org.apache.cayenne.modeler.editor.cgen.SelectionModel;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.tools.ToolsInjectorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGeneratorController
extends CayenneController
implements ObjEntityListener,
EmbeddableListener,
DataMapListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorDebugDialog.class);
    protected final ProjectController projectController;
    protected final List<Object> classes;
    protected final SelectionModel selectionModel;
    protected final CodeGeneratorPane view;
    protected final ClassesTabController classesSelector = new ClassesTabController(this);
    protected final GeneratorTabController generatorSelector = new GeneratorTabController(this);
    protected final ConcurrentMap<DataMap, GeneratorController> prevGeneratorController;
    private Object currentClass;
    private CgenConfiguration cgenConfiguration;
    private boolean initFromModel;

    public CodeGeneratorController(ProjectController projectController) {
        super(projectController);
        this.view = new CodeGeneratorPane(this.generatorSelector.getView(), this.classesSelector.getView());
        this.prevGeneratorController = new ConcurrentHashMap<DataMap, GeneratorController>();
        this.projectController = projectController;
        this.classes = new ArrayList<Object>();
        this.selectionModel = new SelectionModel();
        this.initBindings();
        this.initListeners();
    }

    public void initFromModel() {
        this.initFromModel = true;
        DataMap dataMap = this.projectController.getCurrentDataMap();
        this.prepareClasses(dataMap);
        this.createConfiguration(dataMap);
        GeneratorController modeController = (GeneratorController)this.prevGeneratorController.get(dataMap);
        if (modeController == null) {
            modeController = this.cgenConfiguration.isDefault() ? (this.cgenConfiguration.isClient() ? this.generatorSelector.getClientGeneratorController() : this.generatorSelector.getStandartController()) : this.generatorSelector.getCustomModeController();
        }
        this.prevGeneratorController.put(dataMap, modeController);
        this.generatorSelector.setSelectedController(modeController);
        this.classesSelector.startup();
        this.initFromModel = false;
        this.classesSelector.validate(this.classes);
    }

    private void initListeners() {
        this.projectController.addObjEntityListener(this);
        this.projectController.addEmbeddableListener(this);
        this.projectController.addDataMapListener(this);
    }

    @Override
    public CodeGeneratorPane getView() {
        return this.view;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getGenerateButton(), "generateAction()");
        builder.bindToAction(this.generatorSelector, "generatorSelectedAction()", "generator");
        this.generatorSelectedAction();
    }

    public void generatorSelectedAction() {
        GeneratorController controller = this.generatorSelector.getGeneratorController();
        this.classesSelector.validate(this.classes);
        Predicate<Object> defaultPredicate = object -> {
            if (object instanceof ObjEntity) {
                return this.classesSelector.getProblem(((ObjEntity)object).getName()) == null;
            }
            if (object instanceof Embeddable) {
                return this.classesSelector.getProblem(((Embeddable)object).getClassName()) == null;
            }
            return false;
        };
        Predicate<Object> predicate = controller != null ? defaultPredicate : o -> false;
        this.updateSelection(predicate);
        this.classesSelector.classSelectedAction();
    }

    public void generateAction() {
        ClassGenerationAction generator = new ToolsInjectorBuilder().addModule(binder -> binder.bind(DataChannelMetaData.class).toInstance(this.projectController.getApplication().getMetaData())).create().getInstance(ClassGenerationActionFactory.class).createAction(this.cgenConfiguration);
        try {
            generator.prepareArtifacts();
            generator.execute();
            JOptionPane.showMessageDialog(this.getView(), "Class generation finished");
        }
        catch (Exception e) {
            LOGGER.error("Error generating classes", e);
            JOptionPane.showMessageDialog(this.getView(), "Error generating classes - " + e.getMessage());
        }
    }

    public ConcurrentMap<DataMap, GeneratorController> getPrevGeneratorController() {
        return this.prevGeneratorController;
    }

    public void enableGenerateButton(boolean enable) {
        this.view.getGenerateButton().setEnabled(enable);
    }

    private void prepareClasses(DataMap dataMap) {
        this.classes.clear();
        this.classes.add(dataMap);
        this.classes.addAll(dataMap.getObjEntities());
        this.classes.addAll(dataMap.getEmbeddables());
        this.selectionModel.initCollectionsForSelection(dataMap);
    }

    public void createConfiguration(DataMap map) {
        Preferences preferences;
        this.cgenConfiguration = this.projectController.getApplication().getMetaData().get(map, CgenConfiguration.class);
        if (this.cgenConfiguration != null) {
            this.addToSelectedEntities(this.cgenConfiguration.getEntities());
            this.addToSelectedEmbeddables(this.cgenConfiguration.getEmbeddables());
            this.cgenConfiguration.setForce(true);
            return;
        }
        this.cgenConfiguration = new CgenConfiguration(false);
        this.cgenConfiguration.setForce(true);
        this.cgenConfiguration.setDataMap(map);
        Path basePath = Paths.get(ModelerUtil.initOutputFolder(), new String[0]);
        if (!Files.exists(basePath, new LinkOption[0])) {
            try {
                Files.createDirectories(basePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.getView(), "Can't create directory. Select a different one.");
                return;
            }
        }
        if (!Files.isDirectory(basePath, new LinkOption[0])) {
            JOptionPane.showMessageDialog(this.getView(), basePath + " is not a valid directory.");
            return;
        }
        if (map.getLocation() != null) {
            this.cgenConfiguration.setRootPath(basePath);
        }
        if ((preferences = this.application.getPreferencesNode(GeneralPreferences.class, "")) != null) {
            this.cgenConfiguration.setEncoding(preferences.get("encoding", null));
        }
        this.addToSelectedEntities(map.getObjEntities().stream().map(Entity::getName).collect(Collectors.toList()));
        this.addToSelectedEmbeddables(map.getEmbeddables().stream().map(Embeddable::getClassName).collect(Collectors.toList()));
    }

    public List<Object> getClasses() {
        return this.classes;
    }

    public boolean updateSelection(Predicate<Object> predicate) {
        boolean modified = this.selectionModel.updateSelection(predicate, this.classes);
        for (Object classObj : this.classes) {
            if (!(classObj instanceof DataMap)) continue;
            boolean selected = predicate.test(classObj);
            this.updateArtifactGenerationMode(selected);
        }
        return modified;
    }

    private void updateArtifactGenerationMode(boolean selected) {
        if (selected) {
            this.cgenConfiguration.setArtifactsGenerationMode("all");
        } else {
            this.cgenConfiguration.setArtifactsGenerationMode("entity");
        }
        this.checkCgenConfigDirty();
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected(this.currentClass);
    }

    public void setSelected(boolean selectedFlag) {
        if (this.currentClass instanceof DataMap) {
            this.updateArtifactGenerationMode(selectedFlag);
        }
        this.selectionModel.setSelected(this.currentClass, selectedFlag);
    }

    public void setCurrentClass(Object currentClass) {
        this.currentClass = currentClass;
    }

    public void updateSelectedEntities() {
        this.updateEntities();
        this.updateEmbeddables();
    }

    public void checkCgenConfigDirty() {
        if (this.initFromModel || this.cgenConfiguration == null) {
            return;
        }
        DataMap map = this.projectController.getCurrentDataMap();
        CgenConfiguration existingConfig = this.projectController.getApplication().getMetaData().get(map, CgenConfiguration.class);
        if (existingConfig == null) {
            this.getApplication().getMetaData().add(map, this.cgenConfiguration);
        }
        this.projectController.setDirty(true);
    }

    private void updateEntities() {
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.getEntities().clear();
            for (ObjEntity entity : this.selectionModel.getSelectedEntities(this.classes)) {
                this.cgenConfiguration.loadEntity(entity);
            }
        }
        this.checkCgenConfigDirty();
    }

    private void updateEmbeddables() {
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.getEmbeddables().clear();
            for (Embeddable embeddable : this.selectionModel.getSelectedEmbeddables(this.classes)) {
                this.cgenConfiguration.loadEmbeddable(embeddable.getClassName());
            }
        }
        this.checkCgenConfigDirty();
    }

    private void addToSelectedEntities(Collection<String> entities) {
        this.selectionModel.addSelectedEntities(entities);
        this.updateEntities();
    }

    void addEntity(DataMap dataMap, ObjEntity objEntity) {
        this.prepareClasses(dataMap);
        this.selectionModel.addSelectedEntity(objEntity.getName());
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.loadEntity(objEntity);
        }
        this.checkCgenConfigDirty();
    }

    private void addToSelectedEmbeddables(Collection<String> embeddables) {
        this.selectionModel.addSelectedEmbeddables(embeddables);
        this.updateEmbeddables();
    }

    public int getSelectedEntitiesSize() {
        return this.selectionModel.getSelectedEntitiesCount();
    }

    public int getSelectedEmbeddablesSize() {
        return this.selectionModel.getSelecetedEmbeddablesCount();
    }

    public boolean isDataMapSelected() {
        return this.selectionModel.getSelectedDataMapsCount() > 0;
    }

    public ProjectController getProjectController() {
        return this.projectController;
    }

    public boolean isInitFromModel() {
        return this.initFromModel;
    }

    public void setInitFromModel(boolean initFromModel) {
        this.initFromModel = initFromModel;
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
        this.addEntity(e.getEntity().getDataMap(), (ObjEntity)e.getEntity());
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
        this.selectionModel.removeFromSelectedEntities((ObjEntity)e.getEntity());
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.getEntities().remove(e.getEntity().getName());
        }
        this.checkCgenConfigDirty();
    }

    @Override
    public void embeddableChanged(EmbeddableEvent e, DataMap map) {
    }

    @Override
    public void embeddableAdded(EmbeddableEvent e, DataMap map) {
        this.prepareClasses(map);
        String embeddableClassName = e.getEmbeddable().getClassName();
        this.selectionModel.addSelectedEmbeddable(embeddableClassName);
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.loadEmbeddable(embeddableClassName);
        }
        this.checkCgenConfigDirty();
    }

    @Override
    public void embeddableRemoved(EmbeddableEvent e, DataMap map) {
        this.selectionModel.removeFromSelectedEmbeddables(e.getEmbeddable());
        if (this.cgenConfiguration != null) {
            this.cgenConfiguration.getEmbeddables().remove(e.getEmbeddable().getClassName());
        }
        this.checkCgenConfigDirty();
    }

    @Override
    public void dataMapChanged(DataMapEvent e) {
        if (e.getSource() instanceof DbImportController) {
            if (this.cgenConfiguration != null) {
                for (ObjEntity objEntity : e.getDataMap().getObjEntities()) {
                    if (this.cgenConfiguration.getExcludeEntityArtifacts().contains(objEntity.getName())) continue;
                    this.addEntity(this.cgenConfiguration.getDataMap(), objEntity);
                }
            }
            this.checkCgenConfigDirty();
        }
    }

    @Override
    public void dataMapAdded(DataMapEvent e) {
    }

    @Override
    public void dataMapRemoved(DataMapEvent e) {
    }

    public CgenConfiguration getCgenConfiguration() {
        return this.cgenConfiguration;
    }
}

