/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.select.TableTreeNode;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.util.Util;

class TableTree {
    private final Map<String, TableTreeNode> tableNodes;
    private final TableTree parentTree;
    private TableTreeNode rootNode;
    private int tableAliasSequence = 0;

    TableTree(DbEntity root, TableTree parentTree) {
        this.parentTree = parentTree;
        this.tableNodes = new LinkedHashMap<String, TableTreeNode>();
        this.rootNode = new TableTreeNode(root, this.nextTableAlias());
    }

    void addJoinTable(String path, DbRelationship relationship, JoinType joinType) {
        if (this.tableNodes.get(path) != null) {
            return;
        }
        TableTreeNode node = new TableTreeNode(path, relationship, this.nextTableAlias(), joinType);
        this.tableNodes.put(path, node);
    }

    String aliasForPath(String attributePath) {
        if (Util.isEmptyString(attributePath)) {
            return this.rootNode.getTableAlias();
        }
        TableTreeNode node = this.tableNodes.get(attributePath);
        if (node == null) {
            throw new CayenneRuntimeException("No table for attribute '%s' found", attributePath);
        }
        return node.getTableAlias();
    }

    String aliasForAttributePath(String attributePath) {
        int lastSeparator = attributePath.lastIndexOf(46);
        if (lastSeparator == -1) {
            return this.rootNode.getTableAlias();
        }
        String table = attributePath.substring(0, lastSeparator);
        return this.aliasForPath(table);
    }

    String nextTableAlias() {
        if (this.parentTree != null) {
            return this.parentTree.nextTableAlias();
        }
        return 't' + String.valueOf(this.tableAliasSequence++);
    }

    public int getNodeCount() {
        return this.tableNodes.size() + 1;
    }

    public void visit(TableNodeVisitor visitor) {
        visitor.visit(this.rootNode);
        int initialSize = 0;
        int currentSize = this.tableNodes.size();
        while (initialSize != currentSize) {
            this.tableNodes.values().stream().skip(initialSize).collect(Collectors.toList()).forEach(visitor::visit);
            initialSize = currentSize;
            currentSize = this.tableNodes.size();
        }
    }

    @FunctionalInterface
    static interface TableNodeVisitor {
        public void visit(TableTreeNode var1);
    }
}

