/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.dbentity;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.event.DbEntityListener;
import org.apache.cayenne.map.event.DbRelationshipListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.CutAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeRelationshipAction;
import org.apache.cayenne.modeler.dialog.DbRelationshipDialog;
import org.apache.cayenne.modeler.editor.dbentity.DbEntityAttributeRelationshipTab;
import org.apache.cayenne.modeler.editor.dbentity.DbRelationshipTableModel;
import org.apache.cayenne.modeler.event.DbEntityDisplayListener;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.BoardTableCellRenderer;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CellRenderers;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class DbEntityRelationshipPanel
extends JPanel
implements DbEntityDisplayListener,
DbEntityListener,
DbRelationshipListener,
TableModelListener {
    protected ProjectController mediator;
    protected CayenneTable table;
    private TableColumnPreferences tablePreferences;
    private ActionListener resolver;
    private boolean enabledResolve;
    private DbEntityAttributeRelationshipTab parentPanel;
    protected JMenuItem resolveMenu;
    protected JComboBox<DbEntity> targetCombo;

    public DbEntityRelationshipPanel(ProjectController mediator, DbEntityAttributeRelationshipTab parentPanel) {
        this.mediator = mediator;
        this.parentPanel = parentPanel;
        this.init();
        this.initController();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        ActionManager actionManager = Application.getInstance().getActionManager();
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(DbEntity.class, CellRenderers.entityTableRendererWithIcons(this.mediator));
        this.table.setDefaultRenderer(String.class, new BoardTableCellRenderer());
        this.tablePreferences = new TableColumnPreferences(DbRelationshipTableModel.class, "relationshipTable");
        ImageIcon ico = ModelerUtil.buildIcon("icon-edit.png");
        this.resolveMenu = new CayenneAction.CayenneMenuItem("Database Mapping", ico);
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.resolveMenu);
        popup.add(actionManager.getAction(RemoveAttributeRelationshipAction.class).buildMenu());
        popup.addSeparator();
        popup.add(actionManager.getAction(CutAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(CopyAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(PasteAction.class).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addDbEntityDisplayListener(this);
        this.mediator.addDbEntityListener(this);
        this.mediator.addDbRelationshipListener(this);
        this.resolver = e -> {
            int row = this.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
            DbRelationship rel = model.getRelationship(row);
            new DbRelationshipDialog(this.mediator).modifyRaltionship(rel).startUp();
        };
        this.resolveMenu.addActionListener(this.resolver);
        this.table.getSelectionModel().addListSelectionListener(new DbRelationshipListSelectionListener());
        this.mediator.getApplication().getActionManager().setupCutCopyPaste(this.table, CutAttributeRelationshipAction.class, CopyAttributeRelationshipAction.class);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.table.getSelectedRow() >= 0) {
            DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
            DbRelationship rel = model.getRelationship(this.table.getSelectedRow());
            this.enabledResolve = rel.getTargetEntity() != null;
            this.resolveMenu.setEnabled(this.enabledResolve);
        }
    }

    public void selectRelationships(DbRelationship[] rels) {
        DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
        List listRels = model.getObjectList();
        int[] newSel = new int[rels.length];
        Application.getInstance().getActionManager().getAction(RemoveAttributeRelationshipAction.class).setCurrentSelectedPanel(this.parentPanel.getRelationshipPanel());
        Application.getInstance().getActionManager().getAction(CutAttributeRelationshipAction.class).setCurrentSelectedPanel(this.parentPanel.getRelationshipPanel());
        Application.getInstance().getActionManager().getAction(CopyAttributeRelationshipAction.class).setCurrentSelectedPanel(this.parentPanel.getRelationshipPanel());
        this.parentPanel.updateActions(rels);
        for (int i = 0; i < rels.length; ++i) {
            newSel[i] = listRels.indexOf(rels[i]);
        }
        this.table.select(newSel);
        this.parentPanel.getResolve().removeActionListener(this.getResolver());
        this.parentPanel.getResolve().addActionListener(this.getResolver());
    }

    @Override
    public void currentDbEntityChanged(EntityDisplayEvent e) {
        DbEntity entity = (DbEntity)e.getEntity();
        if (entity != null && e.isEntityChanged()) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    protected void rebuildTable(DbEntity entity) {
        DbRelationshipTableModel model = new DbRelationshipTableModel(entity, this.mediator, this);
        model.addTableModelListener(this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        TableColumn col = this.table.getColumnModel().getColumn(1);
        this.targetCombo = Application.getWidgetFactory().createComboBox();
        AutoCompletion.enable(this.targetCombo);
        this.table.getColumnModel().getColumn(2).setCellRenderer(new CheckBoxCellRenderer());
        this.targetCombo.setRenderer(CellRenderers.entityListRendererWithIcons(entity.getDataMap()));
        this.targetCombo.setModel(this.createComboModel());
        col.setCellEditor(Application.getWidgetFactory().createCellEditor(this.targetCombo));
        this.tablePreferences.bind(this.table, null, null, null, 0, true);
    }

    @Override
    public void dbEntityChanged(EntityEvent e) {
    }

    @Override
    public void dbEntityAdded(EntityEvent e) {
        this.reloadEntityList(e);
    }

    @Override
    public void dbEntityRemoved(EntityEvent e) {
        this.reloadEntityList(e);
    }

    @Override
    public void dbRelationshipChanged(RelationshipEvent e) {
        if (e.getSource() != this) {
            if (!(this.table.getModel() instanceof DbRelationshipTableModel)) {
                this.rebuildTable((DbEntity)e.getEntity());
            }
            this.table.select(e.getRelationship());
            DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
            model.fireTableDataChanged();
        }
    }

    @Override
    public void dbRelationshipAdded(RelationshipEvent e) {
        this.rebuildTable((DbEntity)e.getEntity());
        this.table.select(e.getRelationship());
    }

    @Override
    public void dbRelationshipRemoved(RelationshipEvent e) {
        DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
        DbRelationship relationship = (DbRelationship)e.getRelationship();
        int ind = model.getObjectList().indexOf(relationship);
        model.removeRelationship(relationship);
        this.table.select(ind);
    }

    private void reloadEntityList(EntityEvent e) {
        if (e.getSource() == this || this.mediator.getCurrentDbEntity() == e.getEntity() || this.mediator.getCurrentDbEntity() == null) {
            return;
        }
        this.targetCombo.setModel(this.createComboModel());
        DbRelationshipTableModel model = (DbRelationshipTableModel)this.table.getModel();
        model.fireTableDataChanged();
    }

    private ComboBoxModel<DbEntity> createComboModel() {
        EntityResolver resolver = this.mediator.getEntityResolver();
        DbEntity[] objects = resolver.getDbEntities().toArray(new DbEntity[0]);
        return new DefaultComboBoxModel<DbEntity>(objects);
    }

    public ActionListener getResolver() {
        return this.resolver;
    }

    private class CheckBoxCellRenderer
    implements TableCellRenderer {
        private final JCheckBox renderer = new JCheckBox();

        public CheckBoxCellRenderer() {
            this.renderer.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color color = isSelected ? table.getSelectionBackground() : table.getBackground();
            this.renderer.setBackground(color);
            this.renderer.setEnabled(table.isCellEditable(row, column));
            this.renderer.setSelected(value != null && (Boolean)value != false);
            return this.renderer;
        }
    }

    private class DbRelationshipListSelectionListener
    implements ListSelectionListener {
        private DbRelationshipListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object[] rels = new DbRelationship[]{};
            if (!e.getValueIsAdjusting() && !((ListSelectionModel)e.getSource()).isSelectionEmpty()) {
                ((DbEntityRelationshipPanel)DbEntityRelationshipPanel.this).parentPanel.getAttributePanel().table.getSelectionModel().clearSelection();
                if (((DbEntityRelationshipPanel)DbEntityRelationshipPanel.this).parentPanel.getAttributePanel().table.getCellEditor() != null) {
                    ((DbEntityRelationshipPanel)DbEntityRelationshipPanel.this).parentPanel.getAttributePanel().table.getCellEditor().stopCellEditing();
                }
                Application.getInstance().getActionManager().getAction(RemoveAttributeRelationshipAction.class).setCurrentSelectedPanel(DbEntityRelationshipPanel.this.parentPanel.getRelationshipPanel());
                Application.getInstance().getActionManager().getAction(CutAttributeRelationshipAction.class).setCurrentSelectedPanel(DbEntityRelationshipPanel.this.parentPanel.getRelationshipPanel());
                Application.getInstance().getActionManager().getAction(CopyAttributeRelationshipAction.class).setCurrentSelectedPanel(DbEntityRelationshipPanel.this.parentPanel.getRelationshipPanel());
                DbEntityRelationshipPanel.this.parentPanel.getResolve().removeActionListener(DbEntityRelationshipPanel.this.getResolver());
                DbEntityRelationshipPanel.this.parentPanel.getResolve().addActionListener(DbEntityRelationshipPanel.this.getResolver());
                if (DbEntityRelationshipPanel.this.table.getSelectedRow() >= 0) {
                    DbRelationshipTableModel model = (DbRelationshipTableModel)DbEntityRelationshipPanel.this.table.getModel();
                    int[] sel = DbEntityRelationshipPanel.this.table.getSelectedRows();
                    rels = new DbRelationship[sel.length];
                    for (int i = 0; i < sel.length; ++i) {
                        rels[i] = model.getRelationship(sel[i]);
                    }
                    if (sel.length == 1) {
                        UIUtil.scrollToSelectedRow(DbEntityRelationshipPanel.this.table);
                    }
                    DbEntityRelationshipPanel.this.enabledResolve = true;
                } else {
                    DbEntityRelationshipPanel.this.enabledResolve = false;
                }
                DbEntityRelationshipPanel.this.resolveMenu.setEnabled(DbEntityRelationshipPanel.this.enabledResolve);
            }
            DbEntityRelationshipPanel.this.mediator.setCurrentDbRelationships((DbRelationship[])rels);
            DbEntityRelationshipPanel.this.parentPanel.updateActions(rels);
        }
    }
}

