/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.graph;

import java.io.Serializable;
import java.util.Objects;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.modeler.graph.GraphBuilder;

abstract class EntityCellMetadata
implements Serializable {
    final GraphBuilder builder;
    final String entityName;
    final String label;

    EntityCellMetadata(GraphBuilder builder, Entity entity) {
        this.builder = Objects.requireNonNull(builder);
        this.entityName = Objects.requireNonNull(entity).getName();
        this.label = this.createLabel(entity);
    }

    public abstract Entity fetchEntity();

    public String toString() {
        return this.label;
    }

    String createLabel(Entity entity) {
        StringBuilder label = new StringBuilder("<html><center><u><b>").append(entity.getName()).append("</b></u></center>");
        for (Attribute attribute : entity.getAttributes()) {
            if (!this.isPrimary(attribute)) continue;
            label.append("<br><i>").append(attribute.getName()).append("</i>");
        }
        for (Attribute attribute : entity.getAttributes()) {
            if (this.isPrimary(attribute)) continue;
            label.append("<br>").append(attribute.getName());
        }
        return label.append("</html>").toString();
    }

    protected abstract boolean isPrimary(Attribute var1);
}

