/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.rop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cayenne.configuration.CayenneRuntime;
import org.apache.cayenne.configuration.rop.server.ROPServerModule;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.configuration.web.WebConfiguration;
import org.apache.cayenne.configuration.web.WebUtil;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.rop.ROPRequestContext;
import org.apache.cayenne.rop.ROPSerializationService;

public class ROPServlet
extends HttpServlet {
    protected ServletContext servletContext;
    protected RemoteService remoteService;
    protected ROPSerializationService serializationService;

    public void init(ServletConfig configuration) throws ServletException {
        this.checkAlreadyConfigured(configuration.getServletContext());
        this.servletContext = configuration.getServletContext();
        WebConfiguration configAdapter = new WebConfiguration(configuration);
        String configurationLocation = configAdapter.getConfigurationLocation();
        Map eventBridgeParameters = configAdapter.getOtherParameters();
        Collection modules = configAdapter.createModules(new Module[]{new ROPServerModule(eventBridgeParameters)});
        ServerRuntime runtime = ServerRuntime.builder().addConfig(configurationLocation).addModules(modules).build();
        this.remoteService = (RemoteService)runtime.getInjector().getInstance(RemoteService.class);
        this.serializationService = (ROPSerializationService)runtime.getInjector().getInstance(ROPSerializationService.class);
        WebUtil.setCayenneRuntime((ServletContext)this.servletContext, (CayenneRuntime)runtime);
        super.init(configuration);
    }

    protected void checkAlreadyConfigured(ServletContext context) throws ServletException {
        if (WebUtil.getCayenneRuntime((ServletContext)context) != null) {
            throw new ServletException("CayenneRuntime is already configured in the servlet environment");
        }
    }

    public void destroy() {
        super.destroy();
        CayenneRuntime runtime = WebUtil.getCayenneRuntime((ServletContext)this.servletContext);
        if (runtime != null) {
            runtime.shutdown();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String serviceId = req.getPathInfo();
            String objectId = req.getParameter("id");
            if (objectId == null) {
                objectId = req.getParameter("ejbid");
            }
            ROPRequestContext.start(serviceId, objectId, (ServletRequest)req, (ServletResponse)resp);
            String operation = req.getParameter("operation");
            if (operation != null) {
                switch (operation) {
                    case "establish_session": {
                        RemoteSession session = this.remoteService.establishSession();
                        this.serializationService.serialize(session, (OutputStream)resp.getOutputStream());
                        break;
                    }
                    case "establish_shared_session": {
                        String sessionName = req.getParameter("session_name");
                        RemoteSession sharedSession = this.remoteService.establishSharedSession(sessionName);
                        this.serializationService.serialize(sharedSession, (OutputStream)resp.getOutputStream());
                        break;
                    }
                    default: {
                        throw new ServletException("Unknown operation: " + operation);
                    }
                }
            } else {
                Object response = this.remoteService.processMessage(this.serializationService.deserialize((InputStream)req.getInputStream(), ClientMessage.class));
                this.serializationService.serialize(response, (OutputStream)resp.getOutputStream());
            }
        }
        catch (RuntimeException | ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
        finally {
            ROPRequestContext.end();
        }
    }
}

