/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.util.Util;

public class PrefetchSelectQuery<T>
extends SelectQuery<T> {
    protected String prefetchPath;
    protected ObjRelationship lastPrefetchHint;
    protected Collection<String> resultPaths;

    public PrefetchSelectQuery(String prefetchPath, ObjRelationship lastPrefetchHint) {
        this.setRoot(lastPrefetchHint.getTargetEntity());
        this.prefetchPath = prefetchPath;
        this.lastPrefetchHint = lastPrefetchHint;
    }

    @Override
    void routePrefetches(QueryRouter router, EntityResolver resolver) {
    }

    public String getPrefetchPath() {
        return this.prefetchPath;
    }

    public void setPrefetchPath(String prefetchPath) {
        this.prefetchPath = prefetchPath;
    }

    public ObjRelationship getLastPrefetchHint() {
        return this.lastPrefetchHint;
    }

    public void setLastPrefetchHint(ObjRelationship relationship) {
        this.lastPrefetchHint = relationship;
    }

    public void addResultPath(String path) {
        if (Util.isEmptyString(path)) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        this.nonNullResultPaths().add(path);
    }

    public void removeResultPath(String path) {
        if (this.resultPaths != null) {
            this.resultPaths.remove(path);
        }
    }

    public Collection<String> getResultPaths() {
        return this.resultPaths != null ? Collections.unmodifiableCollection(this.resultPaths) : Collections.emptySet();
    }

    Collection<String> nonNullResultPaths() {
        if (this.resultPaths == null) {
            this.resultPaths = new HashSet<String>();
        }
        return this.resultPaths;
    }
}

