/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.objentity;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JOptionPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dbsync.naming.ObjectNameGenerator;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.map.event.RelationshipEvent;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ResolveDbRelationshipDialog;
import org.apache.cayenne.modeler.dialog.objentity.DbRelationshipTarget;
import org.apache.cayenne.modeler.dialog.objentity.ObjRelationshipInfoView;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.Comparators;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.EntityTreeRelationshipFilter;
import org.apache.cayenne.modeler.util.MultiColumnBrowser;
import org.apache.cayenne.modeler.util.NameGeneratorPreferences;
import org.apache.cayenne.util.DeleteRuleUpdater;
import org.apache.cayenne.util.Util;

public class ObjRelationshipInfo
extends CayenneController
implements TreeSelectionListener {
    static final String COLLECTION_TYPE_MAP = "java.util.Map";
    static final String COLLECTION_TYPE_SET = "java.util.Set";
    static final String COLLECTION_TYPE_COLLECTION = "java.util.Collection";
    static final String DEFAULT_MAP_KEY = "ID (default)";
    protected ObjRelationship relationship;
    protected List<DbRelationship> dbRelationships;
    protected List<DbRelationship> savedDbRelationships;
    protected ObjEntity objectTarget;
    protected List<ObjEntity> objectTargets;
    protected List<String> targetCollections;
    protected List<String> mapKeys;
    protected String targetCollection;
    protected String mapKey;
    protected ObjRelationshipInfoView view;
    protected String currentPath;
    protected ProjectController mediator;

    public void startupAction() {
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
    }

    public ObjRelationshipInfo(ProjectController mediator, ObjRelationship relationship) {
        super(mediator);
        this.view = new ObjRelationshipInfoView(mediator);
        this.mediator = mediator;
        this.getPathBrowser().addTreeSelectionListener(this);
        this.view.sourceEntityLabel.setText(relationship.getSourceEntity().getName());
        this.relationship = relationship;
        this.view.getRelationshipName().setText(relationship.getName());
        this.mapKey = relationship.getMapKey();
        this.targetCollection = relationship.getCollectionType();
        if (this.targetCollection == null) {
            this.targetCollection = "java.util.List";
        }
        this.objectTarget = relationship.getTargetEntity();
        if (this.objectTarget != null) {
            this.updateTargetCombo(this.objectTarget.getDbEntity());
            this.view.targetCombo.setSelectedItem(this.objectTarget.getName());
        }
        this.validateCanMap();
        this.targetCollections = new ArrayList<String>(4);
        this.targetCollections.add(COLLECTION_TYPE_COLLECTION);
        this.targetCollections.add("java.util.List");
        this.targetCollections.add(COLLECTION_TYPE_MAP);
        this.targetCollections.add(COLLECTION_TYPE_SET);
        for (String s : this.targetCollections) {
            this.view.collectionTypeCombo.addItem(s);
        }
        this.mapKeys = new ArrayList<String>();
        this.initMapKeys();
        this.dbRelationships = new ArrayList<DbRelationship>(relationship.getDbRelationships());
        this.selectPath();
        this.updateCollectionChoosers();
        this.connectEnds();
        this.initFromModel();
        this.initController();
    }

    private void initController() {
        this.view.getCancelButton().addActionListener(e -> this.view.dispose());
        this.view.getSaveButton().addActionListener(e -> this.saveMapping());
        this.view.getNewRelButton().addActionListener(e -> this.createRelationship());
        this.view.getSelectPathButton().addActionListener(e -> this.selectPath());
        this.view.getCollectionTypeCombo().addActionListener(e -> this.setCollectionType());
        this.view.getMapKeysCombo().addActionListener(e -> this.setMapKey());
        this.view.getTargetCombo().addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Object targetName = e.getItem();
                for (ObjEntity target : this.objectTargets) {
                    if (!Objects.equals(target.getName(), targetName)) continue;
                    this.setObjectTarget(target);
                    return;
                }
            }
        });
    }

    void initFromModel() {
        if (this.view.pathBrowser.getModel() == null) {
            EntityTreeModel treeModel = new EntityTreeModel(this.getStartEntity());
            treeModel.setFilter(new EntityTreeRelationshipFilter());
            this.view.pathBrowser.setModel(treeModel);
            this.setSelectionPath(this.getSavedDbRelationships());
        }
    }

    void setSelectionPath(List<DbRelationship> rels) {
        Object[] path = new Object[rels.size() + 1];
        path[0] = this.getStartEntity();
        System.arraycopy(rels.toArray(), 0, path, 1, rels.size());
        this.view.pathBrowser.setSelectionPath(new TreePath(path));
    }

    public void setCollectionType() {
        this.setTargetCollection((String)this.view.collectionTypeCombo.getSelectedItem());
        if (COLLECTION_TYPE_MAP.equals(this.targetCollection)) {
            this.view.mapKeysLabel.setEnabled(true);
            this.view.mapKeysCombo.setEnabled(true);
            this.setMapKey();
        } else {
            this.view.mapKeysLabel.setEnabled(false);
            this.view.mapKeysCombo.setEnabled(false);
        }
    }

    public void setMapKey() {
        this.setMapKey((String)this.view.mapKeysCombo.getSelectedItem());
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public void setSavedDbRelationships(List<DbRelationship> rels) {
        this.savedDbRelationships = rels;
        String currPath = "";
        for (DbRelationship rel : rels) {
            currPath = currPath + "->" + rel.getName();
        }
        if (rels.size() > 0) {
            currPath = currPath.substring(2);
        }
        this.currentPath = currPath;
        this.view.currentPathLabel.setText(currPath);
    }

    public void selectPath() {
        this.setSavedDbRelationships(new ArrayList<DbRelationship>(this.dbRelationships));
    }

    protected void revertPath() {
        this.setSelectionPath(this.getSavedDbRelationships());
        this.setDbRelationships(this.getSavedDbRelationships());
    }

    protected void updateCollectionChoosers() {
        boolean collectionTypeEnabled = this.isToMany();
        this.view.collectionTypeCombo.setEnabled(collectionTypeEnabled);
        this.view.collectionTypeLabel.setEnabled(collectionTypeEnabled);
        if (collectionTypeEnabled) {
            this.view.collectionTypeCombo.setSelectedItem(this.targetCollection);
        }
        boolean mapKeysEnabled = collectionTypeEnabled && COLLECTION_TYPE_MAP.equals(this.view.collectionTypeCombo.getSelectedItem());
        this.view.mapKeysCombo.setEnabled(mapKeysEnabled);
        this.view.mapKeysLabel.setEnabled(mapKeysEnabled);
        if (mapKeysEnabled) {
            this.view.mapKeysCombo.setSelectedItem(this.mapKey);
        }
    }

    protected void clearPath() {
        this.getPathBrowser().clearSelection();
        this.setDbRelationships(new ArrayList<DbRelationship>());
    }

    protected void saveMapping() {
        if (!this.getDbRelationships().equals(this.getSavedDbRelationships()) && JOptionPane.showConfirmDialog(this.getView(), "You have changed Db Relationship path. Do you want it to be saved?", "Save ObjRelationship", 0) == 0) {
            this.selectPath();
        }
        if (this.savePath()) {
            this.mediator.fireObjRelationshipEvent(new RelationshipEvent((Object)Application.getFrame(), this.getRelationship(), this.getRelationship().getSourceEntity()));
        }
        this.view.sourceEntityLabel.setText(this.relationship.getSourceEntity().getName());
        this.view.dispose();
    }

    public MultiColumnBrowser getPathBrowser() {
        return this.view.pathBrowser;
    }

    protected void createRelationship() {
        DbRelationship dbRel = this.getLastRelationship();
        DbEntity source = dbRel != null ? dbRel.getTargetEntity() : null;
        DbRelationshipTarget targetModel = new DbRelationshipTarget(this.mediator, this.getStartEntity(), source);
        targetModel.startupAction();
        if (!targetModel.isSavePressed()) {
            return;
        }
        DbRelationship dbRelationship = new DbRelationship();
        dbRelationship.setSourceEntity(targetModel.getSource());
        dbRelationship.setTargetEntityName(targetModel.getTarget());
        dbRelationship.setToMany(targetModel.isToMany());
        dbRelationship.setName(this.createNamingStrategy(NameGeneratorPreferences.getInstance().getLastUsedStrategies().get(0)).relationshipName(dbRelationship));
        targetModel.getSource().addRelationship(dbRelationship);
        ResolveDbRelationshipDialog dialog = new ResolveDbRelationshipDialog(dbRelationship);
        dialog.setVisible(true);
        if (dialog.isCancelPressed()) {
            targetModel.getSource().removeRelationship(dbRelationship.getName());
        } else {
            Object[] objectArray;
            MultiColumnBrowser pathBrowser = this.getPathBrowser();
            if (targetModel.isSource1Selected()) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.getStartEntity();
            } else {
                objectArray = pathBrowser.getSelectionPath().getPath();
            }
            Object[] oldPath = objectArray;
            EntityTreeModel treeModel = (EntityTreeModel)pathBrowser.getModel();
            treeModel.invalidate();
            pathBrowser.setSelectionPath(new TreePath(new Object[]{this.getStartEntity()}));
            pathBrowser.repaint();
            Object[] path = new Object[oldPath.length + 1];
            System.arraycopy(oldPath, 0, path, 0, path.length - 1);
            path[path.length - 1] = dbRelationship;
            pathBrowser.setSelectionPath(new TreePath(path));
        }
        dialog.dispose();
    }

    public ObjectNameGenerator createNamingStrategy(String strategyClass) {
        try {
            ClassLoadingService classLoader = this.application.getClassLoadingService();
            return classLoader.loadClass(ObjectNameGenerator.class, strategyClass).newInstance();
        }
        catch (Throwable th) {
            JOptionPane.showMessageDialog(this.view, "Naming Strategy Initialization Error: " + th.getMessage(), "Naming Strategy Initialization Error", 0);
            return null;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath selectedPath = e.getPath();
        if (selectedPath == null || selectedPath.getPathCount() < 2) {
            return;
        }
        ArrayList<DbRelationship> relPath = new ArrayList<DbRelationship>(selectedPath.getPathCount() - 1);
        for (int i = 1; i < selectedPath.getPathCount(); ++i) {
            relPath.add((DbRelationship)selectedPath.getPathComponent(i));
        }
        this.setDbRelationships(relPath);
        this.updateCollectionChoosers();
    }

    public void setObjectTarget(ObjEntity objectTarget) {
        if (this.objectTarget != objectTarget) {
            this.objectTarget = objectTarget;
            this.initMapKeys();
        }
    }

    private void initMapKeys() {
        this.mapKeys.clear();
        this.mapKeys.add(DEFAULT_MAP_KEY);
        if (this.objectTarget == null) {
            return;
        }
        for (ObjAttribute attribute : this.objectTarget.getAttributes()) {
            this.mapKeys.add(attribute.getName());
        }
        this.view.mapKeysCombo.removeAllItems();
        for (String s : this.mapKeys) {
            this.view.mapKeysCombo.addItem(s);
        }
        if (this.mapKey != null && !this.mapKeys.contains(this.mapKey)) {
            this.mapKey = DEFAULT_MAP_KEY;
            this.view.mapKeysCombo.setSelectedItem(this.mapKey);
        }
    }

    protected void updateTargetCombo(DbEntity dbTarget) {
        this.objectTargets = new ArrayList<ObjEntity>();
        if (dbTarget != null) {
            this.objectTargets.addAll(dbTarget.getDataMap().getMappedEntities(dbTarget));
            this.objectTargets.sort(Comparators.getNamedObjectComparator());
        }
        this.view.targetCombo.removeAllItems();
        for (ObjEntity s : this.objectTargets) {
            this.view.targetCombo.addItem(s.getName());
        }
    }

    public ObjRelationship getRelationship() {
        return this.relationship;
    }

    public List<DbRelationship> getDbRelationships() {
        return this.dbRelationships;
    }

    public List<DbRelationship> getSavedDbRelationships() {
        return this.savedDbRelationships;
    }

    public DbRelationship getLastRelationship() {
        return this.dbRelationships.size() == 0 ? null : this.dbRelationships.get(this.dbRelationships.size() - 1);
    }

    public void setDbRelationships(List<DbRelationship> rels) {
        this.dbRelationships = rels;
        this.updateTargetCombo(rels.size() > 0 ? rels.get(rels.size() - 1).getTargetEntity() : null);
        this.updateCollectionChoosers();
    }

    public ObjEntity getObjectTarget() {
        return this.objectTarget;
    }

    public List<ObjEntity> getObjectTargets() {
        return this.objectTargets;
    }

    public String getRelationshipName() {
        return this.view.getRelationshipName().getText();
    }

    public void setRelationshipName(String relationshipName) {
        this.view.getRelationshipName().setText(relationshipName);
    }

    public void relationshipChanged(int index) {
        this.breakChain(index);
        this.connectEnds();
    }

    public boolean isToMany() {
        for (DbRelationship relationship : this.dbRelationships) {
            if (relationship == null || !relationship.isToMany()) continue;
            return true;
        }
        return false;
    }

    public boolean savePath() {
        String mapKey;
        String collectionType;
        List<DbRelationship> oldPath;
        boolean hasChanges = false;
        boolean oldToMany = this.relationship.isToMany();
        boolean oldPathNotEmpty = !this.relationship.getDbRelationships().isEmpty();
        String relationshipName = this.getRelationshipName();
        if (!Util.nullSafeEquals(this.relationship.getName(), relationshipName)) {
            hasChanges = true;
            this.relationship.setName(relationshipName);
        }
        if (this.savedDbRelationships.size() > 0) {
            DbEntity lastEntity = this.savedDbRelationships.get(this.savedDbRelationships.size() - 1).getTargetEntity();
            if (this.objectTarget == null || this.objectTarget.getDbEntity() != lastEntity) {
                Collection<ObjEntity> objEntities = lastEntity.getDataMap().getMappedEntities(lastEntity);
                ObjEntity objEntity = this.objectTarget = objEntities.size() == 0 ? null : objEntities.iterator().next();
            }
        }
        if (this.objectTarget == null || !Util.nullSafeEquals(this.objectTarget.getName(), this.relationship.getTargetEntityName())) {
            hasChanges = true;
            this.relationship.setTargetEntityName(this.objectTarget);
        }
        if ((oldPath = this.relationship.getDbRelationships()).size() != this.savedDbRelationships.size()) {
            hasChanges = true;
            this.updatePath();
        } else {
            for (int i = 0; i < oldPath.size(); ++i) {
                DbRelationship next = this.savedDbRelationships.get(i);
                if (oldPath.get(i) == next) continue;
                hasChanges = true;
                this.updatePath();
                break;
            }
        }
        String string = collectionType = "java.util.List".equals(this.targetCollection) || !this.relationship.isToMany() ? null : this.targetCollection;
        if (!Util.nullSafeEquals(collectionType, this.relationship.getCollectionType())) {
            hasChanges = true;
            this.relationship.setCollectionType(collectionType);
        }
        String string2 = mapKey = COLLECTION_TYPE_MAP.equals(collectionType) && !DEFAULT_MAP_KEY.equals(this.mapKey) ? this.mapKey : null;
        if (!Util.nullSafeEquals(mapKey, this.relationship.getMapKey())) {
            hasChanges = true;
            this.relationship.setMapKey(mapKey);
        }
        if (oldPathNotEmpty && hasChanges && this.relationship.isToMany() != oldToMany) {
            DeleteRuleUpdater.updateObjRelationship(this.relationship);
        }
        return hasChanges;
    }

    private void updatePath() {
        this.relationship.clearDbRelationships();
        for (DbRelationship nextPathComponent : this.dbRelationships) {
            if (nextPathComponent == null) break;
            this.relationship.addDbRelationship(nextPathComponent);
        }
    }

    private void breakChain(int index) {
        while (this.dbRelationships.size() > index + 1) {
            this.dbRelationships.remove(this.dbRelationships.size() - 1);
        }
    }

    private void connectEnds() {
        DbEntity target;
        Relationship last = null;
        int size = this.dbRelationships.size();
        if (size > 0) {
            last = this.dbRelationships.get(size - 1);
        }
        if ((target = this.getEndEntity()) != null && (last == null || last.getTargetEntity() != target)) {
            Relationship anyConnector;
            Entity source;
            Entity entity = source = last == null ? this.getStartEntity() : last.getTargetEntity();
            if (source != null && (anyConnector = source.getAnyRelationship(target)) != null) {
                this.dbRelationships.add((DbRelationship)anyConnector);
            }
        }
    }

    private void validateCanMap() {
        if (this.relationship.getSourceEntity() == null) {
            throw new CayenneRuntimeException("Can't map relationship without source entity.", new Object[0]);
        }
        if (this.getStartEntity() == null) {
            JOptionPane.showMessageDialog(this.getView(), "Can't map relationship without source DbEntity. Set source DbEntity.");
            throw new CayenneRuntimeException("Can't map relationship without source DbEntity.", new Object[0]);
        }
    }

    public DbEntity getStartEntity() {
        return this.relationship.getSourceEntity().getDbEntity();
    }

    public DbEntity getEndEntity() {
        if (this.objectTarget == null) {
            return null;
        }
        return this.objectTarget.getDbEntity();
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public String getTargetCollection() {
        return this.targetCollection;
    }

    public void setTargetCollection(String targetCollection) {
        this.targetCollection = targetCollection;
    }

    public List getMapKeys() {
        return this.mapKeys;
    }

    public List<String> getTargetCollections() {
        return this.targetCollections;
    }
}

