/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.reader;

import java.sql.ResultSet;
import java.util.Map;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.reader.DefaultRowReaderFactory;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.crypto.map.ColumnMapper;
import org.apache.cayenne.crypto.transformer.MapTransformer;
import org.apache.cayenne.crypto.transformer.TransformerFactory;
import org.apache.cayenne.crypto.transformer.bytes.BytesDecryptor;
import org.apache.cayenne.crypto.transformer.bytes.BytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.value.ValueDecryptor;
import org.apache.cayenne.crypto.transformer.value.ValueTransformerFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.ScalarResultSegment;

public class CryptoRowReaderFactoryDecorator
extends DefaultRowReaderFactory {
    private TransformerFactory transformerFactory;
    private ColumnMapper columnMapper;
    private BytesTransformerFactory bytesTransformerFactory;
    private ValueTransformerFactory valueTransformerFactory;

    public CryptoRowReaderFactoryDecorator(@Inject TransformerFactory transformerFactory, @Inject ColumnMapper columnMapper, @Inject BytesTransformerFactory bytesTransformerFactory, @Inject ValueTransformerFactory valueTransformerFactory) {
        this.transformerFactory = transformerFactory;
        this.columnMapper = columnMapper;
        this.bytesTransformerFactory = bytesTransformerFactory;
        this.valueTransformerFactory = valueTransformerFactory;
    }

    public RowReader<?> rowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, DbAdapter adapter, Map<ObjAttribute, ColumnDescriptor> attributeOverrides) {
        RowDescriptor encryptedRowDescriptor = this.encryptedRowDescriptor(descriptor, adapter.getExtendedTypes());
        return super.rowReader(encryptedRowDescriptor, queryMetadata, adapter, attributeOverrides);
    }

    protected RowReader<?> createScalarRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, ScalarResultSegment segment) {
        RowReader scalarRowReader = super.createScalarRowReader(descriptor, queryMetadata, segment);
        return new DecoratedScalarRowReader(descriptor.getColumns()[segment.getColumnOffset()], scalarRowReader);
    }

    protected RowReader<?> createEntityRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, EntityResultSegment resultMetadata, DefaultRowReaderFactory.PostprocessorFactory postProcessorFactory) {
        RowReader entityRowReader = super.createEntityRowReader(descriptor, queryMetadata, resultMetadata, postProcessorFactory);
        return new DecoratedFullRowReader(descriptor, entityRowReader);
    }

    protected RowReader<?> createFullRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata, DefaultRowReaderFactory.PostprocessorFactory postProcessorFactory) {
        RowReader fullRowReader = super.createFullRowReader(descriptor, queryMetadata, postProcessorFactory);
        return new DecoratedFullRowReader(descriptor, fullRowReader);
    }

    protected RowDescriptor encryptedRowDescriptor(RowDescriptor descriptor, ExtendedTypeMap typeMap) {
        ColumnDescriptor[] originalColumns = descriptor.getColumns();
        int len = originalColumns.length;
        ExtendedType[] originalConverters = descriptor.getConverters();
        ExtendedType[] encryptedConverters = new ExtendedType[len];
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute = originalColumns[i].getAttribute();
            ExtendedType t = originalConverters[i];
            if (attribute != null && this.columnMapper.isEncrypted(attribute)) {
                if (TypesMapping.isBinary((int)attribute.getType())) {
                    t = typeMap.getRegisteredType(byte[].class);
                } else if (TypesMapping.isCharacter((int)attribute.getType())) {
                    t = typeMap.getRegisteredType(String.class);
                }
            }
            encryptedConverters[i] = t;
        }
        return new DecoratedRowDescriptor(descriptor, originalColumns, encryptedConverters);
    }

    private class DecoratedFullRowReader
    implements RowReader<Object> {
        private final RowDescriptor descriptor;
        private final RowReader<?> delegateReader;
        private boolean decryptorCompiled;
        private MapTransformer decryptor;

        DecoratedFullRowReader(RowDescriptor descriptor, RowReader<?> delegateReader) {
            this.descriptor = descriptor;
            this.delegateReader = delegateReader;
        }

        private void ensureDecryptorCompiled(Object row) {
            if (!this.decryptorCompiled) {
                this.decryptor = CryptoRowReaderFactoryDecorator.this.transformerFactory.decryptor(this.descriptor.getColumns(), row);
                this.decryptorCompiled = true;
            }
        }

        public Object readRow(ResultSet resultSet) {
            Object row = this.delegateReader.readRow(resultSet);
            this.ensureDecryptorCompiled(row);
            if (this.decryptor != null) {
                Map map = (Map)row;
                this.decryptor.transform(map);
            }
            return row;
        }
    }

    private class DecoratedScalarRowReader
    implements RowReader<Object> {
        private final RowReader<?> delegateReader;
        private final ValueDecryptor valueDecryptor;
        private final BytesDecryptor bytesDecryptor;

        DecoratedScalarRowReader(ColumnDescriptor descriptor, RowReader<?> delegateReader) {
            this.delegateReader = delegateReader;
            if (descriptor.getAttribute() != null && CryptoRowReaderFactoryDecorator.this.columnMapper.isEncrypted(descriptor.getAttribute())) {
                this.valueDecryptor = CryptoRowReaderFactoryDecorator.this.valueTransformerFactory.decryptor(descriptor.getAttribute());
                this.bytesDecryptor = CryptoRowReaderFactoryDecorator.this.bytesTransformerFactory.decryptor();
            } else {
                this.valueDecryptor = null;
                this.bytesDecryptor = null;
            }
        }

        public Object readRow(ResultSet resultSet) {
            Object value = this.delegateReader.readRow(resultSet);
            if (this.valueDecryptor == null) {
                return value;
            }
            return this.valueDecryptor.decrypt(this.bytesDecryptor, value);
        }
    }

    private static class DecoratedRowDescriptor
    extends RowDescriptor {
        private final RowDescriptor original;

        DecoratedRowDescriptor(RowDescriptor rowDescriptor, ColumnDescriptor[] columns, ExtendedType[] converters) {
            this.original = rowDescriptor;
            this.columns = columns;
            this.converters = converters;
        }

        public RowDescriptor unwrap() {
            return this.original;
        }
    }
}

