/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.editor.cgen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.util.ComboBoxAdapter;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.swing.components.JCayenneCheckBox;
import org.apache.cayenne.validation.ValidationException;

public class CustomModePanel
extends GeneratorControllerPanel {
    private ComboBoxAdapter<String> subclassTemplate;
    private ComboBoxAdapter<String> superclassTemplate;
    private JCheckBox pairs;
    private JCheckBox overwrite;
    private JCheckBox usePackagePath;
    private TextAdapter outputPattern;
    private JCheckBox createPropertyNames;
    private JCheckBox pkProperties;
    private JCheckBox clientMode;
    private TextAdapter superPkg;
    private JButton manageTemplatesLink;

    CustomModePanel(final ProjectController projectController, final CodeGeneratorControllerBase codeGeneratorControllerBase) {
        super(projectController, codeGeneratorControllerBase);
        JComboBox superclassField = new JComboBox();
        this.superclassTemplate = new ComboBoxAdapter<String>(superclassField){

            @Override
            protected void updateModel(String item) throws ValidationException {
                CgenConfiguration cgenConfiguration = CustomModePanel.this.getCgenByDataMap();
                cgenConfiguration.setSuperTemplate(Application.getInstance().getCodeTemplateManager().getTemplatePath(item, cgenConfiguration.getDataMap().getConfigurationSource()));
                if (!codeGeneratorControllerBase.isInitFromModel()) {
                    projectController.setDirty(true);
                }
            }
        };
        JComboBox subclassField = new JComboBox();
        this.subclassTemplate = new ComboBoxAdapter<String>(subclassField){

            @Override
            protected void updateModel(String item) throws ValidationException {
                CgenConfiguration cgenConfiguration = CustomModePanel.this.getCgenByDataMap();
                cgenConfiguration.setTemplate(Application.getInstance().getCodeTemplateManager().getTemplatePath(item, cgenConfiguration.getDataMap().getConfigurationSource()));
                if (!codeGeneratorControllerBase.isInitFromModel()) {
                    projectController.setDirty(true);
                }
            }
        };
        this.pairs = new JCayenneCheckBox();
        this.overwrite = new JCayenneCheckBox();
        this.usePackagePath = new JCayenneCheckBox();
        JTextField outputPatternField = new JTextField();
        this.outputPattern = new TextAdapter(outputPatternField){

            @Override
            protected void updateModel(String text) {
                CustomModePanel.this.getCgenByDataMap().setOutputPattern(text);
                if (!codeGeneratorControllerBase.isInitFromModel()) {
                    projectController.setDirty(true);
                }
            }
        };
        JTextField superPkgField = new JTextField();
        this.superPkg = new TextAdapter(superPkgField){

            @Override
            protected void updateModel(String text) throws ValidationException {
                CustomModePanel.this.getCgenByDataMap().setSuperPkg(text);
                if (!codeGeneratorControllerBase.isInitFromModel()) {
                    projectController.setDirty(true);
                }
            }
        };
        this.createPropertyNames = new JCayenneCheckBox();
        this.pkProperties = new JCayenneCheckBox();
        this.clientMode = new JCayenneCheckBox();
        this.manageTemplatesLink = new JButton("Customize Templates...");
        this.manageTemplatesLink.setFont(this.manageTemplatesLink.getFont().deriveFont(10.0f));
        this.pairs.addChangeListener(e -> {
            this.setDisableSuperComboBoxes(this.pairs.isSelected());
            this.overwrite.setEnabled(!this.pairs.isSelected());
        });
        FormLayout layout = new FormLayout("right:74dlu, 1dlu, fill:240:grow, 1dlu, left:100dlu, 100dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append("Output Directory:", (Component)this.outputFolder.getComponent(), (Component)this.selectOutputFolder);
        builder.nextLine();
        builder.append("Subclass Template:", this.subclassTemplate.getComboBox());
        builder.nextLine();
        builder.append("Superclass Template:", this.superclassTemplate.getComboBox());
        builder.nextLine();
        builder.append("Output Pattern:", (Component)this.outputPattern.getComponent());
        builder.nextLine();
        builder.append("Make Pairs:", (Component)this.pairs);
        builder.nextLine();
        builder.append("Use Package Path:", (Component)this.usePackagePath);
        builder.nextLine();
        builder.append("Overwrite Subclasses:", (Component)this.overwrite);
        builder.nextLine();
        builder.append("Create Property Names:", (Component)this.createPropertyNames);
        builder.nextLine();
        builder.append("Create PK properties:", (Component)this.pkProperties);
        builder.nextLine();
        builder.append("Client mode: ", (Component)this.clientMode);
        builder.nextLine();
        builder.append("Superclass package:", (Component)this.superPkg.getComponent());
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
        JPanel links = new JPanel(new FlowLayout(4));
        links.add(this.manageTemplatesLink);
        this.add((Component)links, "South");
    }

    public void setDisableSuperComboBoxes(boolean val) {
        this.superclassTemplate.getComboBox().setEnabled(val);
    }

    public JButton getManageTemplatesLink() {
        return this.manageTemplatesLink;
    }

    public ComboBoxAdapter<String> getSubclassTemplate() {
        return this.subclassTemplate;
    }

    public ComboBoxAdapter<String> getSuperclassTemplate() {
        return this.superclassTemplate;
    }

    public JCheckBox getOverwrite() {
        return this.overwrite;
    }

    public JCheckBox getPairs() {
        return this.pairs;
    }

    public JCheckBox getUsePackagePath() {
        return this.usePackagePath;
    }

    public TextAdapter getOutputPattern() {
        return this.outputPattern;
    }

    public JCheckBox getCreatePropertyNames() {
        return this.createPropertyNames;
    }

    public JCheckBox getPkProperties() {
        return this.pkProperties;
    }

    public JCheckBox getClientMode() {
        return this.clientMode;
    }

    public TextAdapter getSuperPkg() {
        return this.superPkg;
    }
}

