/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.awt.Component;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.modeler.CodeTemplateManager;
import org.apache.cayenne.modeler.dialog.cgen.TemplateDialog;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.editor.cgen.CustomModePanel;
import org.apache.cayenne.modeler.editor.cgen.GeneratorController;
import org.apache.cayenne.modeler.editor.cgen.GeneratorControllerPanel;
import org.apache.cayenne.swing.BindingBuilder;

public class CustomModeController
extends GeneratorController {
    protected CustomModePanel view;

    public CustomModeController(CodeGeneratorControllerBase parent) {
        super(parent);
        this.bind();
        this.initListeners();
    }

    @Override
    protected GeneratorControllerPanel createView() {
        this.view = new CustomModePanel(this.getApplication().getFrameController().getProjectController(), this.getParentController());
        return this.view;
    }

    private void bind() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getManageTemplatesLink(), "popPreferencesAction()");
    }

    protected void updateTemplates() {
        boolean isClient = this.cgenConfiguration.isClient();
        CodeTemplateManager templateManager = this.getApplication().getCodeTemplateManager();
        ArrayList<String> customTemplates = new ArrayList<String>(templateManager.getCustomTemplates().keySet());
        Collections.sort(customTemplates);
        ArrayList<String> superTemplates = isClient ? new ArrayList<String>(templateManager.getStandardClientSuperclassTemplates()) : new ArrayList<String>(templateManager.getStandardSuperclassTemplates());
        Collections.sort(superTemplates);
        superTemplates.addAll(customTemplates);
        ArrayList<String> subTemplates = isClient ? new ArrayList<String>(templateManager.getStandardClientSubclassTemplates()) : new ArrayList<String>(templateManager.getStandardSubclassTemplates());
        Collections.sort(subTemplates);
        subTemplates.addAll(customTemplates);
        this.view.getSubclassTemplate().getComboBox().setModel(new DefaultComboBoxModel<String>(subTemplates.toArray(new String[0])));
        this.view.getSuperclassTemplate().getComboBox().setModel(new DefaultComboBoxModel<String>(superTemplates.toArray(new String[0])));
    }

    @Override
    public Component getView() {
        return this.view;
    }

    public void missTemplateDialog(CgenConfiguration cgenConfiguration, String template, String superTemplate) {
        new TemplateDialog(this, cgenConfiguration, template, superTemplate).startupAction();
        this.updateComboBoxes();
    }

    public void popPreferencesAction() {
        new PreferenceDialog(this.getApplication().getFrameController()).startupAction("Templates");
        this.updateTemplates();
        this.updateComboBoxes();
    }

    public void addTemplateAction(String template, String superTemplate) {
        new PreferenceDialog(this.getApplication().getFrameController()).startupToCreateTemplate(template, superTemplate);
        this.updateTemplates();
    }

    private void updateComboBoxes() {
        String templateName = this.getApplication().getCodeTemplateManager().getNameByPath(this.cgenConfiguration.getTemplate(), this.cgenConfiguration.getRootPath());
        String superTemplateName = this.getApplication().getCodeTemplateManager().getNameByPath(this.cgenConfiguration.getSuperTemplate(), this.cgenConfiguration.getRootPath());
        String path = this.cgenConfiguration.getRootPath().resolve(Paths.get(this.cgenConfiguration.getTemplate(), new String[0])).normalize().toString();
        String superPath = this.cgenConfiguration.getRootPath().resolve(Paths.get(this.cgenConfiguration.getSuperTemplate(), new String[0])).normalize().toString();
        if (templateName == null && superTemplateName == null) {
            this.view.getSubclassTemplate().setItem(null);
            this.view.getSuperclassTemplate().setItem(null);
            this.missTemplateDialog(this.cgenConfiguration, path, superPath);
        } else if (templateName == null) {
            this.view.getSubclassTemplate().setItem(null);
            this.missTemplateDialog(this.cgenConfiguration, path, null);
        } else if (superTemplateName == null) {
            this.view.getSuperclassTemplate().setItem(null);
            this.missTemplateDialog(this.cgenConfiguration, null, superPath);
        } else {
            this.view.getSubclassTemplate().setItem(templateName);
            this.view.getSuperclassTemplate().setItem(superTemplateName);
        }
        this.view.setDisableSuperComboBoxes(this.view.getPairs().isSelected());
    }

    private void initListeners() {
        this.view.getPairs().addActionListener(val -> {
            this.cgenConfiguration.setMakePairs(this.view.getPairs().isSelected());
            if (!this.view.getPairs().isSelected()) {
                this.cgenConfiguration.setTemplate("templates/v4_1/singleclass.vm");
                this.cgenConfiguration.setEmbeddableTemplate("templates/v4_1/embeddable-singleclass.vm");
                this.cgenConfiguration.setQueryTemplate("templates/v4_1/datamap-singleclass.vm");
            } else {
                this.cgenConfiguration.setTemplate("templates/v4_1/subclass.vm");
                this.cgenConfiguration.setEmbeddableTemplate("templates/v4_1/embeddable-subclass.vm");
                this.cgenConfiguration.setQueryTemplate("templates/v4_1/datamap-subclass.vm");
            }
            this.initForm(this.cgenConfiguration);
            if (!this.getParentController().isInitFromModel()) {
                this.getParentController().getProjectController().setDirty(true);
            }
        });
        this.view.getOverwrite().addActionListener(val -> {
            this.cgenConfiguration.setOverwrite(this.view.getOverwrite().isSelected());
            if (!this.getParentController().isInitFromModel()) {
                this.getParentController().getProjectController().setDirty(true);
            }
        });
        this.view.getCreatePropertyNames().addActionListener(val -> {
            this.cgenConfiguration.setCreatePropertyNames(this.view.getCreatePropertyNames().isSelected());
            if (!this.getParentController().isInitFromModel()) {
                this.getParentController().getProjectController().setDirty(true);
            }
        });
        this.view.getUsePackagePath().addActionListener(val -> {
            this.cgenConfiguration.setUsePkgPath(this.view.getUsePackagePath().isSelected());
            if (!this.getParentController().isInitFromModel()) {
                this.getParentController().getProjectController().setDirty(true);
            }
        });
        this.view.getPkProperties().addActionListener(val -> {
            this.cgenConfiguration.setCreatePKProperties(this.view.getPkProperties().isSelected());
            if (!this.getParentController().isInitFromModel()) {
                this.getParentController().getProjectController().setDirty(true);
            }
        });
        this.view.getClientMode().addActionListener(val -> {
            boolean isSelected = this.view.getClientMode().isSelected();
            this.cgenConfiguration.setClient(isSelected);
            if (isSelected) {
                this.cgenConfiguration.setTemplate("templates/v4_1/client-subclass.vm");
                this.cgenConfiguration.setSuperTemplate("templates/v4_1/client-superclass.vm");
            } else {
                this.cgenConfiguration.setTemplate("templates/v4_1/subclass.vm");
                this.cgenConfiguration.setSuperTemplate("templates/v4_1/superclass.vm");
            }
            this.updateTemplates();
            String templateName = this.getApplication().getCodeTemplateManager().getNameByPath(isSelected ? "templates/v4_1/client-subclass.vm" : "templates/v4_1/subclass.vm", this.cgenConfiguration.getRootPath());
            String superTemplateName = this.getApplication().getCodeTemplateManager().getNameByPath(isSelected ? "templates/v4_1/client-subclass.vm" : "templates/v4_1/subclass.vm", this.cgenConfiguration.getRootPath());
            this.view.getSubclassTemplate().setItem(templateName);
            this.view.getSuperclassTemplate().setItem(superTemplateName);
            if (!this.getParentController().isInitFromModel()) {
                this.getParentController().getProjectController().setDirty(true);
            }
        });
    }

    @Override
    public void initForm(CgenConfiguration cgenConfiguration) {
        super.initForm(cgenConfiguration);
        this.view.getClientMode().setSelected(cgenConfiguration.isClient());
        this.updateTemplates();
        this.view.getOutputPattern().setText(cgenConfiguration.getOutputPattern());
        this.view.getPairs().setSelected(cgenConfiguration.isMakePairs());
        this.view.getUsePackagePath().setSelected(cgenConfiguration.isUsePkgPath());
        this.view.getOverwrite().setSelected(cgenConfiguration.isOverwrite());
        this.view.getCreatePropertyNames().setSelected(cgenConfiguration.isCreatePropertyNames());
        this.view.getPkProperties().setSelected(cgenConfiguration.isCreatePKProperties());
        this.view.getSuperPkg().setText(cgenConfiguration.getSuperPkg());
        this.updateComboBoxes();
        this.getParentController().setInitFromModel(false);
    }

    @Override
    public void updateConfiguration(CgenConfiguration cgenConfiguration) {
    }
}

