/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjAttributeListener;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.ActionManager;
import org.apache.cayenne.modeler.action.CopyAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.CutAttributeRelationshipAction;
import org.apache.cayenne.modeler.action.ObjEntityToSuperEntityAction;
import org.apache.cayenne.modeler.action.PasteAction;
import org.apache.cayenne.modeler.action.RemoveAttributeRelationshipAction;
import org.apache.cayenne.modeler.dialog.objentity.ObjAttributeInfoDialog;
import org.apache.cayenne.modeler.editor.ObjAttributeTableModel;
import org.apache.cayenne.modeler.editor.ObjEntityAttributeRelationshipTab;
import org.apache.cayenne.modeler.editor.wrapper.ObjAttributeWrapper;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.event.ObjEntityDisplayListener;
import org.apache.cayenne.modeler.event.ProjectOnSaveEvent;
import org.apache.cayenne.modeler.event.ProjectOnSaveListener;
import org.apache.cayenne.modeler.event.TablePopupHandler;
import org.apache.cayenne.modeler.pref.TableColumnPreferences;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.CayenneTable;
import org.apache.cayenne.modeler.util.CayenneTableModel;
import org.apache.cayenne.modeler.util.DbAttributePathComboBoxEditor;
import org.apache.cayenne.modeler.util.DbAttributePathComboBoxRenderer;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PanelFactory;
import org.apache.cayenne.modeler.util.ProjectUtil;
import org.apache.cayenne.modeler.util.UIUtil;
import org.apache.cayenne.modeler.util.combo.AutoCompletion;

public class ObjEntityAttributePanel
extends JPanel
implements ObjEntityDisplayListener,
ObjEntityListener,
ObjAttributeListener,
ProjectOnSaveListener {
    private static final ImageIcon INHERITANCE_ICON = ModelerUtil.buildIcon("icon-inheritance.png");
    private ProjectController mediator;
    private CayenneTable table;
    private TableColumnPreferences tablePreferences;
    private ObjEntityAttributeRelationshipTab parentPanel;
    private boolean enabledResolve;
    private ActionListener resolver;
    private JMenuItem resolveMenu;

    public ObjEntityAttributePanel(ProjectController mediator, ObjEntityAttributeRelationshipTab parentPanel) {
        this.mediator = mediator;
        this.parentPanel = parentPanel;
        this.initView();
        this.initController();
    }

    public CayenneTable getTable() {
        return this.table;
    }

    public void setTable(CayenneTable table) {
        this.table = table;
    }

    private void initView() {
        this.setLayout(new BorderLayout());
        ActionManager actionManager = Application.getInstance().getActionManager();
        this.table = new CayenneTable();
        this.table.setDefaultRenderer(String.class, new CellRenderer());
        this.tablePreferences = new TableColumnPreferences(ObjAttributeTableModel.class, "objEntity/attributeTable");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = ObjEntityAttributePanel.this.table.rowAtPoint(e.getPoint());
                int col = ObjEntityAttributePanel.this.table.columnAtPoint(e.getPoint());
                ObjAttribute objAttribute = ((ObjAttributeTableModel)ObjEntityAttributePanel.this.table.getModel()).getAttribute(row).getValue();
                int columnFromModel = ObjEntityAttributePanel.this.table.getColumnModel().getColumn(col).getModelIndex();
                if (row >= 0 && columnFromModel == 0 && objAttribute.isInherited()) {
                    TableCellRenderer renderer = ObjEntityAttributePanel.this.table.getCellRenderer(row, col);
                    Rectangle rectangle = ObjEntityAttributePanel.this.table.getCellRect(row, col, false);
                    ((CellRenderer)renderer).mouseClicked(e, rectangle.x);
                }
            }
        });
        ImageIcon ico = ModelerUtil.buildIcon("icon-edit.png");
        this.resolveMenu = new CayenneAction.CayenneMenuItem("Edit Attribute", ico);
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.resolveMenu);
        popup.add(actionManager.getAction(RemoveAttributeRelationshipAction.class).buildMenu());
        popup.addSeparator();
        popup.add(actionManager.getAction(CutAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(CopyAttributeRelationshipAction.class).buildMenu());
        popup.add(actionManager.getAction(PasteAction.class).buildMenu());
        TablePopupHandler.install(this.table, popup);
        this.add((Component)PanelFactory.createTablePanel(this.table, null), "Center");
    }

    private void initController() {
        this.mediator.addObjEntityDisplayListener(this);
        this.mediator.addObjEntityListener(this);
        this.mediator.addObjAttributeListener(this);
        this.resolver = e -> {
            int row = this.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
            new ObjAttributeInfoDialog(this.mediator, row, model).startupAction();
            this.table.cancelEditing();
            this.table.getSelectionModel().clearSelection();
            this.table.select(row);
            this.enabledResolve = false;
        };
        this.resolveMenu.addActionListener(this.resolver);
        this.table.getSelectionModel().addListSelectionListener(new ObjAttributeListSelectionListener());
        this.table.setAutoResizeMode(0);
        this.mediator.getApplication().getActionManager().setupCutCopyPaste(this.table, CutAttributeRelationshipAction.class, CopyAttributeRelationshipAction.class);
    }

    public void initComboBoxes() {
        ArrayList<String> embeddableNames = new ArrayList<String>();
        ArrayList<String> typeNames = new ArrayList<String>();
        for (DataMap dataMap : ((DataChannelDescriptor)this.mediator.getProject().getRootNode()).getDataMaps()) {
            for (Embeddable emb : dataMap.getEmbeddables()) {
                embeddableNames.add(emb.getClassName());
            }
        }
        String[] registeredTypes = ModelerUtil.getRegisteredTypeNames();
        Collections.addAll(typeNames, registeredTypes);
        typeNames.addAll(embeddableNames);
        TableColumn typeColumn = this.table.getColumnModel().getColumn(1);
        JComboBox<Object> javaTypesCombo = Application.getWidgetFactory().createComboBox(typeNames.toArray(), false);
        AutoCompletion.enable(javaTypesCombo, false, true);
        typeColumn.setCellEditor(Application.getWidgetFactory().createCellEditor(javaTypesCombo));
    }

    public void selectAttributes(ObjAttribute[] attrs) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        List listAttrs = model.getObjectList();
        int[] newSel = new int[attrs.length];
        this.parentPanel.updateActions(attrs);
        block0: for (int i = 0; i < attrs.length; ++i) {
            for (int j = 0; j < listAttrs.size(); ++j) {
                if (((ObjAttributeWrapper)listAttrs.get(j)).getValue() != attrs[i]) continue;
                newSel[i] = j;
                continue block0;
            }
        }
        this.table.select(newSel);
        this.parentPanel.getResolve().removeActionListener(this.getResolver());
        this.parentPanel.getResolve().addActionListener(this.getResolver());
    }

    @Override
    public void objAttributeChanged(AttributeEvent e) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        if (!model.isValid()) {
            model.resetModel();
        }
        model.fireTableDataChanged();
        int ind = -1;
        List list = model.getObjectList();
        for (int i = 0; i < list.size(); ++i) {
            if (((ObjAttributeWrapper)list.get(i)).getValue() != e.getAttribute()) continue;
            ind = i;
        }
        this.table.select(ind);
        if (e.getOldName() != null) {
            this.removeDuplicateAttribute(e);
        }
    }

    @Override
    public void objAttributeAdded(AttributeEvent e) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        if (!model.isValid()) {
            model.resetModel();
        }
        model.addRow(new ObjAttributeWrapper((ObjAttribute)e.getAttribute()));
        model.fireTableDataChanged();
        int ind = -1;
        List list = model.getObjectList();
        for (int i = 0; i < list.size(); ++i) {
            if (((ObjAttributeWrapper)list.get(i)).getValue() != e.getAttribute()) continue;
            ind = i;
        }
        this.table.select(ind);
    }

    @Override
    public void objAttributeRemoved(AttributeEvent e) {
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        int ind = -1;
        List list = model.getObjectList();
        for (int i = 0; i < list.size(); ++i) {
            if (((ObjAttributeWrapper)list.get(i)).getValue() != e.getAttribute()) continue;
            ind = i;
        }
        if (!model.isValid()) {
            model.resetModel();
        }
        if (ind >= 0) {
            model.removeRow(list.get(ind));
            model.fireTableDataChanged();
            this.table.select(ind);
        }
    }

    public void removeDuplicateAttribute(AttributeEvent e) {
        Collection<ObjEntity> objEntities = ProjectUtil.getCollectionOfChildren((ObjEntity)e.getEntity());
        for (ObjEntity objEntity : objEntities) {
            if (objEntity.getDeclaredAttribute(e.getAttribute().getName()) == null) continue;
            JOptionPane pane = new JOptionPane(String.format("'%s' and '%s' can't have attribute '%s' together. Would you like to delete this attribute from the '%s' class?", objEntity.getName(), e.getEntity().getName(), e.getAttribute().getName(), objEntity.getName()), 3, 0);
            JDialog dialog = pane.createDialog(Application.getFrame(), "Confirm Remove");
            dialog.setVisible(true);
            Object selectedValue = pane.getValue();
            boolean shouldDelete = selectedValue != null && selectedValue.equals(0);
            if (!shouldDelete) continue;
            objEntity.removeAttribute(e.getAttribute().getName());
            objEntity.removeAttributeOverride(e.getAttribute().getName());
        }
    }

    @Override
    public void currentObjEntityChanged(EntityDisplayEvent e) {
        if (e.getSource() == this) {
            return;
        }
        ObjEntity entity = (ObjEntity)e.getEntity();
        if (entity != null) {
            this.rebuildTable(entity);
        }
        if (e.isUnselectAttributes()) {
            this.table.clearSelection();
        }
    }

    protected void rebuildTable(ObjEntity entity) {
        if (this.table.getEditingRow() != -1 && this.table.getEditingColumn() != -1) {
            TableCellEditor cellEditor = this.table.getCellEditor(this.table.getEditingRow(), this.table.getEditingColumn());
            cellEditor.stopCellEditing();
        }
        ObjAttributeTableModel model = new ObjAttributeTableModel(entity, this.mediator, this);
        this.table.setModel(model);
        this.table.setRowHeight(25);
        this.table.setRowMargin(3);
        this.setUpTableStructure();
    }

    protected void setUpTableStructure() {
        HashMap<Integer, Integer> minSizes = new HashMap<Integer, Integer>();
        minSizes.put(0, 150);
        this.initComboBoxes();
        this.table.getColumnModel().getColumn(2).setCellRenderer(new DbAttributePathComboBoxRenderer());
        this.table.getColumnModel().getColumn(2).setCellEditor(new DbAttributePathComboBoxEditor());
        this.tablePreferences.bind(this.table, minSizes, null, null, 0, true);
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
        if (e.getSource() == this) {
            return;
        }
        if (!(this.table.getModel() instanceof ObjAttributeTableModel)) {
            return;
        }
        ObjAttributeTableModel model = (ObjAttributeTableModel)this.table.getModel();
        if (model.getDbEntity() != ((ObjEntity)e.getEntity()).getDbEntity()) {
            model.resetDbEntity();
            this.setUpTableStructure();
        }
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
        if (e.getSource() == this) {
            return;
        }
        this.rebuildTable((ObjEntity)e.getEntity());
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
    }

    private void resetTableModel() {
        CayenneTableModel model = this.table.getCayenneModel();
        if (model != null && !model.isValid()) {
            model.resetModel();
            model.fireTableDataChanged();
        }
    }

    @Override
    public void beforeSaveChanges(ProjectOnSaveEvent e) {
        this.resetTableModel();
    }

    public boolean isEnabledResolve() {
        return this.enabledResolve;
    }

    public ActionListener getResolver() {
        return this.resolver;
    }

    private class ObjAttributeListSelectionListener
    implements ListSelectionListener {
        private ObjAttributeListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object[] attrs = new ObjAttribute[]{};
            if (!e.getValueIsAdjusting() && !((ListSelectionModel)e.getSource()).isSelectionEmpty()) {
                ObjEntityAttributePanel.this.parentPanel.getRelationshipPanel().getTable().getSelectionModel().clearSelection();
                if (ObjEntityAttributePanel.this.parentPanel.getRelationshipPanel().getTable().getCellEditor() != null) {
                    ObjEntityAttributePanel.this.parentPanel.getRelationshipPanel().getTable().getCellEditor().stopCellEditing();
                }
                Application.getInstance().getActionManager().getAction(RemoveAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityAttributePanel.this.parentPanel.getAttributePanel());
                Application.getInstance().getActionManager().getAction(CutAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityAttributePanel.this.parentPanel.getAttributePanel());
                Application.getInstance().getActionManager().getAction(CopyAttributeRelationshipAction.class).setCurrentSelectedPanel(ObjEntityAttributePanel.this.parentPanel.getAttributePanel());
                ObjEntityAttributePanel.this.parentPanel.getResolve().removeActionListener(ObjEntityAttributePanel.this.parentPanel.getRelationshipPanel().getResolver());
                ObjEntityAttributePanel.this.parentPanel.getResolve().removeActionListener(ObjEntityAttributePanel.this.getResolver());
                ObjEntityAttributePanel.this.parentPanel.getResolve().addActionListener(ObjEntityAttributePanel.this.getResolver());
                ObjEntityAttributePanel.this.parentPanel.getResolve().setToolTipText("Edit Attribute");
                ObjEntityAttributePanel.this.parentPanel.getResolve().setEnabled(true);
                if (ObjEntityAttributePanel.this.table.getSelectedRow() >= 0) {
                    ObjAttributeTableModel model = (ObjAttributeTableModel)ObjEntityAttributePanel.this.table.getModel();
                    int[] sel = ObjEntityAttributePanel.this.table.getSelectedRows();
                    attrs = new ObjAttribute[sel.length];
                    for (int i = 0; i < sel.length; ++i) {
                        attrs[i] = model.getAttribute(sel[i]).getValue();
                    }
                    if (sel.length == 1) {
                        UIUtil.scrollToSelectedRow(ObjEntityAttributePanel.this.table);
                    }
                    ObjEntityAttributePanel.this.enabledResolve = true;
                } else {
                    ObjEntityAttributePanel.this.enabledResolve = false;
                }
                ObjEntityAttributePanel.this.resolveMenu.setEnabled(ObjEntityAttributePanel.this.enabledResolve);
            }
            ObjEntityAttributePanel.this.mediator.setCurrentObjAttributes((ObjAttribute[])attrs);
            ObjEntityAttributePanel.this.parentPanel.updateActions(attrs);
        }
    }

    final class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ObjAttributeTableModel model = (ObjAttributeTableModel)table.getModel();
            column = table.getColumnModel().getColumn(column).getModelIndex();
            ObjAttribute attribute = model.getAttribute(row).getValue();
            if (!model.isCellEditable(row, column)) {
                this.setForeground(isSelected ? new Color(0xEEEEEE) : Color.GRAY);
            } else {
                this.setForeground(isSelected && !hasFocus ? table.getSelectionForeground() : table.getForeground());
            }
            this.setIcon(null);
            if (attribute.isInherited()) {
                Font font = this.getFont();
                Font newFont = font.deriveFont(2);
                this.setFont(newFont);
                if (column == 0) {
                    this.setIcon(INHERITANCE_ICON);
                }
            }
            this.setFont(UIManager.getFont("Label.font"));
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            return this;
        }

        public void mouseClicked(MouseEvent event, int x) {
            Point point = event.getPoint();
            if (point.x - x <= INHERITANCE_ICON.getIconWidth()) {
                ActionManager actionManager = Application.getInstance().getActionManager();
                actionManager.getAction(ObjEntityToSuperEntityAction.class).performAction(null);
            }
        }
    }
}

