/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.ClientEntityResolver;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.MappingCache;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProxiedMappingNamespace;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.reflect.SingletonFaultFactory;
import org.apache.cayenne.reflect.generic.DataObjectDescriptorFactory;
import org.apache.cayenne.reflect.valueholder.ValueHolderDescriptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityResolver
implements MappingNamespace,
Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(EntityResolver.class);
    protected static AtomicLong incrementer = new AtomicLong();
    protected Collection<DataMap> maps;
    protected transient MappingNamespace mappingCache;
    protected EntityResolver clientEntityResolver;
    protected volatile transient ClassDescriptorMap classDescriptorMap;
    protected transient LifecycleCallbackRegistry callbackRegistry;
    protected transient ValueObjectTypeRegistry valueObjectTypeRegistry;

    public EntityResolver() {
        this(Collections.emptyList());
    }

    public EntityResolver(Collection<DataMap> dataMaps) {
        this.maps = new ArrayList<DataMap>(dataMaps);
        this.refreshMappingCache();
    }

    public void applyDBLayerDefaults() {
        for (DataMap map : this.getDataMaps()) {
            for (DbEntity entity : map.getDbEntities()) {
                DbRelationship[] relationships;
                for (DbRelationship relationship : relationships = entity.getRelationships().toArray(new DbRelationship[entity.getRelationships().size()])) {
                    if (relationship.getReverseRelationship() != null) continue;
                    DbRelationship reverse = relationship.createReverseRelationship();
                    DbEntity targetEntity = reverse.getSourceEntity();
                    reverse.setName(this.getUniqueRelationshipName(targetEntity));
                    reverse.setRuntime(true);
                    targetEntity.addRelationship(reverse);
                    logger.info("added runtime complimentary DbRelationship from " + targetEntity.getName() + " to " + reverse.getTargetEntityName());
                }
            }
        }
    }

    private String getUniqueRelationshipName(Entity entity) {
        String name;
        while (entity.getRelationship(name = "runtimeRelationship" + incrementer.getAndIncrement()) != null) {
        }
        return name;
    }

    synchronized void initCallbacks() {
        if (this.callbackRegistry == null) {
            LifecycleCallbackRegistry callbackRegistry = new LifecycleCallbackRegistry(this);
            for (ObjEntity entity : this.getObjEntities()) {
                CallbackDescriptor[] callbacks;
                Class<?> entityClass = entity.getJavaClass();
                for (CallbackDescriptor callback : callbacks = entity.getCallbackMap().getCallbacks()) {
                    for (String method : callback.getCallbackMethods()) {
                        callbackRegistry.addCallback(callback.getCallbackType(), entityClass, method);
                    }
                }
            }
            this.callbackRegistry = callbackRegistry;
        }
    }

    public LifecycleCallbackRegistry getCallbackRegistry() {
        if (this.callbackRegistry == null) {
            this.initCallbacks();
        }
        return this.callbackRegistry;
    }

    public void setCallbackRegistry(LifecycleCallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityResolver getClientEntityResolver() {
        if (this.clientEntityResolver == null) {
            EntityResolver entityResolver = this;
            synchronized (entityResolver) {
                if (this.clientEntityResolver == null) {
                    ClientEntityResolver resolver = new ClientEntityResolver();
                    for (DataMap map : this.getDataMaps()) {
                        DataMap clientMap = map.getClientDataMap(this);
                        if (clientMap == null) continue;
                        resolver.addDataMap(clientMap);
                    }
                    this.clientEntityResolver = resolver;
                }
            }
        }
        return this.clientEntityResolver;
    }

    @Override
    public Collection<DbEntity> getDbEntities() {
        this.checkMappingCache();
        return this.mappingCache.getDbEntities();
    }

    @Override
    public Collection<ObjEntity> getObjEntities() {
        this.checkMappingCache();
        return this.mappingCache.getObjEntities();
    }

    @Override
    public Collection<Embeddable> getEmbeddables() {
        this.checkMappingCache();
        return this.mappingCache.getEmbeddables();
    }

    @Override
    public Collection<SQLResult> getResults() {
        this.checkMappingCache();
        return this.mappingCache.getResults();
    }

    @Override
    public Collection<Procedure> getProcedures() {
        this.checkMappingCache();
        return this.mappingCache.getProcedures();
    }

    @Override
    public Collection<QueryDescriptor> getQueryDescriptors() {
        this.checkMappingCache();
        return this.mappingCache.getQueryDescriptors();
    }

    @Override
    public DbEntity getDbEntity(String name) {
        this.checkMappingCache();
        DbEntity result = this.mappingCache.getDbEntity(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getDbEntity(name);
        }
        return result;
    }

    @Override
    public ObjEntity getObjEntity(String name) {
        this.checkMappingCache();
        ObjEntity result = this.mappingCache.getObjEntity(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getObjEntity(name);
        }
        return result;
    }

    @Override
    public Procedure getProcedure(String procedureName) {
        this.checkMappingCache();
        Procedure result = this.mappingCache.getProcedure(procedureName);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getProcedure(procedureName);
        }
        return result;
    }

    @Override
    public QueryDescriptor getQueryDescriptor(String name) {
        this.checkMappingCache();
        QueryDescriptor result = this.mappingCache.getQueryDescriptor(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getQueryDescriptor(name);
        }
        return result;
    }

    @Override
    public Embeddable getEmbeddable(String className) {
        this.checkMappingCache();
        Embeddable result = this.mappingCache.getEmbeddable(className);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getEmbeddable(className);
        }
        return result;
    }

    @Override
    public SQLResult getResult(String name) {
        this.checkMappingCache();
        SQLResult result = this.mappingCache.getResult(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getResult(name);
        }
        return result;
    }

    public ClassDescriptor getClassDescriptor(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("Null entityName");
        }
        return this.getClassDescriptorMap().getDescriptor(entityName);
    }

    public synchronized void addDataMap(DataMap map) {
        if (!this.maps.contains(map)) {
            this.checkForDuplicatedNames(map);
            this.maps.add(map);
            map.setNamespace(this);
            this.refreshMappingCache();
        }
    }

    private void checkMappingCache() {
        if (this.mappingCache == null) {
            this.refreshMappingCache();
        }
    }

    private void checkForDuplicatedNames(DataMap map) {
        for (DbEntity dbEntity : map.getDbEntities()) {
            DbEntity foundDbEntity = this.getDbEntity(dbEntity.getName());
            if (foundDbEntity == null) continue;
            this.processWarning(dbEntity.getName(), map.getName(), foundDbEntity.getDataMap().getName());
        }
        for (ObjEntity objEntity : map.getObjEntities()) {
            ObjEntity foundObjEntity = this.getObjEntity(objEntity.getName());
            if (foundObjEntity == null) continue;
            this.processWarning(objEntity.getName(), map.getName(), foundObjEntity.getDataMap().getName());
        }
        for (Procedure procedure : map.getProcedures()) {
            Procedure foundProcedure = this.getProcedure(procedure.getName());
            if (foundProcedure == null) continue;
            this.processWarning(procedure.getName(), map.getName(), foundProcedure.getDataMap().getName());
        }
        for (Embeddable embeddable : map.getEmbeddables()) {
            Embeddable foundEmbeddable = this.getEmbeddable(embeddable.getClassName());
            if (foundEmbeddable == null) continue;
            this.processWarning(embeddable.getClassName(), map.getName(), foundEmbeddable.getDataMap().getName());
        }
    }

    private void processWarning(String duplicatedName, String dataMapName, String originalDataMapName) {
        logger.warn("Duplicated name " + duplicatedName + " was found in " + dataMapName + ". This name was also found in " + originalDataMapName + ".");
    }

    public void refreshMappingCache() {
        this.mappingCache = new ProxiedMappingNamespace(){

            @Override
            protected MappingCache createDelegate() {
                return new MappingCache(EntityResolver.this.maps);
            }
        };
        this.clientEntityResolver = null;
    }

    public DataMap getDataMap(String mapName) {
        if (mapName == null) {
            return null;
        }
        for (DataMap map : this.maps) {
            if (!mapName.equals(map.getName())) continue;
            return map;
        }
        return null;
    }

    public synchronized void setDataMaps(Collection<DataMap> maps) {
        this.maps.clear();
        this.maps.addAll(maps);
        this.refreshMappingCache();
    }

    public Collection<DataMap> getDataMaps() {
        return Collections.unmodifiableCollection(this.maps);
    }

    @Override
    public EntityInheritanceTree getInheritanceTree(String entityName) {
        this.checkMappingCache();
        EntityInheritanceTree tree = this.mappingCache.getInheritanceTree(entityName);
        if (tree == null) {
            this.refreshMappingCache();
            tree = this.mappingCache.getInheritanceTree(entityName);
        }
        return tree;
    }

    @Override
    public ObjEntity getObjEntity(Class<?> entityClass) {
        this.checkMappingCache();
        ObjEntity result = this.mappingCache.getObjEntity(entityClass);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getObjEntity(entityClass);
        }
        return result;
    }

    public ObjEntity getObjEntity(Class<?> entityClass, boolean lookupClientResolver) {
        ObjEntity entity = this.getObjEntity(entityClass);
        if (entity != null || !lookupClientResolver) {
            return entity;
        }
        EntityResolver clientResolver = this.getClientEntityResolver();
        if (clientResolver != this) {
            ObjEntity clientEntity = clientResolver.getObjEntity(entityClass);
            entity = clientEntity == null ? null : this.getObjEntity(clientEntity.getName());
        }
        return entity;
    }

    @Override
    public ObjEntity getObjEntity(Persistent object) {
        this.checkMappingCache();
        return this.mappingCache.getObjEntity(object);
    }

    public synchronized void removeDataMap(DataMap map) {
        if (this.maps.remove(map)) {
            this.refreshMappingCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDescriptorMap getClassDescriptorMap() {
        if (this.classDescriptorMap == null) {
            EntityResolver entityResolver = this;
            synchronized (entityResolver) {
                if (this.classDescriptorMap == null) {
                    ClassDescriptorMap classDescriptorMap = new ClassDescriptorMap(this);
                    SingletonFaultFactory faultFactory = new SingletonFaultFactory();
                    classDescriptorMap.addFactory(new ValueHolderDescriptorFactory(classDescriptorMap));
                    classDescriptorMap.addFactory(new DataObjectDescriptorFactory(classDescriptorMap, faultFactory));
                    for (DataMap map : this.maps) {
                        for (String entityName : map.getObjEntityMap().keySet()) {
                            classDescriptorMap.getDescriptor(entityName);
                        }
                    }
                    this.classDescriptorMap = classDescriptorMap;
                }
            }
        }
        return this.classDescriptorMap;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.refreshMappingCache();
    }

    public ValueObjectTypeRegistry getValueObjectTypeRegistry() {
        return this.valueObjectTypeRegistry;
    }

    public void setValueObjectTypeRegistry(ValueObjectTypeRegistry valueObjectTypeRegistry) {
        this.valueObjectTypeRegistry = valueObjectTypeRegistry;
    }
}

