/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import groovy.lang.Reference;
import java.io.File;
import java.util.Set;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.xml.DataChannelMetaData;
import org.apache.cayenne.dbsync.filter.NameFilter;
import org.apache.cayenne.dbsync.filter.NamePatternMatcher;
import org.apache.cayenne.dbsync.reverse.configuration.ToolsModule;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.gen.ArtifactsGenerationMode;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.CgenModule;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.tools.BaseCayenneTask;
import org.apache.cayenne.tools.CayenneGeneratorEmbeddableFilterAction;
import org.apache.cayenne.tools.CayenneGeneratorEntityFilterAction;
import org.apache.cayenne.tools.CayenneGeneratorMapLoaderAction;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgenTask
extends BaseCayenneTask {
    private static final File[] NO_FILES = new File[0];
    private File additionalMaps;
    @Input
    @Optional
    private Boolean client;
    private File destDir;
    @Input
    @Optional
    private String encoding;
    @Input
    @Optional
    private String excludeEntities;
    @Input
    @Optional
    private String includeEntities;
    @Input
    @Optional
    private String excludeEmbeddables;
    @Input
    @Optional
    private Boolean makePairs;
    @Input
    @Optional
    private String mode;
    @Input
    @Optional
    private String outputPattern;
    @Input
    @Optional
    private Boolean overwrite;
    @Input
    @Optional
    private String superPkg;
    @Input
    @Optional
    private String superTemplate;
    @Input
    @Optional
    private String template;
    @Input
    @Optional
    private String embeddableSuperTemplate;
    @Input
    @Optional
    private String embeddableTemplate;
    @Input
    @Optional
    private Boolean usePkgPath;
    @Input
    @Optional
    private Boolean createPropertyNames;
    @Input
    private boolean force;
    @Input
    @Optional
    private String queryTemplate;
    @Input
    @Optional
    private String querySuperTemplate;
    @Input
    @Optional
    private Boolean createPKProperties;
    private String destDirName;
    private DataChannelMetaData metaData;
    private boolean useConfigFromDataMap;

    @TaskAction
    public void generate() {
        File dataMapFile = this.getDataMapFile();
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{new CgenModule(), new ToolsModule(LoggerFactory.getLogger(CgenTask.class))});
        this.metaData = (DataChannelMetaData)injector.getInstance(DataChannelMetaData.class);
        CayenneGeneratorMapLoaderAction loaderAction = new CayenneGeneratorMapLoaderAction(injector);
        loaderAction.setMainDataMapFile(dataMapFile);
        try {
            loaderAction.setAdditionalDataMapFiles(this.convertAdditionalDataMaps());
            DataMap dataMap = loaderAction.getMainDataMap();
            ClassGenerationAction generator = this.createGenerator(dataMap);
            CayenneGeneratorEntityFilterAction filterEntityAction = new CayenneGeneratorEntityFilterAction();
            filterEntityAction.setNameFilter((NameFilter)NamePatternMatcher.build((Logger)this.getLogger(), (String)this.includeEntities, (String)this.excludeEntities));
            CayenneGeneratorEmbeddableFilterAction filterEmbeddableAction = new CayenneGeneratorEmbeddableFilterAction();
            filterEmbeddableAction.setNameFilter((NameFilter)NamePatternMatcher.build((Logger)this.getLogger(), null, (String)this.excludeEmbeddables));
            filterEntityAction.setClient(generator.getCgenConfiguration().isClient());
            generator.setLogger((Logger)this.getLogger());
            if (this.force || this.getProject().hasProperty("force")) {
                generator.getCgenConfiguration().setForce(true);
            }
            generator.getCgenConfiguration().setTimestamp(dataMapFile.lastModified());
            if (!this.hasConfig() && this.useConfigFromDataMap) {
                generator.prepareArtifacts();
            } else {
                generator.addEntities(filterEntityAction.getFilteredEntities(dataMap));
                generator.addEmbeddables(filterEmbeddableAction.getFilteredEmbeddables(dataMap));
                generator.addQueries(dataMap.getQueryDescriptors());
            }
            generator.execute();
        }
        catch (Exception exception) {
            throw new GradleException("Error generating classes: ", (Throwable)exception);
        }
    }

    private File[] convertAdditionalDataMaps() throws Exception {
        if (this.additionalMaps == null) {
            return NO_FILES;
        }
        if (!this.additionalMaps.isDirectory()) {
            throw new GradleException("'additionalMaps' must be a directory.");
        }
        return this.additionalMaps.listFiles((dir, name) -> name != null && name.toLowerCase().endsWith(".map.xml"));
    }

    ClassGenerationAction createGenerator(DataMap dataMap) {
        CgenConfiguration cgenConfiguration = this.buildConfiguration(dataMap);
        ClientClassGenerationAction classGenerationAction = cgenConfiguration.isClient() ? new ClientClassGenerationAction() : new ClassGenerationAction();
        classGenerationAction.setCgenConfiguration(cgenConfiguration);
        return classGenerationAction;
    }

    CgenConfiguration buildConfiguration(DataMap dataMap) {
        if (this.hasConfig()) {
            this.getLogger().info("Using cgen config from pom.xml");
            return this.cgenConfigFromPom(dataMap);
        }
        if (this.metaData != null && this.metaData.get((ConfigurationNode)dataMap, CgenConfiguration.class) != null) {
            this.getLogger().info("Using cgen config from " + dataMap.getName());
            this.useConfigFromDataMap = true;
            CgenConfiguration cgenConfiguration = (CgenConfiguration)this.metaData.get((ConfigurationNode)dataMap, CgenConfiguration.class);
            return cgenConfiguration;
        }
        this.getLogger().info("Using default cgen config.");
        CgenConfiguration cgenConfiguration = new CgenConfiguration(false);
        cgenConfiguration.setRelPath(this.getDestDirFile().getPath());
        cgenConfiguration.setDataMap(dataMap);
        return cgenConfiguration;
    }

    private CgenConfiguration cgenConfigFromPom(DataMap dataMap) {
        CgenConfiguration cgenConfiguration = new CgenConfiguration(this.client != null ? this.client : false);
        cgenConfiguration.setDataMap(dataMap);
        cgenConfiguration.setRelPath(this.getDestDirFile() != null ? this.getDestDirFile().toPath() : cgenConfiguration.getRelPath());
        cgenConfiguration.setEncoding(this.encoding != null ? this.encoding : cgenConfiguration.getEncoding());
        cgenConfiguration.setMakePairs(this.makePairs != null ? this.makePairs.booleanValue() : cgenConfiguration.isMakePairs());
        if (this.mode != null && this.mode.equals("datamap")) {
            this.replaceDatamapGenerationMode();
        }
        cgenConfiguration.setArtifactsGenerationMode(this.mode != null ? this.mode : cgenConfiguration.getArtifactsGenerationMode());
        cgenConfiguration.setOutputPattern(this.outputPattern != null ? this.outputPattern : cgenConfiguration.getOutputPattern());
        cgenConfiguration.setOverwrite(this.overwrite != null ? this.overwrite.booleanValue() : cgenConfiguration.isOverwrite());
        cgenConfiguration.setSuperPkg(this.superPkg != null ? this.superPkg : cgenConfiguration.getSuperPkg());
        cgenConfiguration.setSuperTemplate(this.superTemplate != null ? this.superTemplate : cgenConfiguration.getSuperTemplate());
        cgenConfiguration.setTemplate(this.template != null ? this.template : cgenConfiguration.getTemplate());
        cgenConfiguration.setEmbeddableSuperTemplate(this.embeddableSuperTemplate != null ? this.embeddableSuperTemplate : cgenConfiguration.getEmbeddableSuperTemplate());
        cgenConfiguration.setEmbeddableTemplate(this.embeddableTemplate != null ? this.embeddableTemplate : cgenConfiguration.getEmbeddableTemplate());
        cgenConfiguration.setUsePkgPath(this.usePkgPath != null ? this.usePkgPath.booleanValue() : cgenConfiguration.isUsePkgPath());
        cgenConfiguration.setCreatePropertyNames(this.createPropertyNames != null ? this.createPropertyNames.booleanValue() : cgenConfiguration.isCreatePropertyNames());
        cgenConfiguration.setQueryTemplate(this.queryTemplate != null ? this.queryTemplate : cgenConfiguration.getQueryTemplate());
        cgenConfiguration.setQuerySuperTemplate(this.querySuperTemplate != null ? this.querySuperTemplate : cgenConfiguration.getQuerySuperTemplate());
        cgenConfiguration.setCreatePKProperties(this.createPKProperties != null ? this.createPKProperties.booleanValue() : cgenConfiguration.isCreatePKProperties());
        if (!cgenConfiguration.isMakePairs()) {
            if (this.template == null) {
                cgenConfiguration.setTemplate(cgenConfiguration.isClient() ? "templates/v4_1/client-singleclass.vm" : "templates/v4_1/singleclass.vm");
            }
            if (this.embeddableTemplate == null) {
                cgenConfiguration.setEmbeddableTemplate("templates/v4_1/embeddable-singleclass.vm");
            }
            if (this.queryTemplate == null) {
                cgenConfiguration.setQueryTemplate(cgenConfiguration.isClient() ? "templates/v4_1/client-datamap-singleclass.vm" : "templates/v4_1/datamap-singleclass.vm");
            }
        }
        return cgenConfiguration;
    }

    private void replaceDatamapGenerationMode() {
        this.mode = ArtifactsGenerationMode.ALL.getLabel();
        this.excludeEntities = "*";
        this.excludeEmbeddables = "*";
        this.includeEntities = "";
    }

    private boolean hasConfig() {
        return this.destDir != null || this.destDirName != null || this.encoding != null || this.client != null || this.excludeEntities != null || this.excludeEmbeddables != null || this.includeEntities != null || this.makePairs != null || this.mode != null || this.outputPattern != null || this.overwrite != null || this.superPkg != null || this.superTemplate != null || this.template != null || this.embeddableTemplate != null || this.embeddableSuperTemplate != null || this.usePkgPath != null || this.createPropertyNames != null || this.force || this.queryTemplate != null || this.querySuperTemplate != null || this.createPKProperties != null;
    }

    @OutputDirectory
    protected File getDestDirFile() {
        final Reference javaSourceDir = new Reference(null);
        if (this.destDir != null) {
            javaSourceDir.set((Object)this.destDir);
        } else if (this.destDirName != null) {
            javaSourceDir.set((Object)this.getProject().file((Object)this.destDirName));
        } else {
            this.getProject().getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

                public void execute(JavaPlugin plugin) {
                    SourceSetContainer sourceSets = (SourceSetContainer)CgenTask.this.getProject().getProperties().get("sourceSets");
                    Set sourceDirs = ((SourceSet)sourceSets.getByName("main")).getJava().getSrcDirs();
                    if (sourceDirs != null && !sourceDirs.isEmpty()) {
                        for (File dir : sourceDirs) {
                            if (!dir.getName().endsWith("java")) continue;
                            javaSourceDir.set((Object)dir);
                            break;
                        }
                        if (javaSourceDir.get() == null) {
                            javaSourceDir.set((Object)((File)sourceDirs.iterator().next()));
                        }
                    }
                }
            });
        }
        if (javaSourceDir.get() == null) {
            throw new InvalidUserDataException("cgen.destDir is not set and there is no Java source sets found.");
        }
        if (!((File)javaSourceDir.get()).exists()) {
            ((File)javaSourceDir.get()).mkdirs();
        }
        return (File)javaSourceDir.get();
    }

    @Override
    @InputFile
    public File getDataMapFile() {
        return super.getDataMapFile();
    }

    @Optional
    @OutputDirectory
    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setDestDir(String destDir) {
        this.destDirName = destDir;
    }

    public void destDir(String destDir) {
        this.setDestDir(destDir);
    }

    public void destDir(File destDir) {
        this.setDestDir(destDir);
    }

    @Optional
    @InputDirectory
    public File getAdditionalMaps() {
        return this.additionalMaps;
    }

    public void setAdditionalMaps(File additionalMaps) {
        this.additionalMaps = additionalMaps;
    }

    public void additionalMaps(File additionalMaps) {
        this.setAdditionalMaps(additionalMaps);
    }

    public Boolean isClient() {
        return this.client;
    }

    public void setClient(Boolean client) {
        this.client = client;
    }

    public void client(boolean client) {
        this.setClient(client);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void encoding(String encoding) {
        this.setEncoding(encoding);
    }

    public String getExcludeEntities() {
        return this.excludeEntities;
    }

    public void setExcludeEntities(String excludeEntities) {
        this.excludeEntities = excludeEntities;
    }

    public void excludeEntities(String excludeEntities) {
        this.setExcludeEntities(excludeEntities);
    }

    public String getIncludeEntities() {
        return this.includeEntities;
    }

    public void setIncludeEntities(String includeEntities) {
        this.includeEntities = includeEntities;
    }

    public void includeEntities(String includeEntities) {
        this.setIncludeEntities(includeEntities);
    }

    public String getExcludeEmbeddables() {
        return this.excludeEmbeddables;
    }

    public void setExcludeEmbeddables(String excludeEmbeddables) {
        this.excludeEmbeddables = excludeEmbeddables;
    }

    public void excludeEmbeddables(String excludeEmbeddables) {
        this.setExcludeEmbeddables(excludeEmbeddables);
    }

    public Boolean isMakePairs() {
        return this.makePairs;
    }

    public void setMakePairs(Boolean makePairs) {
        this.makePairs = makePairs;
    }

    public void makePairs(boolean makePairs) {
        this.setMakePairs(makePairs);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void mode(String mode) {
        this.setMode(mode);
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public void outputPattern(String outputPattern) {
        this.setOutputPattern(outputPattern);
    }

    public Boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void overwrite(boolean overwrite) {
        this.setOverwrite(overwrite);
    }

    public String getSuperPkg() {
        return this.superPkg;
    }

    public void setSuperPkg(String superPkg) {
        this.superPkg = superPkg;
    }

    public void superPkg(String superPkg) {
        this.setSuperPkg(superPkg);
    }

    public String getSuperTemplate() {
        return this.superTemplate;
    }

    public void setSuperTemplate(String superTemplate) {
        this.superTemplate = superTemplate;
    }

    public void superTemplate(String superTemplate) {
        this.setSuperTemplate(superTemplate);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void template(String template) {
        this.setTemplate(template);
    }

    public String getEmbeddableSuperTemplate() {
        return this.embeddableSuperTemplate;
    }

    public void setEmbeddableSuperTemplate(String embeddableSuperTemplate) {
        this.embeddableSuperTemplate = embeddableSuperTemplate;
    }

    public void embeddableSuperTemplate(String embeddableSuperTemplate) {
        this.setEmbeddableSuperTemplate(embeddableSuperTemplate);
    }

    public String getEmbeddableTemplate() {
        return this.embeddableTemplate;
    }

    public void setEmbeddableTemplate(String embeddableTemplate) {
        this.embeddableTemplate = embeddableTemplate;
    }

    public void embeddableTemplate(String embeddableTemplate) {
        this.setEmbeddableTemplate(embeddableTemplate);
    }

    public Boolean isUsePkgPath() {
        return this.usePkgPath;
    }

    public void setUsePkgPath(Boolean usePkgPath) {
        this.usePkgPath = usePkgPath;
    }

    public void usePkgPath(boolean usePkgPath) {
        this.setUsePkgPath(usePkgPath);
    }

    public Boolean isCreatePropertyNames() {
        return this.createPropertyNames;
    }

    public void setCreatePropertyNames(Boolean createPropertyNames) {
        this.createPropertyNames = createPropertyNames;
    }

    public void createPropertyNames(boolean createPropertyNames) {
        this.setCreatePropertyNames(createPropertyNames);
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void force(boolean force) {
        this.setForce(force);
    }

    public void setCreatePKProperties(Boolean createPKProperties) {
        this.createPKProperties = createPKProperties;
    }

    public void createPKProperties(boolean createPKProperties) {
        this.setCreatePKProperties(createPKProperties);
    }
}

