/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.parser.node.AbstractExecutor;
import org.apache.velocity.runtime.parser.node.BooleanPropertyExecutor;
import org.apache.velocity.runtime.parser.node.GetExecutor;
import org.apache.velocity.runtime.parser.node.MapGetExecutor;
import org.apache.velocity.runtime.parser.node.MapSetExecutor;
import org.apache.velocity.runtime.parser.node.PropertyExecutor;
import org.apache.velocity.runtime.parser.node.PutExecutor;
import org.apache.velocity.runtime.parser.node.SetExecutor;
import org.apache.velocity.runtime.parser.node.SetPropertyExecutor;
import org.apache.velocity.util.ArrayIterator;
import org.apache.velocity.util.ArrayListWrapper;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.EnumerationIterator;
import org.apache.velocity.util.RuntimeServicesAware;
import org.apache.velocity.util.introspection.ConversionHandler;
import org.apache.velocity.util.introspection.Converter;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.IntrospectionUtils;
import org.apache.velocity.util.introspection.Introspector;
import org.apache.velocity.util.introspection.Uberspect;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertyGet;
import org.apache.velocity.util.introspection.VelPropertySet;
import org.slf4j.Logger;

public class UberspectImpl
implements Uberspect,
RuntimeServicesAware {
    protected Logger log;
    protected Introspector introspector;
    protected ConversionHandler conversionHandler;
    protected RuntimeServices rsvc;

    @Override
    public void init() {
        this.introspector = new Introspector(this.log, this.conversionHandler);
    }

    public ConversionHandler getConversionHandler() {
        return this.conversionHandler;
    }

    @Override
    public void setRuntimeServices(RuntimeServices runtimeServices) {
        this.rsvc = runtimeServices;
        this.log = this.rsvc.getLog("rendering");
        String string = runtimeServices.getString("runtime.conversion.handler.class");
        if (string == null || string.equals("none")) {
            this.conversionHandler = null;
        } else {
            Object object = null;
            try {
                object = ClassUtils.getNewInstance(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string2 = "The specified class for ConversionHandler (" + string + ") does not exist or is not accessible to the current classloader.";
                this.log.error(string2);
                throw new VelocityException(string2, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new VelocityException("Could not instantiate class '" + string + "'", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new VelocityException("Cannot access class '" + string + "'", illegalAccessException);
            }
            if (!(object instanceof ConversionHandler)) {
                String string3 = "The specified class for ResourceManager (" + string + ") does not implement " + ConversionHandler.class.getName() + "; Velocity is not initialized correctly.";
                this.log.error(string3);
                throw new VelocityException(string3);
            }
            this.conversionHandler = (ConversionHandler)object;
        }
    }

    public void setLog(Logger logger) {
        this.log = logger;
    }

    @Override
    public Iterator getIterator(Object object, Info info) {
        block11: {
            if (object.getClass().isArray()) {
                return new ArrayIterator(object);
            }
            if (object instanceof Iterable) {
                return ((Iterable)object).iterator();
            }
            if (object instanceof Map) {
                return ((Map)object).values().iterator();
            }
            if (object instanceof Iterator) {
                this.log.debug("The iterative object in the #foreach() loop at {} is of type java.util.Iterator.  Because it is not resettable, if used in more than once it may lead to unexpected results.", (Object)info);
                return (Iterator)object;
            }
            if (object instanceof Enumeration) {
                this.log.debug("The iterative object in the #foreach() loop at {} is of type java.util.Enumeration.  Because it is not resettable, if used in more than once it may lead to unexpected results.", (Object)info);
                return new EnumerationIterator((Enumeration)object);
            }
            Class<?> clazz = object.getClass();
            try {
                Method method = clazz.getMethod("iterator", new Class[0]);
                Class<?> clazz2 = method.getReturnType();
                if (Iterator.class.isAssignableFrom(clazz2)) {
                    try {
                        return (Iterator)method.invoke(object, new Object[0]);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        break block11;
                    }
                    catch (Exception exception) {
                        throw new VelocityException("Error invoking the method 'iterator' on class '" + object.getClass().getName() + "'", exception);
                    }
                }
                this.log.debug("iterator() method of reference in #foreach loop at {} does not return a true Iterator.", (Object)info);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.log.debug("Could not determine type of iterator in #foreach loop at {}", (Object)info);
        return null;
    }

    @Override
    public VelMethod getMethod(Object object, String string, Object[] objectArray, Info info) {
        if (object == null) {
            return null;
        }
        Method method = this.introspector.getMethod(object.getClass(), string, objectArray);
        if (method != null) {
            return new VelMethodImpl(method, false, this.getNeededConverters(method.getParameterTypes(), objectArray));
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            method = this.introspector.getMethod(ArrayListWrapper.class, string, objectArray);
            if (method != null) {
                return new VelMethodImpl(method, true, this.getNeededConverters(method.getParameterTypes(), objectArray));
            }
        } else if (clazz == Class.class && (method = this.introspector.getMethod((Class)object, string, objectArray)) != null) {
            return new VelMethodImpl(method, false, this.getNeededConverters(method.getParameterTypes(), objectArray));
        }
        return null;
    }

    private Converter[] getNeededConverters(Class[] classArray, Object[] objectArray) {
        if (this.conversionHandler == null) {
            return null;
        }
        int n = Math.min(classArray.length, objectArray.length);
        Converter[] converterArray = null;
        for (int i = 0; i < n; ++i) {
            Converter converter;
            Object object = objectArray[i];
            if (object == null || (converter = this.conversionHandler.getNeededConverter(classArray[i], object.getClass())) == null) continue;
            if (converterArray == null) {
                converterArray = new Converter[classArray.length];
            }
            converterArray[i] = converter;
        }
        return converterArray;
    }

    @Override
    public VelPropertyGet getPropertyGet(Object object, String string, Info info) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        AbstractExecutor abstractExecutor = new PropertyExecutor(this.log, this.introspector, clazz, string);
        if (!abstractExecutor.isAlive()) {
            abstractExecutor = new MapGetExecutor(this.log, object, string);
        }
        if (!abstractExecutor.isAlive()) {
            abstractExecutor = new GetExecutor(this.log, this.introspector, clazz, string);
        }
        if (!abstractExecutor.isAlive()) {
            abstractExecutor = new BooleanPropertyExecutor(this.log, this.introspector, clazz, string);
        }
        if (!abstractExecutor.isAlive() && object.getClass().isArray()) {
            abstractExecutor = new BooleanPropertyExecutor(this.log, this.introspector, ArrayListWrapper.class, string, true);
        }
        return abstractExecutor.isAlive() ? new VelGetterImpl(abstractExecutor) : null;
    }

    @Override
    public VelPropertySet getPropertySet(Object object, String string, Object object2, Info info) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        SetExecutor setExecutor = new SetPropertyExecutor(this.log, this.introspector, clazz, string, object2);
        if (!setExecutor.isAlive()) {
            setExecutor = new MapSetExecutor(this.log, clazz, string);
        }
        if (!setExecutor.isAlive()) {
            setExecutor = new PutExecutor(this.log, this.introspector, clazz, object2, string);
        }
        return setExecutor.isAlive() ? new VelSetterImpl(setExecutor) : null;
    }

    public static class VelSetterImpl
    implements VelPropertySet {
        private final SetExecutor setExecutor;

        public VelSetterImpl(SetExecutor setExecutor) {
            this.setExecutor = setExecutor;
        }

        private VelSetterImpl() {
            this.setExecutor = null;
        }

        @Override
        public Object invoke(Object object, Object object2) throws IllegalAccessException, InvocationTargetException {
            return this.setExecutor.execute(object, object2);
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public String getMethodName() {
            return this.setExecutor.isAlive() ? this.setExecutor.getMethod().getName() : null;
        }
    }

    public static class VelGetterImpl
    implements VelPropertyGet {
        final AbstractExecutor getExecutor;

        public VelGetterImpl(AbstractExecutor abstractExecutor) {
            this.getExecutor = abstractExecutor;
        }

        private VelGetterImpl() {
            this.getExecutor = null;
        }

        @Override
        public Object invoke(Object object) throws IllegalAccessException, InvocationTargetException {
            return this.getExecutor.execute(object);
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public String getMethodName() {
            return this.getExecutor.isAlive() ? this.getExecutor.getMethod().getName() : null;
        }
    }

    public class VelMethodImpl
    implements VelMethod {
        final Method method;
        Boolean isVarArg;
        boolean wrapArray;
        Converter[] converters;

        public VelMethodImpl(Method method) {
            this(method, false, null);
        }

        public VelMethodImpl(Method method, boolean bl) {
            this(method, bl, null);
        }

        public VelMethodImpl(Method method, boolean bl, Converter[] converterArray) {
            this.method = method;
            this.wrapArray = bl;
            this.converters = converterArray;
        }

        private VelMethodImpl() {
            this.method = null;
        }

        @Override
        public Object invoke(Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
            Class<?>[] classArray;
            int n;
            if (this.wrapArray) {
                object = new ArrayListWrapper(object);
            }
            if (this.isVarArg() && objectArray.length >= (n = (classArray = this.method.getParameterTypes()).length - 1)) {
                Class<?> clazz = classArray[n].getComponentType();
                objectArray = this.handleVarArg(clazz, n, objectArray);
            }
            if (this.converters != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.converters[i] == null) continue;
                    objectArray[i] = this.converters[i].convert(objectArray[i]);
                }
            }
            return this.doInvoke(object, objectArray);
        }

        protected Object doInvoke(Object object, Object[] objectArray) throws IllegalAccessException, InvocationTargetException {
            return this.method.invoke(object, objectArray);
        }

        public boolean isVarArg() {
            if (this.isVarArg == null) {
                Class<?>[] classArray = this.method.getParameterTypes();
                if (classArray == null || classArray.length == 0) {
                    this.isVarArg = Boolean.FALSE;
                } else {
                    Class<?> clazz = classArray[classArray.length - 1];
                    this.isVarArg = clazz.isArray();
                }
            }
            return this.isVarArg;
        }

        private Object[] handleVarArg(Class clazz, int n, Object[] objectArray) {
            if (objectArray.length == n) {
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[n] = Array.newInstance(clazz, 0);
                objectArray = objectArray2;
            } else if (objectArray.length == n + 1 && objectArray[n] != null) {
                Class<?> clazz2 = objectArray[n].getClass();
                if (!clazz2.isArray() && IntrospectionUtils.isMethodInvocationConvertible(clazz, clazz2, false)) {
                    Object object = Array.newInstance(clazz, 1);
                    Array.set(object, 0, objectArray[n]);
                    objectArray[n] = object;
                }
            } else if (objectArray.length > n + 1) {
                int n2 = objectArray.length - n;
                Object object = Array.newInstance(clazz, n2);
                for (int i = 0; i < n2; ++i) {
                    Array.set(object, i, objectArray[n + i]);
                }
                Object[] objectArray3 = new Object[n + 1];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                objectArray3[n] = object;
                objectArray = objectArray3;
            }
            return objectArray;
        }

        @Override
        public boolean isCacheable() {
            return true;
        }

        @Override
        public String getMethodName() {
            return this.method.getName();
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Class getReturnType() {
            return this.method.getReturnType();
        }
    }
}

