/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.velocity.util.introspection.ClassFieldMap;
import org.apache.velocity.util.introspection.ClassMap;
import org.apache.velocity.util.introspection.ConversionHandler;
import org.slf4j.Logger;

public final class IntrospectorCache {
    public static final String CACHEDUMP_MSG = "IntrospectorCache detected classloader change. Dumping cache.";
    private final Logger log;
    private final Map classMapCache = new HashMap();
    private final Map classFieldMapCache = new HashMap();
    private final Set classNameCache = new HashSet();
    private final ConversionHandler conversionHandler;

    public IntrospectorCache(Logger logger, ConversionHandler conversionHandler) {
        this.log = logger;
        this.conversionHandler = conversionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.classMapCache;
        synchronized (map) {
            this.classMapCache.clear();
            this.classFieldMapCache.clear();
            this.classNameCache.clear();
            this.log.debug(CACHEDUMP_MSG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMap get(Class clazz) {
        ClassMap classMap = (ClassMap)this.classMapCache.get(Validate.notNull(clazz));
        if (classMap == null) {
            Map map = this.classMapCache;
            synchronized (map) {
                if (this.classNameCache.contains(clazz.getName())) {
                    this.clear();
                }
            }
        }
        return classMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFieldMap getFieldMap(Class clazz) {
        ClassFieldMap classFieldMap = (ClassFieldMap)this.classFieldMapCache.get(Validate.notNull(clazz));
        if (classFieldMap == null) {
            Map map = this.classMapCache;
            synchronized (map) {
                if (this.classNameCache.contains(clazz.getName())) {
                    this.clear();
                }
            }
        }
        return classFieldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMap put(Class clazz) {
        ClassMap classMap = new ClassMap(clazz, this.log, this.conversionHandler);
        ClassFieldMap classFieldMap = new ClassFieldMap(clazz, this.log);
        Map map = this.classMapCache;
        synchronized (map) {
            this.classMapCache.put(clazz, classMap);
            this.classFieldMapCache.put(clazz, classFieldMap);
            this.classNameCache.add(clazz.getName());
        }
        return classMap;
    }
}

