/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.awt.Component;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import org.apache.cayenne.configuration.event.DataMapEvent;
import org.apache.cayenne.configuration.event.DataMapListener;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.event.EmbeddableEvent;
import org.apache.cayenne.map.event.EmbeddableListener;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.map.event.ObjEntityListener;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.ErrorDebugDialog;
import org.apache.cayenne.modeler.editor.DbImportController;
import org.apache.cayenne.modeler.editor.cgen.ClassesTabController;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorControllerBase;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorPane;
import org.apache.cayenne.modeler.editor.cgen.GeneratorController;
import org.apache.cayenne.modeler.editor.cgen.GeneratorTabController;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGeneratorController
extends CodeGeneratorControllerBase
implements ObjEntityListener,
EmbeddableListener,
DataMapListener {
    private static Logger logObj = LoggerFactory.getLogger(ErrorDebugDialog.class);
    protected CodeGeneratorPane view;
    protected ClassesTabController classesSelector = new ClassesTabController(this);
    protected GeneratorTabController generatorSelector = new GeneratorTabController(this);
    private ConcurrentMap<DataMap, GeneratorController> prevGeneratorController;

    public CodeGeneratorController(CayenneController parent, ProjectController projectController) {
        super(parent, projectController);
        this.view = new CodeGeneratorPane(this.generatorSelector.getView(), this.classesSelector.getView());
        this.prevGeneratorController = new ConcurrentHashMap<DataMap, GeneratorController>();
        this.initBindings();
        this.initListeners();
    }

    @Override
    public void startup(DataMap dataMap) {
        super.startup(dataMap);
        this.classesSelectedAction();
        CgenConfiguration cgenConfiguration = this.createConfiguration();
        GeneratorController modeController = this.prevGeneratorController.get(dataMap) != null ? (GeneratorController)this.prevGeneratorController.get(dataMap) : (this.isDefaultConfig(cgenConfiguration) ? (cgenConfiguration.isClient() ? this.generatorSelector.getClientGeneratorController() : this.generatorSelector.getStandartController()) : this.generatorSelector.getCustomModeController());
        this.prevGeneratorController.put(dataMap, modeController);
        this.generatorSelector.setSelectedController(modeController);
        this.classesSelector.startup();
        this.initFromModel = false;
        this.validate(modeController);
    }

    private boolean isDefaultConfig(CgenConfiguration cgenConfiguration) {
        return !(!cgenConfiguration.isMakePairs() || !cgenConfiguration.isUsePkgPath() || cgenConfiguration.isOverwrite() || cgenConfiguration.isCreatePKProperties() || cgenConfiguration.isCreatePropertyNames() || !cgenConfiguration.getOutputPattern().equals("*.java") || !cgenConfiguration.getTemplate().equals("templates/v4_1/subclass.vm") && !cgenConfiguration.getTemplate().equals("templates/v4_1/client-subclass.vm") || !cgenConfiguration.getSuperTemplate().equals("templates/v4_1/superclass.vm") && !cgenConfiguration.getSuperTemplate().equals("templates/v4_1/client-superclass.vm") || cgenConfiguration.getSuperPkg() != null && !cgenConfiguration.getSuperPkg().isEmpty());
    }

    private void initListeners() {
        this.projectController.addObjEntityListener(this);
        this.projectController.addEmbeddableListener(this);
        this.projectController.addDataMapListener(this);
    }

    @Override
    public Component getView() {
        return this.view;
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        builder.bindToAction(this.view.getGenerateButton(), "generateAction()");
        builder.bindToAction(this, "classesSelectedAction()", "selected");
        builder.bindToAction(this.generatorSelector, "generatorSelectedAction()", "generator");
        this.generatorSelectedAction();
    }

    public void generatorSelectedAction() {
        GeneratorController controller = this.generatorSelector.getGeneratorController();
        this.validate(controller);
        Predicate<Object> predicate = controller != null ? controller.getDefaultClassFilter() : o -> false;
        this.updateSelection(predicate);
        this.classesSelector.classSelectedAction();
    }

    public void classesSelectedAction() {
        if (!this.isInitFromModel()) {
            this.getProjectController().setDirty(true);
        }
    }

    public void generateAction() {
        CgenConfiguration cgenConfiguration = this.createConfiguration();
        ClassGenerationAction generator = cgenConfiguration.isClient() ? new ClientClassGenerationAction() : new ClassGenerationAction();
        generator.setCgenConfiguration(cgenConfiguration);
        try {
            generator.prepareArtifacts();
            generator.execute();
            JOptionPane.showMessageDialog(this.getView(), "Class generation finished");
        }
        catch (Exception e) {
            logObj.error("Error generating classes", e);
            JOptionPane.showMessageDialog(this.getView(), "Error generating classes - " + e.getMessage());
        }
    }

    public ConcurrentMap<DataMap, GeneratorController> getPrevGeneratorController() {
        return this.prevGeneratorController;
    }

    @Override
    public void enableGenerateButton(boolean enable) {
        this.view.getGenerateButton().setEnabled(enable);
    }

    @Override
    public void objEntityChanged(EntityEvent e) {
    }

    @Override
    public void objEntityAdded(EntityEvent e) {
        super.addEntity(e.getEntity().getDataMap(), (ObjEntity)e.getEntity());
    }

    @Override
    public void objEntityRemoved(EntityEvent e) {
        super.removeFromSelectedEntities((ObjEntity)e.getEntity());
        DataMap map = e.getEntity().getDataMap();
        CgenConfiguration cgenConfiguration = this.projectController.getApplication().getMetaData().get(map, CgenConfiguration.class);
        if (cgenConfiguration != null) {
            cgenConfiguration.getEntities().remove(e.getEntity().getName());
        }
    }

    @Override
    public void embeddableChanged(EmbeddableEvent e, DataMap map) {
    }

    @Override
    public void embeddableAdded(EmbeddableEvent e, DataMap map) {
        super.addEmbeddable(e.getEmbeddable().getDataMap(), e.getEmbeddable());
    }

    @Override
    public void embeddableRemoved(EmbeddableEvent e, DataMap map) {
        super.removeFromSelectedEmbeddables(e.getEmbeddable());
        CgenConfiguration cgenConfiguration = this.projectController.getApplication().getMetaData().get(map, CgenConfiguration.class);
        if (cgenConfiguration != null) {
            cgenConfiguration.getEmbeddables().remove(e.getEmbeddable().getClassName());
        }
    }

    @Override
    public void dataMapChanged(DataMapEvent e) {
        CgenConfiguration cgenConfiguration;
        if (e.getSource() instanceof DbImportController && (cgenConfiguration = this.getCurrentConfiguration()) != null) {
            for (ObjEntity objEntity : e.getDataMap().getObjEntities()) {
                if (cgenConfiguration.getExcludeEntityArtifacts().contains(objEntity.getName())) continue;
                this.addEntity(cgenConfiguration.getDataMap(), objEntity);
            }
        }
    }

    @Override
    public void dataMapAdded(DataMapEvent e) {
    }

    @Override
    public void dataMapRemoved(DataMapEvent e) {
    }
}

