/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.model;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.tools.model.PatternParam;

public class IncludeTable
extends PatternParam {
    private Collection<PatternParam> includeColumns = new LinkedList<PatternParam>();
    private Collection<PatternParam> excludeColumns = new LinkedList<PatternParam>();

    IncludeTable() {
    }

    IncludeTable(String pattern) {
        super(pattern);
    }

    public void setName(String name) {
        this.setPattern(name);
    }

    public void name(String name) {
        this.setPattern(name);
    }

    public void includeColumn(String pattern) {
        this.includeColumns.add(new PatternParam(pattern));
    }

    public void includeColumns(String ... patterns) {
        for (String pattern : patterns) {
            this.includeColumn(pattern);
        }
    }

    public void excludeColumn(String pattern) {
        this.excludeColumns.add(new PatternParam(pattern));
    }

    public void excludeColumns(String ... patterns) {
        for (String pattern : patterns) {
            this.excludeColumn(pattern);
        }
    }

    org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable toIncludeTable() {
        org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable table = new org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable();
        table.setPattern(this.getPattern());
        for (PatternParam includeColumn : this.includeColumns) {
            table.addIncludeColumn(includeColumn.toIncludeColumn());
        }
        for (PatternParam excludeColumn : this.excludeColumns) {
            table.addExcludeColumn(excludeColumn.toExcludeColumn());
        }
        return table;
    }
}

