/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.model;

import groovy.lang.Closure;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.tools.model.FilterContainer;
import org.apache.cayenne.tools.model.SchemaContainer;
import org.gradle.util.ConfigureUtil;

public class DbImportConfig
extends SchemaContainer {
    private boolean skipRelationshipsLoading;
    private boolean skipPrimaryKeyLoading;
    private String defaultPackage;
    private boolean forceDataMapCatalog;
    private boolean forceDataMapSchema;
    private String meaningfulPkTables;
    private String namingStrategy = "org.apache.cayenne.dbsync.naming.DefaultObjectNameGenerator";
    private String stripFromTableNames = "";
    private boolean usePrimitives = true;
    private boolean useJava7Types = false;
    private Collection<String> tableTypes = new LinkedList<String>();
    private Collection<SchemaContainer> catalogs = new LinkedList<SchemaContainer>();

    public void catalog(String name) {
        this.catalogs.add(new SchemaContainer(name));
    }

    public void catalog(Closure<?> closure) {
        this.catalogs.add((SchemaContainer)ConfigureUtil.configure(closure, (Object)new SchemaContainer()));
    }

    public void catalog(String name, Closure<?> closure) {
        this.catalogs.add((SchemaContainer)ConfigureUtil.configure(closure, (Object)new SchemaContainer(name)));
    }

    public ReverseEngineering toReverseEngineering() {
        ReverseEngineering reverseEngineering = new ReverseEngineering();
        reverseEngineering.setSkipRelationshipsLoading(Boolean.valueOf(this.skipRelationshipsLoading));
        reverseEngineering.setSkipPrimaryKeyLoading(Boolean.valueOf(this.skipPrimaryKeyLoading));
        reverseEngineering.setForceDataMapCatalog(this.forceDataMapCatalog);
        reverseEngineering.setForceDataMapSchema(this.forceDataMapSchema);
        reverseEngineering.setDefaultPackage(this.defaultPackage);
        reverseEngineering.setMeaningfulPkTables(this.meaningfulPkTables);
        reverseEngineering.setNamingStrategy(this.namingStrategy);
        reverseEngineering.setStripFromTableNames(this.stripFromTableNames);
        reverseEngineering.setUsePrimitives(this.usePrimitives);
        reverseEngineering.setUseJava7Types(this.useJava7Types);
        reverseEngineering.setTableTypes(this.tableTypes);
        for (SchemaContainer catalog : this.catalogs) {
            reverseEngineering.addCatalog(catalog.toCatalog());
        }
        for (FilterContainer schema : this.schemas) {
            reverseEngineering.addSchema(schema.fillContainer(new Schema()));
        }
        this.fillContainer(reverseEngineering);
        return reverseEngineering;
    }

    public boolean isSkipRelationshipsLoading() {
        return this.skipRelationshipsLoading;
    }

    public void setSkipRelationshipsLoading(boolean skipRelationshipsLoading) {
        this.skipRelationshipsLoading = skipRelationshipsLoading;
    }

    public void skipRelationshipsLoading(boolean skipRelationshipsLoading) {
        this.setSkipRelationshipsLoading(skipRelationshipsLoading);
    }

    public boolean isSkipPrimaryKeyLoading() {
        return this.skipPrimaryKeyLoading;
    }

    public void setSkipPrimaryKeyLoading(boolean skipPrimaryKeyLoading) {
        this.skipPrimaryKeyLoading = skipPrimaryKeyLoading;
    }

    public void skipPrimaryKeyLoading(boolean skipPrimaryKeyLoading) {
        this.setSkipPrimaryKeyLoading(skipPrimaryKeyLoading);
    }

    public String getDefaultPackage() {
        return this.defaultPackage;
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public void defaultPackage(String defaultPackage) {
        this.setDefaultPackage(defaultPackage);
    }

    public boolean isForceDataMapCatalog() {
        return this.forceDataMapCatalog;
    }

    public void setForceDataMapCatalog(boolean forceDataMapCatalog) {
        this.forceDataMapCatalog = forceDataMapCatalog;
    }

    public void forceDataMapCatalog(boolean forceDataMapCatalog) {
        this.setForceDataMapCatalog(forceDataMapCatalog);
    }

    public boolean isForceDataMapSchema() {
        return this.forceDataMapSchema;
    }

    public void setForceDataMapSchema(boolean forceDataMapSchema) {
        this.forceDataMapSchema = forceDataMapSchema;
    }

    public void forceDataMapSchema(boolean forceDataMapSchema) {
        this.setForceDataMapSchema(forceDataMapSchema);
    }

    public String getMeaningfulPkTables() {
        return this.meaningfulPkTables;
    }

    public void setMeaningfulPkTables(String meaningfulPkTables) {
        this.meaningfulPkTables = meaningfulPkTables;
    }

    public void meaningfulPkTables(String meaningfulPkTables) {
        this.setMeaningfulPkTables(meaningfulPkTables);
    }

    public String getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public void namingStrategy(String namingStrategy) {
        this.setNamingStrategy(namingStrategy);
    }

    public String getStripFromTableNames() {
        return this.stripFromTableNames;
    }

    public void setStripFromTableNames(String stripFromTableNames) {
        this.stripFromTableNames = stripFromTableNames;
    }

    public void stripFromTableNames(String stripFromTableNames) {
        this.setStripFromTableNames(stripFromTableNames);
    }

    public boolean isUsePrimitives() {
        return this.usePrimitives;
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.usePrimitives = usePrimitives;
    }

    public void usePrimitives(boolean usePrimitives) {
        this.setUsePrimitives(usePrimitives);
    }

    public boolean isUseJava7Types() {
        return this.useJava7Types;
    }

    public void setUseJava7Types(boolean useJava7Types) {
        this.useJava7Types = useJava7Types;
    }

    public void useJava7Types(boolean useJava7Types) {
        this.setUseJava7Types(useJava7Types);
    }

    public Collection<String> getTableTypes() {
        return this.tableTypes;
    }

    public void setTableTypes(Collection<String> tableTypes) {
        this.tableTypes = tableTypes;
    }

    public void tableType(String tableType) {
        this.tableTypes.add(tableType);
    }

    public void tableTypes(String ... tableTypes) {
        this.tableTypes.addAll(Arrays.asList(tableTypes));
    }
}

