/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import groovy.lang.Closure;
import java.io.File;
import org.apache.cayenne.dbsync.DbSyncModule;
import org.apache.cayenne.dbsync.reverse.configuration.ToolsModule;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportAction;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfiguration;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfigurationValidator;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportModule;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfigBuilder;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.tools.BaseCayenneTask;
import org.apache.cayenne.tools.model.DataSourceConfig;
import org.apache.cayenne.tools.model.DbImportConfig;
import org.apache.cayenne.util.Util;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.slf4j.Logger;

public class DbImportTask
extends BaseCayenneTask {
    @Input
    @Optional
    private String adapter;
    @Internal
    private DataSourceConfig dataSource = new DataSourceConfig();
    @Internal
    private DbImportConfig config = new DbImportConfig();
    @Internal
    private ReverseEngineering reverseEngineering;

    public DbImportTask() {
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
    }

    @TaskAction
    public void runImport() {
        this.dataSource.validate();
        DbImportConfiguration config = this.createConfig();
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{new DbSyncModule(), new ToolsModule((Logger)this.getLogger()), new DbImportModule()});
        DbImportConfigurationValidator validator = new DbImportConfigurationValidator(this.reverseEngineering, config, injector);
        try {
            validator.validate();
        }
        catch (Exception ex) {
            throw new TaskExecutionException((Task)this, (Throwable)ex);
        }
        try {
            ((DbImportAction)injector.getInstance(DbImportAction.class)).execute(config);
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException((Throwable)ex);
            String message = "Error importing database schema";
            if (th.getLocalizedMessage() != null) {
                message = message + ": " + th.getLocalizedMessage();
            }
            this.getLogger().error(message);
            throw new TaskExecutionException((Task)this, th);
        }
    }

    DbImportConfiguration createConfig() {
        this.reverseEngineering = this.config.toReverseEngineering();
        DbImportConfiguration config = new DbImportConfiguration();
        config.setAdapter(this.adapter);
        config.setDefaultPackage(this.reverseEngineering.getDefaultPackage());
        config.setDriver(this.dataSource.getDriver());
        config.setFiltersConfig(new FiltersConfigBuilder(this.reverseEngineering).build());
        config.setForceDataMapCatalog(this.reverseEngineering.isForceDataMapCatalog());
        config.setForceDataMapSchema(this.reverseEngineering.isForceDataMapSchema());
        config.setLogger((Logger)this.getLogger());
        config.setMeaningfulPkTables(this.reverseEngineering.getMeaningfulPkTables());
        config.setNamingStrategy(this.reverseEngineering.getNamingStrategy());
        config.setPassword(this.dataSource.getPassword());
        config.setSkipRelationshipsLoading(this.reverseEngineering.getSkipRelationshipsLoading());
        config.setSkipPrimaryKeyLoading(this.reverseEngineering.getSkipPrimaryKeyLoading());
        config.setStripFromTableNames(this.reverseEngineering.getStripFromTableNames());
        config.setTableTypes(this.reverseEngineering.getTableTypes());
        config.setTargetDataMap(this.getDataMapFile());
        config.setUrl(this.dataSource.getUrl());
        config.setUsername(this.dataSource.getUsername());
        config.setUsePrimitives(this.reverseEngineering.isUsePrimitives());
        config.setUseJava7Types(this.reverseEngineering.isUseJava7Types());
        return config;
    }

    @Override
    @OutputFile
    public File getDataMapFile() {
        return super.getDataMapFile();
    }

    public void dbImport(Closure<?> closure) {
        this.getProject().configure((Object)this.config, closure);
    }

    public void dbimport(Closure<?> closure) {
        this.dbImport(closure);
    }

    public void dataSource(Closure<?> closure) {
        this.getProject().configure((Object)this.dataSource, closure);
    }

    public DataSourceConfig getDataSource() {
        return this.dataSource;
    }

    public DbImportConfig getConfig() {
        return this.config;
    }

    public String getAdapter() {
        return this.adapter;
    }

    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    public void adapter(String adapter) {
        this.setAdapter(adapter);
    }
}

