/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import groovy.lang.Closure;
import java.io.File;
import javax.sql.DataSource;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.datasource.DataSourceBuilder;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dbsync.DbSyncModule;
import org.apache.cayenne.dbsync.reverse.configuration.ToolsModule;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.log.NoopJdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.tools.BaseCayenneTask;
import org.apache.cayenne.tools.model.DataSourceConfig;
import org.apache.cayenne.util.Util;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.xml.sax.InputSource;

public class DbGenerateTask
extends BaseCayenneTask {
    @Input
    @Optional
    private String adapter;
    @Internal
    private DataSourceConfig dataSource = new DataSourceConfig();
    @Input
    @Optional
    private boolean dropTables;
    @Input
    @Optional
    private boolean dropPK;
    @Input
    @Optional
    private boolean createTables = true;
    @Input
    @Optional
    private boolean createPK = true;
    @Input
    @Optional
    private boolean createFK = true;

    @Override
    @InputFile
    public File getDataMapFile() {
        return super.getDataMapFile();
    }

    @TaskAction
    public void generateDb() throws GradleException {
        this.dataSource.validate();
        this.getLogger().info("connection settings - [driver: {}, url: {}, username: {}]", new Object[]{this.dataSource.getDriver(), this.dataSource.getUrl(), this.dataSource.getUsername()});
        this.getLogger().info("generator options - [dropTables: {}, dropPK: {}, createTables: {}, createPK: {}, createFK: {}]", new Object[]{this.dropTables, this.dropPK, this.createTables, this.createPK, this.createFK});
        try {
            DbGenerator generator = this.createGenerator(this.loadDataMap());
            generator.runGenerator(this.createDataSource());
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException((Throwable)ex);
            String message = "Error generating database";
            if (th.getLocalizedMessage() != null) {
                message = message + ": " + th.getLocalizedMessage();
            }
            this.getLogger().error(message);
            throw new GradleException(message, th);
        }
    }

    DbGenerator createGenerator(DataMap dataMap) {
        DbGenerator generator = new DbGenerator(this.createDbAdapter(), dataMap, (JdbcEventLogger)NoopJdbcEventLogger.getInstance());
        generator.setShouldCreateFKConstraints(this.createFK);
        generator.setShouldCreatePKSupport(this.createPK);
        generator.setShouldCreateTables(this.createTables);
        generator.setShouldDropPKSupport(this.dropPK);
        generator.setShouldDropTables(this.dropTables);
        return generator;
    }

    DbAdapter createDbAdapter() {
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{new DbSyncModule(), new ToolsModule((Logger)this.getLogger())});
        AdhocObjectFactory objectFactory = (AdhocObjectFactory)injector.getInstance(AdhocObjectFactory.class);
        return this.adapter == null ? (DbAdapter)objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName()) : (DbAdapter)objectFactory.newInstance(DbAdapter.class, this.adapter);
    }

    DataSource createDataSource() {
        return DataSourceBuilder.url((String)this.dataSource.getUrl()).driver(this.dataSource.getDriver()).userName(this.dataSource.getUsername()).password(this.dataSource.getPassword()).build();
    }

    DataMap loadDataMap() throws Exception {
        File dataMapFile = this.getDataMapFile();
        InputSource inputSource = new InputSource(dataMapFile.getCanonicalPath());
        return new MapLoader().loadDataMap(inputSource);
    }

    public String getAdapter() {
        return this.adapter;
    }

    public void setAdapter(String adapter) {
        this.adapter = adapter;
    }

    public void adapter(String adapter) {
        this.setAdapter(adapter);
    }

    public DataSourceConfig getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSourceConfig dataSource) {
        this.dataSource = dataSource;
    }

    public DataSourceConfig dataSource(Closure closure) {
        this.dataSource = new DataSourceConfig();
        this.getProject().configure((Object)this.dataSource, closure);
        return this.dataSource;
    }

    public boolean isDropTables() {
        return this.dropTables;
    }

    public void setDropTables(boolean dropTables) {
        this.dropTables = dropTables;
    }

    public void dropTables(boolean dropTables) {
        this.setDropTables(dropTables);
    }

    public boolean isDropPK() {
        return this.dropPK;
    }

    public void setDropPK(boolean dropPK) {
        this.dropPK = dropPK;
    }

    public void dropPK(boolean dropPK) {
        this.setDropPK(dropPK);
    }

    public boolean isCreateTables() {
        return this.createTables;
    }

    public void setCreateTables(boolean createTables) {
        this.createTables = createTables;
    }

    public void createTables(boolean createTables) {
        this.setCreateTables(createTables);
    }

    public boolean isCreatePK() {
        return this.createPK;
    }

    public void setCreatePK(boolean createPK) {
        this.createPK = createPK;
    }

    public void createPK(boolean createPK) {
        this.setCreatePK(createPK);
    }

    public boolean isCreateFK() {
        return this.createFK;
    }

    public void setCreateFK(boolean createFK) {
        this.createFK = createFK;
    }

    public void createFK(boolean createFK) {
        this.setCreateFK(createFK);
    }
}

