/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import groovy.lang.Reference;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;
import org.apache.cayenne.dbsync.filter.NameFilter;
import org.apache.cayenne.dbsync.filter.NamePatternMatcher;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientClassGenerationAction;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.tools.BaseCayenneTask;
import org.apache.cayenne.tools.CayenneGeneratorEntityFilterAction;
import org.apache.cayenne.tools.CayenneGeneratorMapLoaderAction;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;

public class CgenTask
extends BaseCayenneTask {
    private static final File[] NO_FILES = new File[0];
    private File additionalMaps;
    @Input
    private boolean client;
    private File destDir;
    @Input
    @Optional
    private String encoding;
    @Input
    @Optional
    private String excludeEntities;
    @Input
    @Optional
    private String includeEntities;
    @Input
    private boolean makePairs = true;
    @Input
    private String mode = "entity";
    @Input
    private String outputPattern = "*.java";
    @Input
    private boolean overwrite;
    @Input
    @Optional
    private String superPkg;
    @Input
    @Optional
    private String superTemplate;
    @Input
    @Optional
    private String template;
    @Input
    @Optional
    private String embeddableSuperTemplate;
    @Input
    @Optional
    private String embeddableTemplate;
    @Input
    private boolean usePkgPath = true;
    @Input
    private boolean createPropertyNames;
    private String destDirName;

    @TaskAction
    public void generate() {
        File dataMapFile = this.getDataMapFile();
        CayenneGeneratorMapLoaderAction loaderAction = new CayenneGeneratorMapLoaderAction();
        loaderAction.setMainDataMapFile(dataMapFile);
        CayenneGeneratorEntityFilterAction filterAction = new CayenneGeneratorEntityFilterAction();
        filterAction.setClient(this.client);
        filterAction.setNameFilter((NameFilter)NamePatternMatcher.build((Logger)this.getLogger(), (String)this.includeEntities, (String)this.excludeEntities));
        try {
            loaderAction.setAdditionalDataMapFiles(this.convertAdditionalDataMaps());
            ClassGenerationAction generator = this.createGenerator();
            DataMap dataMap = loaderAction.getMainDataMap();
            generator.setLogger((Logger)this.getLogger());
            generator.setTimestamp(dataMapFile.lastModified());
            generator.setDataMap(dataMap);
            generator.addEntities(filterAction.getFilteredEntities(dataMap));
            generator.addEmbeddables(dataMap.getEmbeddables());
            generator.addQueries(dataMap.getQueryDescriptors());
            generator.execute();
        }
        catch (Exception exception) {
            throw new GradleException("Error generating classes: ", (Throwable)exception);
        }
    }

    private File[] convertAdditionalDataMaps() throws Exception {
        if (this.additionalMaps == null) {
            return NO_FILES;
        }
        if (!this.additionalMaps.isDirectory()) {
            throw new GradleException("'additionalMaps' must be a directory.");
        }
        FilenameFilter mapFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.toLowerCase().endsWith(".map.xml");
            }
        };
        return this.additionalMaps.listFiles(mapFilter);
    }

    ClassGenerationAction newGeneratorInstance() {
        return this.client ? new ClientClassGenerationAction() : new ClassGenerationAction();
    }

    ClassGenerationAction createGenerator() {
        ClassGenerationAction action = this.newGeneratorInstance();
        action.setDestDir(this.getDestDirFile());
        action.setEncoding(this.encoding);
        action.setMakePairs(this.makePairs);
        action.setArtifactsGenerationMode(this.mode);
        action.setOutputPattern(this.outputPattern);
        action.setOverwrite(this.overwrite);
        action.setSuperPkg(this.superPkg);
        action.setSuperTemplate(this.superTemplate);
        action.setTemplate(this.template);
        action.setEmbeddableSuperTemplate(this.embeddableSuperTemplate);
        action.setEmbeddableTemplate(this.embeddableTemplate);
        action.setUsePkgPath(this.usePkgPath);
        action.setCreatePropertyNames(this.createPropertyNames);
        return action;
    }

    @OutputDirectory
    protected File getDestDirFile() {
        final Reference javaSourceDir = new Reference(null);
        if (this.destDir != null) {
            javaSourceDir.set((Object)this.destDir);
        } else if (this.destDirName != null) {
            javaSourceDir.set((Object)this.getProject().file((Object)this.destDirName));
        } else {
            this.getProject().getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

                public void execute(JavaPlugin plugin) {
                    SourceSetContainer sourceSets = (SourceSetContainer)CgenTask.this.getProject().getProperties().get("sourceSets");
                    Set sourceDirs = ((SourceSet)sourceSets.getByName("main")).getJava().getSrcDirs();
                    if (sourceDirs != null && !sourceDirs.isEmpty()) {
                        for (File dir : sourceDirs) {
                            if (!dir.getName().endsWith("java")) continue;
                            javaSourceDir.set((Object)dir);
                            break;
                        }
                        if (javaSourceDir.get() == null) {
                            javaSourceDir.set(sourceDirs.iterator().next());
                        }
                    }
                }
            });
        }
        if (javaSourceDir.get() == null) {
            throw new InvalidUserDataException("cgen.destDir is not set and there is no Java source sets found.");
        }
        if (!((File)javaSourceDir.get()).exists()) {
            ((File)javaSourceDir.get()).mkdirs();
        }
        return (File)javaSourceDir.get();
    }

    @Override
    @InputFile
    public File getDataMapFile() {
        return super.getDataMapFile();
    }

    @Optional
    @OutputDirectory
    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setDestDir(String destDir) {
        this.destDirName = destDir;
    }

    public void destDir(String destDir) {
        this.setDestDir(destDir);
    }

    public void destDir(File destDir) {
        this.setDestDir(destDir);
    }

    @Optional
    @InputDirectory
    public File getAdditionalMaps() {
        return this.additionalMaps;
    }

    public void setAdditionalMaps(File additionalMaps) {
        this.additionalMaps = additionalMaps;
    }

    public void additionalMaps(File additionalMaps) {
        this.setAdditionalMaps(additionalMaps);
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public void client(boolean client) {
        this.setClient(client);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void encoding(String encoding) {
        this.setEncoding(encoding);
    }

    public String getExcludeEntities() {
        return this.excludeEntities;
    }

    public void setExcludeEntities(String excludeEntities) {
        this.excludeEntities = excludeEntities;
    }

    public void excludeEntities(String excludeEntities) {
        this.setExcludeEntities(excludeEntities);
    }

    public String getIncludeEntities() {
        return this.includeEntities;
    }

    public void setIncludeEntities(String includeEntities) {
        this.includeEntities = includeEntities;
    }

    public void includeEntities(String includeEntities) {
        this.setIncludeEntities(includeEntities);
    }

    public boolean isMakePairs() {
        return this.makePairs;
    }

    public void setMakePairs(boolean makePairs) {
        this.makePairs = makePairs;
    }

    public void makePairs(boolean makePairs) {
        this.setMakePairs(makePairs);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void mode(String mode) {
        this.setMode(mode);
    }

    public String getOutputPattern() {
        return this.outputPattern;
    }

    public void setOutputPattern(String outputPattern) {
        this.outputPattern = outputPattern;
    }

    public void outputPattern(String outputPattern) {
        this.setOutputPattern(outputPattern);
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void overwrite(boolean overwrite) {
        this.setOverwrite(overwrite);
    }

    public String getSuperPkg() {
        return this.superPkg;
    }

    public void setSuperPkg(String superPkg) {
        this.superPkg = superPkg;
    }

    public void superPkg(String superPkg) {
        this.setSuperPkg(superPkg);
    }

    public String getSuperTemplate() {
        return this.superTemplate;
    }

    public void setSuperTemplate(String superTemplate) {
        this.superTemplate = superTemplate;
    }

    public void superTemplate(String superTemplate) {
        this.setSuperTemplate(superTemplate);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void template(String template) {
        this.setTemplate(template);
    }

    public String getEmbeddableSuperTemplate() {
        return this.embeddableSuperTemplate;
    }

    public void setEmbeddableSuperTemplate(String embeddableSuperTemplate) {
        this.embeddableSuperTemplate = embeddableSuperTemplate;
    }

    public void embeddableSuperTemplate(String embeddableSuperTemplate) {
        this.setEmbeddableSuperTemplate(embeddableSuperTemplate);
    }

    public String getEmbeddableTemplate() {
        return this.embeddableTemplate;
    }

    public void setEmbeddableTemplate(String embeddableTemplate) {
        this.embeddableTemplate = embeddableTemplate;
    }

    public void embeddableTemplate(String embeddableTemplate) {
        this.setEmbeddableTemplate(embeddableTemplate);
    }

    public boolean isUsePkgPath() {
        return this.usePkgPath;
    }

    public void setUsePkgPath(boolean usePkgPath) {
        this.usePkgPath = usePkgPath;
    }

    public void usePkgPath(boolean usePkgPath) {
        this.setUsePkgPath(usePkgPath);
    }

    public boolean isCreatePropertyNames() {
        return this.createPropertyNames;
    }

    public void setCreatePropertyNames(boolean createPropertyNames) {
        this.createPropertyNames = createPropertyNames;
    }

    public void createPropertyNames(boolean createPropertyNames) {
        this.setCreatePropertyNames(createPropertyNames);
    }
}

