/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.isis.core.runtime;

import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import org.apache.isis.core.interaction.IsisModuleCoreInteraction;
import org.apache.isis.core.metamodel.IsisModuleCoreMetamodel;
import org.apache.isis.core.runtime.events.MetamodelEventService;
import org.apache.isis.core.runtime.events.TransactionEventEmitter;
import org.apache.isis.core.transaction.IsisModuleCoreTransaction;
import org.apache.isis.valuetypes.jodatime.integration.IsisModuleValJodatimeIntegration;

@Configuration
@Import({
        // Modules
        IsisModuleCoreMetamodel.class,
        IsisModuleCoreInteraction.class,
        IsisModuleCoreTransaction.class,

        // Joda Time support
        IsisModuleValJodatimeIntegration.class,

        // @Service's
        MetamodelEventService.class,
        TransactionEventEmitter.class,

        // @Configuration's

})
public class IsisModuleCoreRuntime {

    public static final String NAMESPACE = "isis.runtime";
}
