/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.isis.core.metamodel.interactions;

import java.util.function.Supplier;

import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.services.wrapper.events.ValidityEvent;
import org.apache.isis.core.metamodel.consent.InteractionContextType;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;

import lombok.Getter;

/**
 * See {@link InteractionContext} for overview; analogous to
 * {@link ValidityEvent}
 */
public abstract class ValidityContext
extends InteractionContext
implements InteractionEventSupplier<ValidityEvent> {

    @Getter private final Supplier<String> friendlyNameProvider;

    public ValidityContext(
            final InteractionContextType interactionType,
            final InteractionHead head,
            final Identifier identifier,
            final Supplier<String> friendlyNameProvider,
            final InteractionInitiatedBy invocationMethod) {
        super(interactionType, invocationMethod, identifier, head, Where.NOT_SPECIFIED);
        this.friendlyNameProvider = friendlyNameProvider;
    }

}
