/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.viewer.wicket.ui.components.scalars;

import java.util.EnumSet;

import org.apache.wicket.util.convert.IConverter;

import org.apache.causeway.core.metamodel.commons.ScalarRepresentation;
import org.apache.causeway.core.metamodel.spec.feature.ObjectFeature;
import org.apache.causeway.viewer.wicket.model.models.ScalarModel;

import lombok.NonNull;

/**
 * Specialization of {@link ScalarPanelTextFieldAbstract},
 * where the scalar (parameter or property) is a value-type, that is
 * textual and requires no conversion.
 */
public abstract class ScalarPanelTextFieldTextualAbstract
extends ScalarPanelTextFieldAbstract<String> {

    private static final long serialVersionUID = 1L;

    protected ScalarPanelTextFieldTextualAbstract(
            final String id, final ScalarModel scalarModel) {
        super(id, scalarModel, String.class);
    }

    @Override
    protected void setupFormatModifiers(final EnumSet<FormatModifier> modifiers) {
        // enforce use of text representation
        modifiers.add(FormatModifier.TEXT_ONLY);
    }

    @Override
    protected final IConverter<String> getConverter(
            final @NonNull ObjectFeature propOrParam,
            final @NonNull ScalarRepresentation scalarRepresentation) {
        return null; // does not use conversion
    }


}
