/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.viewer.wicket.model.models;

import java.util.Optional;
import java.util.stream.Stream;

import org.apache.wicket.request.mapper.parameter.PageParameters;

import org.apache.causeway.applib.annotation.BookmarkPolicy;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.viewer.commons.model.mixin.HasTitle;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;

public interface BookmarkableModel
extends HasTitle {

    /**
     * So can be bookmarked / added to <tt>BookmarkedPagesModel</tt>.
     */
    public abstract PageParameters getPageParameters();

    public abstract PageParameters getPageParametersWithoutUiHints();

    /** governs how to populate the BookmarkPanel in the UI */
    public abstract BookmarkPolicy getBookmarkPolicy();

    default Optional<Bookmark> toBookmark() {
        return PageParameterUtils.toBookmark(getPageParametersWithoutUiHints());
    }

    /**
     * Stream bookmarks of all non mixed in properties of the underlying domain object.
     * (empty for action bookmarks)
     * <p>
     * Introduced to discover parent/child relations for the BookmarkPanel.
     */
    default Stream<Bookmark> streamPropertyBookmarks() {
        return Stream.empty();
    }

}
