/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package demoapp.dom.domain.objects.other.customvaluetypes;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

import demoapp.dom.domain.objects.other.embedded.jdo.ComplexNumberJdo;
import lombok.val;

class ComplexNumberJdo_Test {

    @Test
    void title() {
        val cn = ComplexNumberJdo.of(10.0, 5.0);
        Assertions.assertThat(cn.title()).isEqualTo("10.0 + 5.0i");
    }

    @Test
    void parse() {
        val cn = ComplexNumberJdo.parse("10.0 + 5.0i");

        Assertions.assertThat(cn).isPresent();
        Assertions.assertThat(cn.get().title()).isEqualTo("10.0 + 5.0i");
    }
}
