/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.postings;

import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.index.sai.postings.PostingList;
import org.apache.cassandra.utils.Throwables;

@NotThreadSafe
public class PeekablePostingList
implements PostingList {
    private final PostingList wrapped;
    private boolean peeked = false;
    private long next;

    public static PeekablePostingList makePeekable(PostingList postingList) {
        return postingList instanceof PeekablePostingList ? (PeekablePostingList)postingList : new PeekablePostingList(postingList);
    }

    private PeekablePostingList(PostingList wrapped) {
        this.wrapped = wrapped;
    }

    public long peek() {
        if (this.peeked) {
            return this.next;
        }
        try {
            this.peeked = true;
            this.next = this.wrapped.nextPosting();
            return this.next;
        }
        catch (IOException e) {
            throw Throwables.cleaned(e);
        }
    }

    public void advanceWithoutConsuming(long targetRowID) throws IOException {
        if (this.peek() == Long.MAX_VALUE) {
            return;
        }
        if (this.peek() >= targetRowID) {
            this.peek();
            return;
        }
        this.peeked = true;
        this.next = this.wrapped.advance(targetRowID);
    }

    @Override
    public long minimum() {
        return this.wrapped.maximum();
    }

    @Override
    public long maximum() {
        return this.wrapped.maximum();
    }

    @Override
    public long nextPosting() throws IOException {
        if (this.peeked) {
            this.peeked = false;
            return this.next;
        }
        return this.wrapped.nextPosting();
    }

    @Override
    public long size() {
        return this.wrapped.size();
    }

    @Override
    public long advance(long targetRowID) throws IOException {
        if (this.peeked && this.next >= targetRowID) {
            this.peeked = false;
            return this.next;
        }
        this.peeked = false;
        return this.wrapped.advance(targetRowID);
    }

    @Override
    public void close() {
        this.wrapped.close();
    }
}

