/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import io.netty.util.concurrent.FastThreadLocal;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.FileUtils;

public final class ThreadLocalReadAheadBuffer {
    private final ChannelProxy channel;
    private final BufferType bufferType;
    private static final FastThreadLocal<Map<String, Block>> blockMap = new FastThreadLocal<Map<String, Block>>(){

        protected Map<String, Block> initialValue() {
            return new HashMap<String, Block>();
        }
    };
    private final int bufferSize;
    private final long channelSize;

    public ThreadLocalReadAheadBuffer(ChannelProxy channel, int bufferSize, BufferType bufferType) {
        this.channel = channel;
        this.channelSize = channel.size();
        this.bufferSize = bufferSize;
        this.bufferType = bufferType;
    }

    public boolean hasBuffer() {
        return this.block().buffer != null;
    }

    public int remaining() {
        return this.getBlock().buffer.remaining();
    }

    public void allocateBuffer() {
        this.getBlock();
    }

    private Block getBlock() {
        Block block = this.block();
        if (block.buffer == null) {
            block.buffer = this.bufferType.allocate(this.bufferSize);
            block.buffer.clear();
        }
        return block;
    }

    private Block block() {
        return ((Map)blockMap.get()).computeIfAbsent(this.channel.filePath(), k -> new Block());
    }

    public void fill(long position) {
        Block block = this.getBlock();
        ByteBuffer blockBuffer = block.buffer;
        long realPosition = Math.min(this.channelSize, position);
        int blockNo = (int)(realPosition / (long)this.bufferSize);
        long blockPosition = (long)blockNo * (long)this.bufferSize;
        long remaining = this.channelSize - blockPosition;
        int sizeToRead = (int)Math.min(remaining, (long)this.bufferSize);
        if (block.index != blockNo) {
            blockBuffer.flip();
            blockBuffer.limit(sizeToRead);
            if (this.channel.read(blockBuffer, blockPosition) != sizeToRead) {
                throw new CorruptSSTableException(null, this.channel.filePath());
            }
            block.index = blockNo;
        }
        blockBuffer.flip();
        blockBuffer.limit(sizeToRead);
        blockBuffer.position((int)(realPosition - blockPosition));
    }

    public int read(ByteBuffer dest, int length) {
        Block block = this.getBlock();
        ByteBuffer blockBuffer = block.buffer;
        ByteBuffer tmp = blockBuffer.duplicate();
        tmp.limit(tmp.position() + length);
        dest.put(tmp);
        blockBuffer.position(blockBuffer.position() + length);
        return length;
    }

    public void clear(boolean deallocate) {
        Block block = this.getBlock();
        block.index = -1;
        ByteBuffer blockBuffer = block.buffer;
        if (blockBuffer != null) {
            blockBuffer.clear();
            if (deallocate) {
                FileUtils.clean(blockBuffer);
                block.buffer = null;
            }
        }
    }

    public void close() {
        this.clear(true);
        ((Map)blockMap.get()).remove(this.channel.filePath());
    }

    private static class Block {
        ByteBuffer buffer = null;
        int index = -1;

        private Block() {
        }
    }
}

