/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ChunkReader;
import org.apache.cassandra.io.util.CompressedChunkReader;
import org.apache.cassandra.io.util.DiskOptimizationStrategy;
import org.apache.cassandra.io.util.EmptyRebufferer;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.LimitingRebufferer;
import org.apache.cassandra.io.util.MmapRebufferer;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.MmappedRegionsCache;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.RebuffererFactory;
import org.apache.cassandra.io.util.SimpleChunkReader;
import org.apache.cassandra.utils.NativeLibrary;
import org.apache.cassandra.utils.Throwables;
import org.apache.cassandra.utils.concurrent.Ref;
import org.apache.cassandra.utils.concurrent.RefCounted;
import org.apache.cassandra.utils.concurrent.SharedCloseableImpl;

public class FileHandle
extends SharedCloseableImpl {
    public final ChannelProxy channel;
    public final long onDiskLength;
    private final RebuffererFactory rebuffererFactory;
    private final Optional<CompressionMetadata> compressionMetadata;

    private FileHandle(Cleanup cleanup, ChannelProxy channel, RebuffererFactory rebuffererFactory, CompressionMetadata compressionMetadata, long onDiskLength) {
        super(cleanup);
        this.rebuffererFactory = rebuffererFactory;
        this.channel = channel;
        this.compressionMetadata = Optional.ofNullable(compressionMetadata);
        this.onDiskLength = onDiskLength;
    }

    private FileHandle(FileHandle copy) {
        super(copy);
        this.channel = copy.channel;
        this.rebuffererFactory = copy.rebuffererFactory;
        this.compressionMetadata = copy.compressionMetadata;
        this.onDiskLength = copy.onDiskLength;
    }

    public File file() {
        return new File(this.channel.filePath());
    }

    public String path() {
        return this.channel.filePath();
    }

    public long dataLength() {
        return this.compressionMetadata.map(c -> c.dataLength).orElseGet(this.rebuffererFactory::fileLength);
    }

    public RebuffererFactory rebuffererFactory() {
        return this.rebuffererFactory;
    }

    public Optional<CompressionMetadata> compressionMetadata() {
        return this.compressionMetadata;
    }

    @Override
    public void addTo(Ref.IdentityCollection identities) {
        super.addTo(identities);
    }

    @Override
    public FileHandle sharedCopy() {
        return new FileHandle(this);
    }

    public RandomAccessReader createReader() {
        return this.createReader(null);
    }

    public RandomAccessReader createReaderForScan() {
        return this.createReader(null, true);
    }

    public RandomAccessReader createReader(RateLimiter limiter) {
        return this.createReader(limiter, false);
    }

    public RandomAccessReader createReader(RateLimiter limiter, boolean forScan) {
        return new RandomAccessReader(this.instantiateRebufferer(limiter, forScan));
    }

    public FileDataInput createReader(long position) {
        RandomAccessReader reader = this.createReader();
        try {
            reader.seek(position);
            return reader;
        }
        catch (Throwable t) {
            try {
                reader.close();
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }

    public void dropPageCache(long before) {
        long position = this.compressionMetadata.map(metadata -> {
            if (before >= metadata.dataLength) {
                return 0L;
            }
            return metadata.chunkFor((long)before).offset;
        }).orElse(before);
        NativeLibrary.trySkipCache(this.channel.getFileDescriptor(), 0L, position, this.file().absolutePath());
    }

    public Rebufferer instantiateRebufferer(RateLimiter limiter) {
        return this.instantiateRebufferer(limiter, false);
    }

    public Rebufferer instantiateRebufferer(RateLimiter limiter, boolean forScan) {
        Rebufferer rebufferer = this.rebuffererFactory.instantiateRebufferer(forScan);
        if (limiter != null) {
            rebufferer = new LimitingRebufferer(rebufferer, limiter, 65536);
        }
        return rebufferer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(path='" + this.file() + "', length=" + this.rebuffererFactory.fileLength() + ")";
    }

    public static class Builder {
        public static final long NO_LENGTH_OVERRIDE = -1L;
        public final File file;
        private CompressionMetadata compressionMetadata;
        private Supplier<Double> crcCheckChanceSupplier = () -> 1.0;
        private ChunkCache chunkCache;
        private int bufferSize = 4096;
        private BufferType bufferType = BufferType.OFF_HEAP;
        private boolean mmapped = false;
        private long lengthOverride = -1L;
        private MmappedRegionsCache mmappedRegionsCache;

        public Builder(File file) {
            this.file = file;
        }

        public Builder withChunkCache(ChunkCache chunkCache) {
            this.chunkCache = chunkCache;
            return this;
        }

        public Builder withCompressionMetadata(CompressionMetadata metadata) {
            this.compressionMetadata = metadata;
            return this;
        }

        public Builder withCrcCheckChance(Supplier<Double> crcCheckChanceSupplier) {
            this.crcCheckChanceSupplier = crcCheckChanceSupplier;
            return this;
        }

        public Builder mmapped(boolean mmapped) {
            this.mmapped = mmapped;
            return this;
        }

        public Builder mmapped(Config.DiskAccessMode diskAccessMode) {
            this.mmapped = diskAccessMode == Config.DiskAccessMode.mmap;
            return this;
        }

        public Builder withMmappedRegionsCache(MmappedRegionsCache mmappedRegionsCache) {
            this.mmappedRegionsCache = mmappedRegionsCache;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder bufferType(BufferType bufferType) {
            this.bufferType = bufferType;
            return this;
        }

        public Builder withLengthOverride(long lengthOverride) {
            this.lengthOverride = lengthOverride;
            return this;
        }

        public FileHandle complete() {
            return this.complete(ChannelProxy::new);
        }

        @VisibleForTesting
        public FileHandle complete(Function<File, ChannelProxy> channelProxyFactory) {
            ChannelProxy channel = null;
            MmappedRegions regions = null;
            CompressionMetadata compressionMetadata = null;
            try {
                RebuffererFactory rebuffererFactory;
                long length;
                compressionMetadata = this.compressionMetadata != null ? this.compressionMetadata.sharedCopy() : null;
                channel = channelProxyFactory.apply(this.file);
                long fileLength = compressionMetadata != null ? compressionMetadata.compressedFileLength : channel.size();
                long l = length = this.lengthOverride > 0L ? this.lengthOverride : fileLength;
                if (length == 0L) {
                    rebuffererFactory = new EmptyRebufferer(channel);
                } else if (this.mmapped) {
                    if (compressionMetadata != null) {
                        regions = this.mmappedRegionsCache != null ? this.mmappedRegionsCache.getOrCreate(channel, compressionMetadata) : MmappedRegions.map(channel, compressionMetadata);
                        rebuffererFactory = this.maybeCached(new CompressedChunkReader.Mmap(channel, compressionMetadata, regions, this.crcCheckChanceSupplier));
                    } else {
                        regions = this.mmappedRegionsCache != null ? this.mmappedRegionsCache.getOrCreate(channel, length) : MmappedRegions.map(channel, length);
                        rebuffererFactory = new MmapRebufferer(channel, length, regions);
                    }
                } else if (compressionMetadata != null) {
                    rebuffererFactory = this.maybeCached(new CompressedChunkReader.Standard(channel, compressionMetadata, this.crcCheckChanceSupplier));
                } else {
                    int chunkSize = DiskOptimizationStrategy.roundForCaching(this.bufferSize, ChunkCache.roundUp);
                    rebuffererFactory = this.maybeCached(new SimpleChunkReader(channel, length, this.bufferType, chunkSize));
                }
                Cleanup cleanup = new Cleanup(channel, rebuffererFactory, compressionMetadata, this.chunkCache);
                FileHandle fileHandle = new FileHandle(cleanup, channel, rebuffererFactory, compressionMetadata, length);
                return fileHandle;
            }
            catch (Throwable t) {
                Throwables.closeNonNullAndAddSuppressed(t, regions, channel, compressionMetadata);
                throw t;
            }
        }

        private RebuffererFactory maybeCached(ChunkReader reader) {
            if (this.chunkCache != null && this.chunkCache.capacity() > 0L) {
                return this.chunkCache.wrap(reader);
            }
            return reader;
        }
    }

    private static class Cleanup
    implements RefCounted.Tidy {
        final ChannelProxy channel;
        final RebuffererFactory rebufferer;
        final CompressionMetadata compressionMetadata;
        final Optional<ChunkCache> chunkCache;

        private Cleanup(ChannelProxy channel, RebuffererFactory rebufferer, CompressionMetadata compressionMetadata, ChunkCache chunkCache) {
            this.channel = channel;
            this.rebufferer = rebufferer;
            this.compressionMetadata = compressionMetadata;
            this.chunkCache = Optional.ofNullable(chunkCache);
        }

        @Override
        public String name() {
            return this.channel.filePath();
        }

        @Override
        public void tidy() {
            this.chunkCache.ifPresent(cache -> cache.invalidateFile(this.name()));
            try {
                if (this.compressionMetadata != null) {
                    this.compressionMetadata.close();
                }
            }
            finally {
                try {
                    this.channel.close();
                }
                finally {
                    this.rebufferer.close();
                }
            }
        }
    }
}

