/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.io.FSWriteError;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileOutputStreamPlus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TOCComponent {
    private static final Logger logger = LoggerFactory.getLogger(TOCComponent.class);

    public static Set<Component> loadTOC(Descriptor descriptor) throws IOException {
        return TOCComponent.loadTOC(descriptor, true);
    }

    public static Set<Component> loadTOC(Descriptor descriptor, boolean skipMissing) throws IOException {
        File tocFile = descriptor.fileFor(SSTableFormat.Components.TOC);
        List<String> componentNames = Files.readAllLines(tocFile.toPath());
        HashSet components = Sets.newHashSetWithExpectedSize((int)componentNames.size());
        for (String componentName : componentNames) {
            Component component = Component.parse(componentName, descriptor.version.format);
            if (skipMissing && !descriptor.fileFor(component).exists()) {
                logger.error("Missing component: {}", (Object)descriptor.fileFor(component));
                continue;
            }
            components.add(component);
        }
        return components;
    }

    public static void appendTOC(Descriptor descriptor, Collection<Component> components) {
        File tocFile = descriptor.fileFor(SSTableFormat.Components.TOC);
        try (FileOutputStreamPlus out = tocFile.newOutputStream(File.WriteMode.APPEND);
             PrintWriter w = new PrintWriter(out);){
            for (Component component : components) {
                w.println(component.name);
            }
            w.flush();
            out.sync();
        }
        catch (IOException e) {
            throw new FSWriteError((Throwable)e, tocFile);
        }
    }

    public static Set<Component> loadOrCreate(Descriptor descriptor) {
        try {
            try {
                return TOCComponent.loadTOC(descriptor);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                Set<Component> components = descriptor.discoverComponents();
                if (components.isEmpty()) {
                    return components;
                }
                components.add(SSTableFormat.Components.TOC);
                TOCComponent.appendTOC(descriptor, components);
                return components;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static void rewriteTOC(Descriptor descriptor, Collection<Component> components) {
        File tocFile = descriptor.fileFor(SSTableFormat.Components.TOC);
        if (!tocFile.tryDelete()) {
            logger.error("Failed to delete TOC component for " + descriptor);
        }
        TOCComponent.appendTOC(descriptor, components);
    }
}

