/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate.values;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.stress.generate.FasterRandom;
import org.apache.cassandra.stress.generate.values.Generator;
import org.apache.cassandra.stress.generate.values.GeneratorConfig;

public class Bytes
extends Generator<ByteBuffer> {
    private final byte[] bytes;
    private final FasterRandom rand = new FasterRandom();

    public Bytes(String name, GeneratorConfig config) {
        super((AbstractType<?>)BytesType.instance, config, name, ByteBuffer.class);
        this.bytes = new byte[(int)this.sizeDistribution.maxValue()];
    }

    @Override
    public ByteBuffer generate() {
        long seed = this.identityDistribution.next();
        this.sizeDistribution.setSeed(seed);
        this.rand.setSeed(seed ^ 0xFFFFFFFFFFFFFFFFL);
        int size = (int)this.sizeDistribution.next();
        int i = 0;
        while (i < size) {
            long v = this.rand.nextLong();
            long n = Math.min(size - i, 8);
            while (n-- > 0L) {
                this.bytes[i++] = (byte)v;
                v >>= 8;
            }
        }
        return ByteBuffer.wrap(Arrays.copyOf(this.bytes, size));
    }
}

