/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos.cleanup;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.paxos.AbstractPaxosRepair;
import org.apache.cassandra.service.paxos.PaxosRepair;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupRequest;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupResponse;
import org.apache.cassandra.service.paxos.cleanup.PaxosCleanupSession;
import org.apache.cassandra.service.paxos.cleanup.PaxosTableRepairs;
import org.apache.cassandra.service.paxos.uncommitted.UncommittedPaxosKey;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.concurrent.AsyncFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosCleanupLocalCoordinator
extends AsyncFuture<PaxosCleanupResponse> {
    private static final Logger logger = LoggerFactory.getLogger(PaxosCleanupLocalCoordinator.class);
    private static final UUID INTERNAL_SESSION = new UUID(0L, 0L);
    private final UUID session;
    private final TableId tableId;
    private final TableMetadata table;
    private final Collection<Range<Token>> ranges;
    private final CloseableIterator<UncommittedPaxosKey> uncommittedIter;
    private int count = 0;
    private final long deadline;
    private final Map<DecoratedKey, AbstractPaxosRepair> inflight = new ConcurrentHashMap<DecoratedKey, AbstractPaxosRepair>();
    private final PaxosTableRepairs tableRepairs;

    private PaxosCleanupLocalCoordinator(UUID session, TableId tableId, Collection<Range<Token>> ranges, CloseableIterator<UncommittedPaxosKey> uncommittedIter) {
        this.session = session;
        this.tableId = tableId;
        this.table = Schema.instance.getTableMetadata(tableId);
        this.ranges = ranges;
        this.uncommittedIter = uncommittedIter;
        this.tableRepairs = PaxosTableRepairs.getForTable(tableId);
        this.deadline = PaxosCleanupSession.TIMEOUT_NANOS + Clock.Global.nanoTime();
    }

    public synchronized void start() {
        if (this.table == null) {
            this.fail("Unknown tableId: " + this.tableId);
            return;
        }
        if (!PaxosRepair.validatePeerCompatibility(this.table, this.ranges)) {
            this.fail("Unsupported peer versions for " + this.tableId + " " + this.ranges.toString());
            return;
        }
        logger.info("Completing uncommitted paxos instances for {} on ranges {} for session {}", new Object[]{this.table, this.ranges, this.session});
        this.scheduleKeyRepairsOrFinish();
    }

    public static PaxosCleanupLocalCoordinator create(PaxosCleanupRequest request) {
        CloseableIterator<UncommittedPaxosKey> iterator = PaxosState.uncommittedTracker().uncommittedKeyIterator(request.tableId, request.ranges);
        return new PaxosCleanupLocalCoordinator(request.session, request.tableId, request.ranges, iterator);
    }

    public static PaxosCleanupLocalCoordinator createForAutoRepair(TableId tableId, Collection<Range<Token>> ranges) {
        CloseableIterator<UncommittedPaxosKey> iterator = PaxosState.uncommittedTracker().uncommittedKeyIterator(tableId, ranges);
        return new PaxosCleanupLocalCoordinator(INTERNAL_SESSION, tableId, ranges, iterator);
    }

    private void scheduleKeyRepairsOrFinish() {
        int parallelism = DatabaseDescriptor.getPaxosRepairParallelism();
        Preconditions.checkArgument((parallelism > 0 ? 1 : 0) != 0);
        if (this.inflight.size() < parallelism) {
            if (Clock.Global.nanoTime() - this.deadline >= 0L) {
                this.fail("timeout");
                return;
            }
            while (this.inflight.size() < parallelism && this.uncommittedIter.hasNext()) {
                this.repairKey((UncommittedPaxosKey)this.uncommittedIter.next());
            }
        }
        if (this.inflight.isEmpty()) {
            this.finish();
        }
    }

    private boolean repairKey(UncommittedPaxosKey uncommitted) {
        logger.trace("repairing {}", (Object)uncommitted);
        Preconditions.checkState((!this.inflight.containsKey(uncommitted.getKey()) ? 1 : 0) != 0);
        ConsistencyLevel consistency = uncommitted.getConsistencyLevel();
        if (consistency == null) {
            return false;
        }
        this.inflight.put(uncommitted.getKey(), this.tableRepairs.startOrGetOrQueue(uncommitted.getKey(), uncommitted.ballot(), uncommitted.getConsistencyLevel(), this.table, result -> {
            if (result.wasSuccessful()) {
                this.onKeyFinish(uncommitted.getKey());
            } else {
                this.onKeyFailure(result.toString());
            }
        }));
        return true;
    }

    private synchronized void onKeyFinish(DecoratedKey key) {
        if (!this.inflight.containsKey(key)) {
            return;
        }
        logger.trace("finished repairing {}", (Object)key);
        this.inflight.remove(key);
        ++this.count;
        this.scheduleKeyRepairsOrFinish();
    }

    private void complete(PaxosCleanupResponse response) {
        this.uncommittedIter.close();
        this.trySuccess(response);
    }

    private void onKeyFailure(String reason) {
        this.inflight.values().forEach(AbstractPaxosRepair::cancel);
        this.fail(reason);
    }

    private synchronized void fail(String reason) {
        logger.info("Failing paxos cleanup session {} for {} on ranges {}. Reason: {}", new Object[]{this.session, this.table, this.ranges, reason});
        this.complete(PaxosCleanupResponse.failed(this.session, reason));
    }

    private void finish() {
        logger.info("Completed {} uncommitted paxos instances for {} on ranges {} for session {}", new Object[]{this.count, this.table, this.ranges, this.session});
        this.complete(PaxosCleanupResponse.success(this.session));
    }
}

