/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ScheduledExecutorPlus;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.UnavailableException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.RequestCallback;
import org.apache.cassandra.net.RequestCallbackWithFailure;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.schema.TableId;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.paxos.AbstractPaxosRepair;
import org.apache.cassandra.service.paxos.Ballot;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.ContentionStrategy;
import org.apache.cassandra.service.paxos.Paxos;
import org.apache.cassandra.service.paxos.PaxosCommit;
import org.apache.cassandra.service.paxos.PaxosPrepare;
import org.apache.cassandra.service.paxos.PaxosPropose;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.Clock;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.cassandra.utils.NullableSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosRepair
extends AbstractPaxosRepair {
    private static final Logger logger = LoggerFactory.getLogger(PaxosRepair.class);
    public static final RequestSerializer requestSerializer = new RequestSerializer();
    public static final ResponseSerializer responseSerializer = new ResponseSerializer();
    public static final RequestHandler requestHandler = new RequestHandler();
    private static final long RETRY_TIMEOUT_NANOS = PaxosRepair.getRetryTimeoutNanos();
    private static final ScheduledExecutorPlus RETRIES = ExecutorFactory.Global.executorFactory().scheduled("PaxosRepairRetries");
    private final TableMetadata table;
    private final ConsistencyLevel paxosConsistency;
    private Paxos.Participants participants;
    private Ballot successCriteria;
    private Ballot prevSupersededBy;
    private int attempts;
    private static volatile boolean SKIP_VERSION_VALIDATION = CassandraRelevantProperties.SKIP_PAXOS_REPAIR_VERSION_VALIDATION.getBoolean();

    private static long getRetryTimeoutNanos() {
        long retryMillis = CassandraRelevantProperties.PAXOS_REPAIR_RETRY_TIMEOUT_IN_MS.getLong();
        return TimeUnit.MILLISECONDS.toNanos(retryMillis);
    }

    public String toString() {
        return "PaxosRepair{key=" + this.partitionKey() + ", table=" + this.table.toString() + ", consistency=" + this.paxosConsistency + ", participants=" + this.participants.electorate + ", state=" + this.state() + ", startedMillis=" + MonotonicClock.Global.approxTime.translate().toMillisSinceEpoch(this.startedNanos()) + ", started=" + this.isStarted() + "}";
    }

    private PaxosRepair(DecoratedKey partitionKey, Ballot incompleteBallot, TableMetadata table, ConsistencyLevel paxosConsistency) {
        super(partitionKey, incompleteBallot);
        Preconditions.checkArgument((boolean)paxosConsistency.isSerialConsistency());
        this.table = table;
        this.paxosConsistency = paxosConsistency;
        this.successCriteria = incompleteBallot;
    }

    public static PaxosRepair create(ConsistencyLevel consistency, DecoratedKey partitionKey, Ballot incompleteBallot, TableMetadata table) {
        return new PaxosRepair(partitionKey, incompleteBallot, table, consistency);
    }

    private AbstractPaxosRepair.State retry(AbstractPaxosRepair.State state) {
        Preconditions.checkState((boolean)this.isStarted());
        if (PaxosRepair.isResult(state)) {
            return state;
        }
        return this.restart(state, ContentionStrategy.waitUntilForContention(++this.attempts, this.table, this.partitionKey(), this.paxosConsistency, ContentionStrategy.Type.REPAIR));
    }

    @Override
    public AbstractPaxosRepair.State restart(AbstractPaxosRepair.State state, long waitUntil) {
        long now;
        if (PaxosRepair.isResult(state)) {
            return state;
        }
        this.participants = Paxos.Participants.get(this.table, this.partitionKey(), this.paxosConsistency);
        if (waitUntil > Long.MIN_VALUE && waitUntil - this.startedNanos() > RETRY_TIMEOUT_NANOS) {
            return new AbstractPaxosRepair.Failure(null);
        }
        try {
            this.participants.assureSufficientLiveNodesForRepair();
        }
        catch (UnavailableException e) {
            return new AbstractPaxosRepair.Failure(e);
        }
        Querying querying = new Querying();
        if (waitUntil == Long.MIN_VALUE || waitUntil - (now = Clock.Global.nanoTime()) < 0L) {
            querying.run();
        } else {
            RETRIES.schedule(querying, waitUntil - now, TimeUnit.NANOSECONDS);
        }
        return querying;
    }

    private ConsistencyLevel commitConsistency() {
        Preconditions.checkState((boolean)this.paxosConsistency.isSerialConsistency());
        return this.paxosConsistency.isDatacenterLocal() ? ConsistencyLevel.LOCAL_QUORUM : ConsistencyLevel.QUORUM;
    }

    private static Map<String, Set<InetAddressAndPort>> mapToDc(Collection<InetAddressAndPort> endpoints, Function<InetAddressAndPort, String> dcFunc) {
        HashMap<String, Set<InetAddressAndPort>> map = new HashMap<String, Set<InetAddressAndPort>>();
        endpoints.forEach(e -> map.computeIfAbsent((String)dcFunc.apply((InetAddressAndPort)e), k -> new HashSet()).add(e));
        return map;
    }

    private static boolean hasQuorumOrSingleDead(Collection<InetAddressAndPort> all, Collection<InetAddressAndPort> live, boolean requireQuorum) {
        Preconditions.checkArgument((all.size() >= live.size() ? 1 : 0) != 0);
        return live.size() >= all.size() / 2 + 1 || !requireQuorum && live.size() >= all.size() - 1;
    }

    @VisibleForTesting
    static boolean hasSufficientLiveNodesForTopologyChange(Collection<InetAddressAndPort> allEndpoints, Collection<InetAddressAndPort> liveEndpoints, Function<InetAddressAndPort, String> dcFunc, boolean onlyQuorumRequired, boolean strictQuorum) {
        Map<String, Set<InetAddressAndPort>> allDcMap = PaxosRepair.mapToDc(allEndpoints, dcFunc);
        Map<String, Set<InetAddressAndPort>> liveDcMap = PaxosRepair.mapToDc(liveEndpoints, dcFunc);
        if (!PaxosRepair.hasQuorumOrSingleDead(allEndpoints, liveEndpoints, strictQuorum)) {
            return false;
        }
        if (onlyQuorumRequired) {
            return true;
        }
        for (Map.Entry<String, Set<InetAddressAndPort>> entry : allDcMap.entrySet()) {
            Set<InetAddressAndPort> live;
            Set<InetAddressAndPort> all = entry.getValue();
            if (PaxosRepair.hasQuorumOrSingleDead(all, live = liveDcMap.getOrDefault(entry.getKey(), Collections.emptySet()), strictQuorum)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSufficientLiveNodesForTopologyChange(Keyspace keyspace, Range<Token> range, Collection<InetAddressAndPort> liveEndpoints) {
        return PaxosRepair.hasSufficientLiveNodesForTopologyChange(keyspace.getReplicationStrategy().getNaturalReplicasForToken(range.right).endpoints(), liveEndpoints, DatabaseDescriptor.getEndpointSnitch()::getDatacenter, DatabaseDescriptor.paxoTopologyRepairNoDcChecks(), DatabaseDescriptor.paxoTopologyRepairStrictEachQuorum());
    }

    public static void setSkipPaxosRepairCompatibilityCheck(boolean v) {
        SKIP_VERSION_VALIDATION = v;
    }

    public static boolean getSkipPaxosRepairCompatibilityCheck() {
        return SKIP_VERSION_VALIDATION;
    }

    static boolean validateVersionCompatibility(CassandraVersion version) {
        if (SKIP_VERSION_VALIDATION) {
            return true;
        }
        if (version == null) {
            return false;
        }
        return version.major == 4 && version.minor > 0 || version.major > 4;
    }

    static String getPeerVersion(InetAddressAndPort peer) {
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(peer);
        if (epState == null) {
            return null;
        }
        VersionedValue value = epState.getApplicationState(ApplicationState.RELEASE_VERSION);
        if (value == null) {
            return null;
        }
        try {
            return value.value;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static boolean validatePeerCompatibility(Replica peer) {
        String versionString = PaxosRepair.getPeerVersion(peer.endpoint());
        CassandraVersion version = versionString != null ? new CassandraVersion(versionString) : null;
        boolean result = PaxosRepair.validateVersionCompatibility(version);
        if (!result) {
            logger.info("PaxosRepair isn't supported by {} on version {}", (Object)peer, (Object)versionString);
        }
        return result;
    }

    static boolean validatePeerCompatibility(TableMetadata table, Range<Token> range) {
        Paxos.Participants participants = Paxos.Participants.get(table, (Token)range.right, ConsistencyLevel.SERIAL);
        return Iterables.all((Iterable)participants.all, PaxosRepair::validatePeerCompatibility);
    }

    public static boolean validatePeerCompatibility(TableMetadata table, Collection<Range<Token>> ranges) {
        return Iterables.all(ranges, range -> PaxosRepair.validatePeerCompatibility(table, range));
    }

    public static void shutdownAndWait(long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownAndWait(timeout, units, RETRIES);
    }

    public static class ResponseSerializer
    implements IVersionedSerializer<Response> {
        @Override
        public void serialize(Response response, DataOutputPlus out, int version) throws IOException {
            response.latestWitnessedOrLowBound.serialize(out);
            NullableSerializer.serializeNullable(Commit.Accepted.serializer, response.acceptedButNotCommitted, out, version);
            Commit.Committed.serializer.serialize(response.committed, out, version);
        }

        @Override
        public Response deserialize(DataInputPlus in, int version) throws IOException {
            Ballot latestWitnessed = Ballot.deserialize(in);
            Commit.Accepted acceptedButNotCommitted = NullableSerializer.deserializeNullable(Commit.Accepted.serializer, in, version);
            Commit.Committed committed = (Commit.Committed)Commit.Committed.serializer.deserialize(in, version);
            return new Response(latestWitnessed, acceptedButNotCommitted, committed);
        }

        @Override
        public long serializedSize(Response response, int version) {
            return Ballot.sizeInBytes() + NullableSerializer.serializedSizeNullable(Commit.Accepted.serializer, response.acceptedButNotCommitted, version) + Commit.Committed.serializer.serializedSize(response.committed, version);
        }
    }

    public static class RequestSerializer
    implements IVersionedSerializer<Request> {
        @Override
        public void serialize(Request request, DataOutputPlus out, int version) throws IOException {
            request.table.id.serialize(out);
            DecoratedKey.serializer.serialize(request.partitionKey, out, version);
        }

        @Override
        public Request deserialize(DataInputPlus in, int version) throws IOException {
            TableMetadata table = Schema.instance.getExistingTableMetadata(TableId.deserialize(in));
            DecoratedKey partitionKey = (DecoratedKey)DecoratedKey.serializer.deserialize(in, table.partitioner, version);
            return new Request(partitionKey, table);
        }

        @Override
        public long serializedSize(Request request, int version) {
            return (long)request.table.id.serializedSize() + DecoratedKey.serializer.serializedSize(request.partitionKey, version);
        }
    }

    public static class RequestHandler
    implements IVerbHandler<Request> {
        @Override
        public void doVerb(Message<Request> message) {
            Commit.Committed committed;
            Commit.Accepted acceptedButNotCommited;
            Ballot latestWitnessed;
            Request request = (Request)message.payload;
            if (!Paxos.isInRangeAndShouldProcess(message.from(), request.partitionKey, request.table, false)) {
                MessagingService.instance().respondWithFailure(RequestFailureReason.UNKNOWN, message);
                return;
            }
            long nowInSec = FBUtilities.nowInSeconds();
            try (PaxosState state = PaxosState.get(request.partitionKey, request.table);){
                PaxosState.Snapshot snapshot = state.current(nowInSec);
                latestWitnessed = snapshot.latestWitnessedOrLowBound();
                acceptedButNotCommited = snapshot.accepted;
                committed = snapshot.committed;
            }
            Response response = new Response(latestWitnessed, acceptedButNotCommited, committed);
            MessagingService.instance().respond(response, message);
        }
    }

    static class Response {
        @Nonnull
        final Ballot latestWitnessedOrLowBound;
        @Nullable
        final Commit.Accepted acceptedButNotCommitted;
        @Nonnull
        final Commit.Committed committed;

        Response(Ballot latestWitnessedOrLowBound, @Nullable Commit.Accepted acceptedButNotCommitted, Commit.Committed committed) {
            this.latestWitnessedOrLowBound = latestWitnessedOrLowBound;
            this.acceptedButNotCommitted = acceptedButNotCommitted;
            this.committed = committed;
        }

        public String toString() {
            return String.format("Response(%s, %s, %s", this.latestWitnessedOrLowBound, this.acceptedButNotCommitted, this.committed);
        }
    }

    static class Request {
        final DecoratedKey partitionKey;
        final TableMetadata table;

        Request(DecoratedKey partitionKey, TableMetadata table) {
            this.partitionKey = partitionKey;
            this.table = table;
        }
    }

    private class CommitAndRestart
    extends AbstractPaxosRepair.ConsumerState<PaxosCommit.Status> {
        private CommitAndRestart() {
        }

        @Override
        public AbstractPaxosRepair.State execute(PaxosCommit.Status input) {
            return PaxosRepair.this.restart(this);
        }
    }

    private class CommittingRepair
    extends AbstractPaxosRepair.ConsumerState<PaxosCommit.Status> {
        private CommittingRepair() {
        }

        @Override
        public AbstractPaxosRepair.State execute(PaxosCommit.Status input) {
            logger.trace("PaxosRepair of {} {}", (Object)PaxosRepair.this.partitionKey(), (Object)input);
            return input.isSuccess() ? AbstractPaxosRepair.DONE : PaxosRepair.this.retry(this);
        }
    }

    private class ProposingRepair
    extends AbstractPaxosRepair.ConsumerState<PaxosPropose.Status> {
        final Commit.Proposal proposal;

        private ProposingRepair(Commit.Proposal proposal) {
            this.proposal = proposal;
        }

        @Override
        public AbstractPaxosRepair.State execute(PaxosPropose.Status input) {
            switch (input.outcome) {
                case MAYBE_FAILURE: {
                    return PaxosRepair.this.retry(this);
                }
                case SUPERSEDED: {
                    if (Commit.isAfter(input.superseded().by, PaxosRepair.this.prevSupersededBy)) {
                        PaxosRepair.this.prevSupersededBy = input.superseded().by;
                    }
                    return PaxosRepair.this.retry(this);
                }
                case SUCCESS: {
                    if (this.proposal.update.isEmpty()) {
                        logger.trace("PaxosRepair of {} complete after successful empty proposal", (Object)PaxosRepair.this.partitionKey());
                        return AbstractPaxosRepair.DONE;
                    }
                    logger.trace("PaxosRepair of {} committing successful proposal {}", (Object)PaxosRepair.this.partitionKey(), (Object)this.proposal);
                    return PaxosCommit.commit(this.proposal.agreed(), PaxosRepair.this.participants, PaxosRepair.this.paxosConsistency, PaxosRepair.this.commitConsistency(), true, new CommittingRepair());
                }
            }
            throw new IllegalStateException();
        }
    }

    private class PoisonProposals
    extends AbstractPaxosRepair.ConsumerState<PaxosPrepare.Status> {
        private PoisonProposals() {
        }

        @Override
        public AbstractPaxosRepair.State execute(PaxosPrepare.Status input) throws Throwable {
            switch (input.outcome) {
                case MAYBE_FAILURE: {
                    return PaxosRepair.this.retry(this);
                }
                case READ_PERMITTED: 
                case SUPERSEDED: {
                    PaxosRepair.this.prevSupersededBy = Commit.latest(PaxosRepair.this.prevSupersededBy, input.retryWithAtLeast());
                    return PaxosRepair.this.retry(this);
                }
                case FOUND_INCOMPLETE_ACCEPTED: {
                    PaxosPrepare.FoundIncompleteAccepted incomplete = input.incompleteAccepted();
                    Commit.Proposal propose = new Commit.Proposal(incomplete.ballot, incomplete.accepted.update);
                    logger.trace("PaxosRepair of {} found incomplete {}", (Object)PaxosRepair.this.partitionKey(), (Object)incomplete.accepted);
                    return PaxosPropose.propose(propose, PaxosRepair.this.participants, false, new ProposingRepair(propose));
                }
                case FOUND_INCOMPLETE_COMMITTED: {
                    PaxosPrepare.FoundIncompleteCommitted incomplete = input.incompleteCommitted();
                    logger.trace("PaxosRepair of {} found in progress {}", (Object)PaxosRepair.this.partitionKey(), (Object)incomplete.committed);
                    return PaxosCommit.commit(incomplete.committed, PaxosRepair.this.participants, PaxosRepair.this.paxosConsistency, PaxosRepair.this.commitConsistency(), true, new CommitAndRestart());
                }
                case PROMISED: {
                    logger.trace("PaxosRepair of {} submitting empty proposal", (Object)PaxosRepair.this.partitionKey());
                    Commit.Proposal proposal = Commit.Proposal.empty(input.success().ballot, PaxosRepair.this.partitionKey(), PaxosRepair.this.table);
                    return PaxosPropose.propose(proposal, PaxosRepair.this.participants, false, new ProposingRepair(proposal));
                }
            }
            throw new IllegalStateException();
        }
    }

    private class Querying
    extends AbstractPaxosRepair.State
    implements RequestCallbackWithFailure<Response>,
    Runnable {
        private int successes;
        private int failures;
        private Ballot latestWitnessed;
        @Nullable
        private Commit.Accepted latestAccepted;
        private Commit.Committed latestCommitted;
        private Ballot oldestCommitted;
        private Ballot clashingPromise;

        private Querying() {
        }

        @Override
        public void onFailure(InetAddressAndPort from, RequestFailureReason reason) {
            PaxosRepair.this.updateState(this, null, (i1, i2) -> i1.onFailure());
        }

        @Override
        public void onResponse(Message<Response> msg) {
            logger.trace("PaxosRepair {} from {}", msg.payload, (Object)msg.from());
            PaxosRepair.this.updateState(this, msg, Querying::onResponseInternal);
        }

        private AbstractPaxosRepair.State onFailure() {
            if (++this.failures + PaxosRepair.this.participants.sizeOfConsensusQuorum > PaxosRepair.this.participants.sizeOfPoll()) {
                return PaxosRepair.this.retry(this);
            }
            return this;
        }

        private AbstractPaxosRepair.State onResponseInternal(Message<Response> msg) {
            this.latestWitnessed = Commit.latest(this.latestWitnessed, ((Response)msg.payload).latestWitnessedOrLowBound);
            this.latestAccepted = Commit.latest(this.latestAccepted, ((Response)msg.payload).acceptedButNotCommitted);
            this.latestCommitted = Commit.latest(this.latestCommitted, ((Response)msg.payload).committed);
            if (this.oldestCommitted == null || Commit.isAfter(this.oldestCommitted, (Commit)((Response)msg.payload).committed)) {
                this.oldestCommitted = ((Response)msg.payload).committed.ballot;
            }
            if (Commit.isAfter(this.latestWitnessed, this.clashingPromise)) {
                this.clashingPromise = null;
            }
            if (Commit.timestampsClash(this.latestAccepted, ((Response)msg.payload).latestWitnessedOrLowBound)) {
                this.clashingPromise = ((Response)msg.payload).latestWitnessedOrLowBound;
            }
            if (Commit.timestampsClash(this.latestAccepted, this.latestWitnessed)) {
                this.clashingPromise = this.latestWitnessed;
            }
            if (++this.successes == PaxosRepair.this.participants.sizeOfConsensusQuorum) {
                return this.execute();
            }
            return this;
        }

        private AbstractPaxosRepair.State execute() {
            boolean reproposalMayBeRejected;
            this.latestWitnessed = Commit.latest(this.latestAccepted, this.latestWitnessed);
            Ballot latestPreviouslyWitnessed = Commit.latest(PaxosRepair.this.successCriteria, PaxosRepair.this.prevSupersededBy);
            if (PaxosRepair.this.successCriteria == null || Commit.timestampsClash(PaxosRepair.this.successCriteria, this.latestWitnessed)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("PaxosRepair of {} setting success criteria to {}", (Object)PaxosRepair.this.partitionKey(), (Object)Ballot.toString(this.latestWitnessed));
                }
                PaxosRepair.this.successCriteria = this.latestWitnessed;
            }
            boolean hasCommittedSuccessCriteria = Commit.isAfter((Commit)this.latestCommitted, PaxosRepair.this.successCriteria) || this.latestCommitted.hasBallot(PaxosRepair.this.successCriteria);
            boolean isPromisedButNotAccepted = Commit.isAfter(this.latestWitnessed, (Commit)this.latestAccepted);
            boolean isAcceptedButNotCommitted = Commit.isAfter((Commit)this.latestAccepted, (Commit)this.latestCommitted);
            boolean bl = reproposalMayBeRejected = this.clashingPromise != null || !Commit.isAfter(this.latestWitnessed, latestPreviouslyWitnessed);
            if (hasCommittedSuccessCriteria) {
                if (logger.isTraceEnabled()) {
                    logger.trace("PaxosRepair witnessed {} newer than success criteria {} (oldest: {})", new Object[]{this.latestCommitted, Ballot.toString(PaxosRepair.this.successCriteria), Ballot.toString(this.oldestCommitted)});
                }
                return this.oldestCommitted.equals(this.latestCommitted.ballot) ? AbstractPaxosRepair.DONE : (AbstractPaxosRepair.State)PaxosCommit.commit(this.latestCommitted, PaxosRepair.this.participants, PaxosRepair.this.paxosConsistency, PaxosRepair.this.commitConsistency(), true, new CommittingRepair());
            }
            if (isAcceptedButNotCommitted && !isPromisedButNotAccepted && !reproposalMayBeRejected) {
                if (logger.isTraceEnabled()) {
                    logger.trace("PaxosRepair of {} completing {}", (Object)PaxosRepair.this.partitionKey(), (Object)this.latestAccepted);
                }
                return PaxosPropose.propose(this.latestAccepted, PaxosRepair.this.participants, false, new ProposingRepair(this.latestAccepted));
            }
            if (isAcceptedButNotCommitted || isPromisedButNotAccepted || this.latestWitnessed.compareTo(latestPreviouslyWitnessed) < 0) {
                Ballot ballot = Paxos.staleBallotNewerThan(Commit.latest(this.latestWitnessed, latestPreviouslyWitnessed), PaxosRepair.this.paxosConsistency);
                if (logger.isTraceEnabled()) {
                    logger.trace("PaxosRepair of {} found incomplete promise or proposal; preparing stale ballot {}", (Object)PaxosRepair.this.partitionKey(), (Object)Ballot.toString(ballot));
                }
                return PaxosPrepare.prepareWithBallot(ballot, PaxosRepair.this.participants, PaxosRepair.this.partitionKey(), PaxosRepair.this.table, false, false, new PoisonProposals());
            }
            logger.error("PaxosRepair illegal state latestWitnessed={}, latestAcceptedButNotCommitted={}, latestCommitted={}, oldestCommitted={}", new Object[]{this.latestWitnessed, this.latestAccepted, this.latestCommitted, this.oldestCommitted});
            throw new IllegalStateException();
        }

        @Override
        public void run() {
            Message<Request> message = Message.out(Verb.PAXOS2_REPAIR_REQ, new Request(PaxosRepair.this.partitionKey(), PaxosRepair.this.table));
            int size = PaxosRepair.this.participants.sizeOfPoll();
            for (int i = 0; i < size; ++i) {
                MessagingService.instance().sendWithCallback(message, PaxosRepair.this.participants.voter(i), (RequestCallback)this);
            }
        }
    }
}

