/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.guardrails.Guardrails;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicationFactor;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.schema.SchemaConstants;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.ClientWarn;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStrategy
extends AbstractReplicationStrategy {
    private static final String REPLICATION_FACTOR = "replication_factor";
    private static final Logger logger = LoggerFactory.getLogger(SimpleStrategy.class);
    private final ReplicationFactor rf;

    public SimpleStrategy(String keyspaceName, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        super(keyspaceName, tokenMetadata, snitch, configOptions);
        SimpleStrategy.validateOptionsInternal(configOptions);
        this.rf = ReplicationFactor.fromString((String)this.configOptions.get(REPLICATION_FACTOR));
    }

    @Override
    public EndpointsForRange calculateNaturalReplicas(Token token, TokenMetadata metadata) {
        ArrayList<Token> ring = metadata.sortedTokens();
        if (ring.isEmpty()) {
            return EndpointsForRange.empty(new Range<Token>(metadata.partitioner.getMinimumToken(), metadata.partitioner.getMinimumToken()));
        }
        Token replicaEnd = TokenMetadata.firstToken(ring, token);
        Token replicaStart = metadata.getPredecessor(replicaEnd);
        Range<Token> replicaRange = new Range<Token>(replicaStart, replicaEnd);
        Iterator<Token> iter = TokenMetadata.ringIterator(ring, token, false);
        EndpointsForRange.Builder replicas = new EndpointsForRange.Builder(replicaRange, this.rf.allReplicas);
        while (replicas.size() < this.rf.allReplicas && iter.hasNext()) {
            Token tk = iter.next();
            InetAddressAndPort ep = metadata.getEndpoint(tk);
            if (replicas.endpoints().contains(ep)) continue;
            replicas.add(new Replica(ep, replicaRange, replicas.size() < this.rf.fullReplicas));
        }
        return replicas.build();
    }

    @Override
    public ReplicationFactor getReplicationFactor() {
        return this.rf;
    }

    private static void validateOptionsInternal(Map<String, String> configOptions) throws ConfigurationException {
        if (configOptions.get(REPLICATION_FACTOR) == null) {
            throw new ConfigurationException("SimpleStrategy requires a replication_factor strategy option.");
        }
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        SimpleStrategy.validateOptionsInternal(this.configOptions);
        this.validateReplicationFactor((String)this.configOptions.get(REPLICATION_FACTOR));
    }

    @Override
    public void maybeWarnOnOptions(ClientState state) {
        if (!SchemaConstants.isSystemKeyspace(this.keyspaceName)) {
            int nodeCount = StorageService.instance.getHostIdToEndpoint().size();
            Guardrails.minimumReplicationFactor.guard(this.rf.fullReplicas, this.keyspaceName, false, state);
            Guardrails.maximumReplicationFactor.guard(this.rf.fullReplicas, this.keyspaceName, false, state);
            if (this.rf.fullReplicas > nodeCount && nodeCount != 0) {
                String msg = "Your replication factor " + this.rf.fullReplicas + " for keyspace " + this.keyspaceName + " is higher than the number of nodes " + nodeCount;
                ClientWarn.instance.warn(msg);
                logger.warn(msg);
            }
        }
    }

    @Override
    public Collection<String> recognizedOptions() {
        return Collections.singleton(REPLICATION_FACTOR);
    }

    protected static void prepareOptions(Map<String, String> options, Map<String, String> previousOptions) {
        String rf = previousOptions.containsKey(REPLICATION_FACTOR) ? previousOptions.get(REPLICATION_FACTOR) : Integer.toString(DatabaseDescriptor.getDefaultKeyspaceRF());
        options.putIfAbsent(REPLICATION_FACTOR, rf);
    }
}

