/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.view;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.TypeUtil;
import org.apache.cassandra.utils.Interval;
import org.apache.cassandra.utils.IntervalTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeTermTree {
    private static final Logger logger = LoggerFactory.getLogger(RangeTermTree.class);
    protected final ByteBuffer min;
    protected final ByteBuffer max;
    protected final AbstractType<?> comparator;
    private final IntervalTree<Term, SSTableIndex, Interval<Term, SSTableIndex>> rangeTree;

    private RangeTermTree(ByteBuffer min, ByteBuffer max, IntervalTree<Term, SSTableIndex, Interval<Term, SSTableIndex>> rangeTree, AbstractType<?> comparator) {
        this.min = min;
        this.max = max;
        this.rangeTree = rangeTree;
        this.comparator = comparator;
    }

    public List<SSTableIndex> search(Expression e) {
        ByteBuffer minTerm = e.lower == null ? this.min : e.lower.value.encoded;
        ByteBuffer maxTerm = e.upper == null ? this.max : e.upper.value.encoded;
        return this.rangeTree.search((Term)((Object)Interval.create(new Term(minTerm, this.comparator), new Term(maxTerm, this.comparator), null)));
    }

    protected static class Term
    implements Comparable<Term> {
        private final ByteBuffer term;
        private final AbstractType<?> comparator;

        Term(ByteBuffer term, AbstractType<?> comparator) {
            this.term = term;
            this.comparator = comparator;
        }

        @Override
        public int compareTo(Term o) {
            return TypeUtil.compare(this.term, o.term, this.comparator);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("term", (Object)this.comparator.getString(this.term)).toString();
        }
    }

    static class Builder {
        private final AbstractType<?> comparator;
        private ByteBuffer min;
        private ByteBuffer max;
        final List<Interval<Term, SSTableIndex>> intervals = new ArrayList<Interval<Term, SSTableIndex>>();

        protected Builder(AbstractType<?> comparator) {
            this.comparator = comparator;
        }

        public final void add(SSTableIndex index) {
            this.addIndex(index);
            this.min = this.min == null || TypeUtil.compare(this.min, index.minTerm(), this.comparator) > 0 ? index.minTerm() : this.min;
            this.max = this.max == null || TypeUtil.compare(this.max, index.maxTerm(), this.comparator) < 0 ? index.maxTerm() : this.max;
        }

        public void addIndex(SSTableIndex index) {
            Interval<Term, SSTableIndex> interval = Interval.create(new Term(index.minTerm(), this.comparator), new Term(index.maxTerm(), this.comparator), index);
            if (logger.isTraceEnabled()) {
                IndexContext context = index.getIndexContext();
                logger.trace(context.logMessage("Adding index for SSTable {} with minTerm={} and maxTerm={}..."), new Object[]{index.getSSTable().descriptor, this.comparator.compose(index.minTerm()), this.comparator.compose(index.maxTerm())});
            }
            this.intervals.add(interval);
        }

        public RangeTermTree build() {
            return new RangeTermTree(this.min, this.max, IntervalTree.build(this.intervals), this.comparator);
        }
    }
}

