/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.IndexValidation;
import org.apache.cassandra.index.sai.SSTableContext;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.view.View;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexViewManager {
    private static final Logger logger = LoggerFactory.getLogger(IndexViewManager.class);
    private final IndexContext context;
    private final AtomicReference<View> view = new AtomicReference();

    public IndexViewManager(IndexContext context) {
        this.context = context;
        this.view.set(new View(context, Collections.emptySet()));
    }

    public View getView() {
        return this.view.get();
    }

    public Collection<SSTableContext> update(Collection<SSTableReader> oldSSTables, Collection<SSTableContext> newSSTableContexts, IndexValidation validation) {
        View newView;
        View currentView;
        Pair<Collection<SSTableIndex>, Collection<SSTableContext>> indexes = this.context.getBuiltIndexes(newSSTableContexts, validation);
        HashSet<SSTableIndex> newViewIndexes = new HashSet<SSTableIndex>();
        ArrayList<SSTableIndex> releasableIndexes = new ArrayList<SSTableIndex>();
        do {
            currentView = this.view.get();
            newViewIndexes.clear();
            releasableIndexes.clear();
            for (SSTableIndex sstableIndex : currentView) {
                SSTableReader sstable = sstableIndex.getSSTable();
                if (oldSSTables.contains(sstable) || newViewIndexes.contains(sstableIndex)) {
                    releasableIndexes.add(sstableIndex);
                    continue;
                }
                newViewIndexes.add(sstableIndex);
            }
            for (SSTableIndex sstableIndex : (Collection)indexes.left) {
                if (newViewIndexes.contains(sstableIndex)) {
                    releasableIndexes.add(sstableIndex);
                    continue;
                }
                newViewIndexes.add(sstableIndex);
            }
        } while (!this.view.compareAndSet(currentView, newView = new View(this.context, newViewIndexes)));
        releasableIndexes.forEach(SSTableIndex::release);
        if (logger.isTraceEnabled()) {
            logger.trace(this.context.logMessage("There are now {} active SSTable indexes."), (Object)this.view.get().getIndexes().size());
        }
        return (Collection)indexes.right;
    }

    public void drop(Collection<SSTableReader> sstablesToRebuild) {
        View currentView = this.view.get();
        HashSet<SSTableReader> toRemove = new HashSet<SSTableReader>(sstablesToRebuild);
        for (SSTableIndex index : currentView) {
            SSTableReader sstable = index.getSSTable();
            if (!toRemove.contains(sstable)) continue;
            index.markObsolete();
        }
        this.update(toRemove, Collections.emptyList(), IndexValidation.NONE);
    }

    public void invalidate() {
        View previousView = this.view.getAndSet(new View(this.context, Collections.emptyList()));
        for (SSTableIndex index : previousView) {
            index.markObsolete();
        }
    }
}

