/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.vector;

import com.google.common.collect.Iterables;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.disk.SSTableIndex;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.utils.PrimaryKey;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointingIterator
extends KeyRangeIterator {
    private static final Logger logger = LoggerFactory.getLogger(CheckpointingIterator.class);
    private final QueryContext context;
    private final KeyRangeIterator union;
    private final Iterable<SSTableIndex> referencedIndexes;

    public CheckpointingIterator(KeyRangeIterator wrapped, Iterable<SSTableIndex> referencedIndexes, Iterable<SSTableIndex> referencedAnnIndexesInHybridSearch, QueryContext queryContext) {
        super(wrapped.getMinimum(), wrapped.getMaximum(), wrapped.getCount());
        this.union = wrapped;
        this.referencedIndexes = referencedAnnIndexesInHybridSearch != null ? Iterables.concat(referencedIndexes, referencedAnnIndexesInHybridSearch) : referencedIndexes;
        this.context = queryContext;
    }

    @Override
    protected PrimaryKey computeNext() {
        try {
            PrimaryKey primaryKey = this.union.hasNext() ? (PrimaryKey)this.union.next() : (PrimaryKey)this.endOfData();
            return primaryKey;
        }
        finally {
            this.context.checkpoint();
        }
    }

    @Override
    protected void performSkipTo(PrimaryKey nextKey) {
        try {
            this.union.skipTo(nextKey);
        }
        finally {
            this.context.checkpoint();
        }
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.union);
        this.referencedIndexes.forEach(CheckpointingIterator::releaseQuietly);
    }

    private static void releaseQuietly(SSTableIndex index) {
        try {
            index.release();
        }
        catch (Throwable e) {
            logger.error(index.getIndexContext().logMessage(String.format("Failed to release index on SSTable %s", index.getSSTable())), e);
        }
    }
}

