/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.segment;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.index.sai.IndexContext;
import org.apache.cassandra.index.sai.QueryContext;
import org.apache.cassandra.index.sai.disk.PrimaryKeyMap;
import org.apache.cassandra.index.sai.disk.format.IndexComponent;
import org.apache.cassandra.index.sai.disk.v1.PerColumnIndexFiles;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeQueries;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeReader;
import org.apache.cassandra.index.sai.disk.v1.segment.IndexSegmentSearcher;
import org.apache.cassandra.index.sai.disk.v1.segment.SegmentMetadata;
import org.apache.cassandra.index.sai.iterators.KeyRangeIterator;
import org.apache.cassandra.index.sai.metrics.MulticastQueryEventListeners;
import org.apache.cassandra.index.sai.metrics.QueryEventListener;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.lucene.index.CorruptIndexException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericIndexSegmentSearcher
extends IndexSegmentSearcher {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final BlockBalancedTreeReader treeReader;
    private final QueryEventListener.BalancedTreeEventListener perColumnEventListener;

    NumericIndexSegmentSearcher(PrimaryKeyMap.Factory primaryKeyMapFactory, PerColumnIndexFiles perIndexFiles, SegmentMetadata segmentMetadata, IndexContext indexContext) throws IOException {
        super(primaryKeyMapFactory, perIndexFiles, segmentMetadata, indexContext);
        long treePosition = this.metadata.getIndexRoot(IndexComponent.BALANCED_TREE);
        if (treePosition < 0L) {
            throw new CorruptIndexException(indexContext.logMessage("The tree position is less than zero."), IndexComponent.BALANCED_TREE.name);
        }
        long postingsPosition = this.metadata.getIndexRoot(IndexComponent.POSTING_LISTS);
        if (postingsPosition < 0L) {
            throw new CorruptIndexException(indexContext.logMessage("The postings position is less than zero."), IndexComponent.BALANCED_TREE.name);
        }
        this.treeReader = new BlockBalancedTreeReader(indexContext, this.indexFiles.balancedTree(), treePosition, this.indexFiles.postingLists(), postingsPosition);
        this.perColumnEventListener = (QueryEventListener.BalancedTreeEventListener)((Object)indexContext.getColumnQueryMetrics());
    }

    @Override
    public long indexFileCacheSize() {
        return this.treeReader.memoryUsage();
    }

    @Override
    public KeyRangeIterator search(Expression exp, AbstractBounds<PartitionPosition> keyRange, QueryContext context) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace(this.indexContext.logMessage("Searching on expression '{}'..."), (Object)exp);
        }
        if (exp.getOp().isEqualityOrRange()) {
            BlockBalancedTreeReader.IntersectVisitor query = BlockBalancedTreeQueries.balancedTreeQueryFrom(exp, this.treeReader.getBytesPerValue());
            QueryEventListener.BalancedTreeEventListener listener = MulticastQueryEventListeners.of(context, this.perColumnEventListener);
            return this.toPrimaryKeyIterator(this.treeReader.intersect(query, listener, context), context);
        }
        throw new IllegalArgumentException(this.indexContext.logMessage("Unsupported expression during index query: " + exp));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("indexContext", (Object)this.indexContext).add("count", this.treeReader.getPointCount()).add("bytesPerValue", this.treeReader.getBytesPerValue()).toString();
    }

    @Override
    public void close() {
        this.treeReader.close();
    }
}

